/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.flatfile.extension.types;

import com.google.common.base.Optional;
import com.mulesoft.flatfile.lexical.TypeFormat;
import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.schema.fftypes.BooleanFormat$;
import com.mulesoft.flatfile.schema.fftypes.DemoSupport;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.flatfile.FieldFormatAnnotation;
import org.mule.tooling.ui.flatfile.extension.FixedWidthTableElement;
import org.mule.tooling.ui.flatfile.extension.types.FixedWidthTypeEditor;
import org.mule.tooling.ui.utils.ControlFactory;
import org.mule.tooling.ui.widgets.treetable.ContentType;
import org.mule.tooling.ui.widgets.util.FormLayoutUtils;

public class BooleanFixedWidthTypeEditor
extends Composite
implements FixedWidthTypeEditor {
    private Spinner widthSpinner;
    private Button alignLeft;
    private Button alignRight;
    private StyledText previewExample;
    private Button caseSensitive;
    private StyledText trueStyledText;
    private StyledText falseStyledText;
    private ContentType<MetadataType> type;
    private FixedWidthTableElement<?> element;
    private String previewSampleInput = "true";

    public BooleanFixedWidthTypeEditor(Composite parent, FixedWidthTableElement<?> element, ContentType<MetadataType> type) {
        super(parent, 0);
        this.element = element;
        this.type = type;
        this.createControl();
        this.initialize(element);
    }

    @Override
    public ContentType<MetadataType> getType() {
        return this.type;
    }

    protected void createControl() {
        PreviewListener previewListener = new PreviewListener();
        this.setLayout((Layout)FormLayoutUtils.formLayout());
        ControlFactory controls = ControlFactory.createChildsOf((Composite)this);
        this.widthSpinner = controls.spinner();
        this.widthSpinner.setMinimum(1);
        this.widthSpinner.addSelectionListener((SelectionListener)previewListener);
        FormLayoutUtils.attach((Control)this.widthSpinner).top().left(50);
        Label widthLabel = controls.label("Width");
        FormLayoutUtils.attach((Control)widthLabel).alignMiddle((Control)this.widthSpinner).left();
        Label alignLabel = controls.label("Align");
        this.alignLeft = controls.radio("Left", (SelectionListener)previewListener);
        this.alignRight = controls.radio("Right", (SelectionListener)previewListener);
        FormLayoutUtils.attach((Control)alignLabel).leftFrom((Control)this.widthSpinner, 20).alignMiddle((Control)this.widthSpinner);
        FormLayoutUtils.attach((Control)this.alignLeft).leftFrom((Control)alignLabel, 2).top();
        FormLayoutUtils.attach((Control)this.alignRight).leftFrom((Control)this.alignLeft, 2).top();
        Label mappingsLabel = controls.label("Mappings");
        FormLayoutUtils.attach((Control)mappingsLabel).topFrom((Control)widthLabel, 12);
        Label trueLabel = controls.label("True");
        this.trueStyledText = controls.styledTextSingleLine((SelectionListener)previewListener);
        Label falseLabel = controls.label("False");
        this.falseStyledText = controls.styledTextSingleLine((SelectionListener)previewListener);
        FormLayoutUtils.attach((Control)trueLabel).topFrom((Control)mappingsLabel, 12).left(20);
        FormLayoutUtils.attach((Control)this.trueStyledText).topFrom((Control)mappingsLabel, 12).leftFrom((Control)trueLabel, 2).alignMiddle((Control)trueLabel);
        FormLayoutUtils.attach((Control)falseLabel).topFrom((Control)mappingsLabel, 12).leftFrom((Control)this.trueStyledText, 2).alignMiddle((Control)this.trueStyledText);
        FormLayoutUtils.attach((Control)this.falseStyledText).topFrom((Control)mappingsLabel, 12).leftFrom((Control)falseLabel, 2).alignMiddle((Control)falseLabel);
        this.caseSensitive = controls.check("Input is case sensitive", (SelectionListener)previewListener);
        FormLayoutUtils.attach((Control)this.caseSensitive).topFrom((Control)trueLabel, 12).left(20);
        Label previewLabel = controls.label("Preview");
        Label editHint = controls.label("Double click to edit sample");
        editHint.setForeground(Display.getCurrent().getSystemColor(33));
        FormLayoutUtils.attach((Control)previewLabel).topFrom((Control)this.caseSensitive, 12);
        FormLayoutUtils.attach((Control)editHint).topFrom((Control)this.caseSensitive, 12).right();
        this.previewExample = controls.styledText();
        this.previewExample.addMouseListener((MouseListener)new PreviewMouseAdapter());
        this.previewExample.addKeyListener((KeyListener)new PreviewKeyAdapter());
        this.previewExample.setEditable(false);
        this.previewExample.setToolTipText("Sample value - Double click to edit");
        FormLayoutUtils.attach((Control)this.previewExample).topFrom((Control)previewLabel, 5).left().right();
    }

    @Override
    public void refresh() {
        this.initialize(this.element);
    }

    private void initialize(FixedWidthTableElement<?> element) {
        this.widthSpinner.setSelection(element.getWidth());
        this.alignLeft.setSelection(false);
        this.alignRight.setSelection(false);
        Optional<TypeFormatConstants.FillMode> alignMaybe = element.getAlign();
        Optional<String> trueRepresentationMaybe = element.getTrueRepresentation();
        Optional<String> falseRepresentationMaybe = element.getFalseRepresentation();
        Optional<Boolean> caseSensitiveMaybe = element.getCaseSensitive();
        this.configureAlignment(alignMaybe.isPresent() ? (TypeFormatConstants.FillMode)alignMaybe.get() : null);
        this.trueStyledText.setText(trueRepresentationMaybe.isPresent() ? (String)trueRepresentationMaybe.get() : "true");
        this.falseStyledText.setText(falseRepresentationMaybe.isPresent() ? (String)falseRepresentationMaybe.get() : "false");
        this.caseSensitive.setSelection(caseSensitiveMaybe.isPresent() ? (Boolean)caseSensitiveMaybe.get() : false);
        this.previewExample.setText("\n" + this.applyFormats(this.previewSampleInput) + "\n");
    }

    private void configureAlignment(TypeFormatConstants.FillMode fillMode) {
        switch (fillMode) {
            case LEFT: {
                this.alignLeft.setSelection(true);
                break;
            }
            case RIGHT: {
                this.alignRight.setSelection(true);
                break;
            }
            default: {
                this.alignLeft.setSelection(true);
                this.alignRight.setSelection(false);
            }
        }
    }

    private TypeFormatConstants.FillMode getAlignment() {
        return this.alignLeft.getSelection() ? TypeFormatConstants.FillMode.LEFT : TypeFormatConstants.FillMode.RIGHT;
    }

    private String applyFormats(String input) {
        try {
            TypeFormatConstants.FillMode fillMode = this.getAlignment();
            TypeFormat formatter = BooleanFormat$.MODULE$.apply(this.widthSpinner.getSelection(), this.trueStyledText.getText(), this.falseStyledText.getText(), this.caseSensitive.getSelection(), fillMode);
            String previewResult = DemoSupport.writeString((Object)Boolean.valueOf(input.toLowerCase()), (TypeFormat)formatter);
            previewResult = previewResult.replace(' ', '.');
            return previewResult;
        }
        catch (Exception e) {
            return "Preview Error: " + e.getMessage();
        }
    }

    @Override
    public FixedWidthTableElement<?> getResult() {
        FieldFormatAnnotation formats = new FieldFormatAnnotation(Integer.valueOf(this.widthSpinner.getSelection()));
        formats.withAlign(this.getAlignment().name());
        formats.withTrueRepresentation(this.trueStyledText.getText());
        formats.withFalseRepresentation(this.falseStyledText.getText());
        formats.withCaseSensitive(Boolean.valueOf(this.caseSensitive.getSelection()));
        return new FixedWidthTableElement<MetadataType>(this.element.getQname(), this.type, formats);
    }

    private final class PreviewKeyAdapter
    extends KeyAdapter {
        private PreviewKeyAdapter() {
        }

        public void keyReleased(KeyEvent e) {
            if (e.character == '\r') {
                BooleanFixedWidthTypeEditor.this.previewExample.setEditable(false);
                BooleanFixedWidthTypeEditor.this.previewSampleInput = BooleanFixedWidthTypeEditor.this.previewExample.getText().replaceAll("\\r\\n|\\r|\\n", "");
                BooleanFixedWidthTypeEditor.this.previewExample.setText("\n" + BooleanFixedWidthTypeEditor.this.applyFormats(BooleanFixedWidthTypeEditor.this.previewSampleInput) + "\n");
            }
        }
    }

    private final class PreviewListener
    extends SelectionAdapter {
        private PreviewListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            BooleanFixedWidthTypeEditor.this.previewExample.setText("\n" + BooleanFixedWidthTypeEditor.this.applyFormats(BooleanFixedWidthTypeEditor.this.previewSampleInput) + "\n");
        }
    }

    private final class PreviewMouseAdapter
    extends MouseAdapter {
        private PreviewMouseAdapter() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            BooleanFixedWidthTypeEditor.this.previewExample.setText(BooleanFixedWidthTypeEditor.this.previewSampleInput);
            BooleanFixedWidthTypeEditor.this.previewExample.setEditable(true);
        }
    }
}

