/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.flatfile.extension.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.MetadataFormats;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.flatfile.FlatfileTypeLoader;
import org.mule.metadata.flatfile.SchemaConstructAnnotation;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.dFL.Options;
import org.mule.tooling.dfl.ui.contentassist.model.types.DFLTypeFactory;
import org.mule.tooling.dfl.ui.module.DataWeaveTextOutputViewer;
import org.mule.tooling.dfl.ui.module.IOutputViewer;
import org.mule.tooling.dfl.ui.module.IWeaveUIModule;
import org.mule.tooling.dfl.ui.module.WeaveUIModule;
import org.mule.tooling.dfl.ui.viewers.DefaultViewerFactory;
import org.mule.tooling.dfl.ui.viewers.IViewerFactory;
import org.mule.tooling.metadata.annotations.ElementAnnotation;
import org.mule.tooling.metadata.annotations.PathAnnotation;
import org.mule.tooling.mule.json.schemas.FlatFileSchemaUtils;
import org.mule.tooling.weave.engine.ModuleOption;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.module.flatfile.FlatFileDataFormat;

public class FlatFileUIModule
extends WeaveUIModule {
    private static final String SCHEMA_PATH_OPTION = "schemaPath";
    private static final String SEGMENT_IDENT_OPTION = "segmentIdent";
    private static final String STRUCTURE_IDENT_OPTION = "structureIdent";

    public FlatFileUIModule() {
        super((IViewerFactory)new DefaultViewerFactory(), (DataFormat)new FlatFileDataFormat());
    }

    public List<MetadataFormat> getMetadataFormat() {
        return Arrays.asList(MetadataFormats.FIXED_WIDTH, MetadataFormats.FLAT_FILE, MetadataFormats.COPYBOOK);
    }

    public Map<String, Object> getValuesForOptions(MetadataType metadataType, Options options, IMuleProject project) {
        LinkedHashMap<String, Object> newOptions = new LinkedHashMap<String, Object>();
        Optional maybePathAnnotation = metadataType.getAnnotation(PathAnnotation.class);
        Optional maybeSchemaConstructAnnotation = metadataType.getAnnotation(SchemaConstructAnnotation.class);
        Optional maybeElementAnnotation = metadataType.getAnnotation(ElementAnnotation.class);
        if (maybePathAnnotation.isPresent()) {
            newOptions.put(SCHEMA_PATH_OPTION, ((PathAnnotation)maybePathAnnotation.get()).getPath());
        } else {
            Optional maybeExistingValue = this.getExistingValueForOption(options, SCHEMA_PATH_OPTION);
            if (maybeExistingValue.isPresent()) {
                newOptions.put(SCHEMA_PATH_OPTION, maybeExistingValue.get());
            }
        }
        if (maybeSchemaConstructAnnotation.isPresent() && maybeElementAnnotation.isPresent()) {
            SchemaConstructAnnotation annotation = (SchemaConstructAnnotation)maybeSchemaConstructAnnotation.get();
            newOptions.put(SchemaConstructAnnotation.SchemaConstruct.STRUCTURE.equals((Object)annotation.getValue()) ? STRUCTURE_IDENT_OPTION : SEGMENT_IDENT_OPTION, ((ElementAnnotation)maybeElementAnnotation.get()).getElement());
        } else {
            Optional maybeExistingValueForStructureIdent = this.getExistingValueForOption(options, STRUCTURE_IDENT_OPTION);
            Optional maybeExistingValueForSegmentIdent = this.getExistingValueForOption(options, SEGMENT_IDENT_OPTION);
            if (maybeExistingValueForStructureIdent.isPresent()) {
                newOptions.put(STRUCTURE_IDENT_OPTION, maybeExistingValueForStructureIdent.get());
            } else if (maybeExistingValueForSegmentIdent.isPresent()) {
                newOptions.put(SEGMENT_IDENT_OPTION, maybeExistingValueForSegmentIdent.get());
            }
        }
        return newOptions;
    }

    protected boolean isValidOption(ModuleOption moduleOption, MetadataType metadataType) {
        boolean isSchemaPath = moduleOption.getName().equals(SCHEMA_PATH_OPTION);
        boolean isSegmentIdent = moduleOption.getName().equals(SEGMENT_IDENT_OPTION);
        boolean isStructureIdent = moduleOption.getName().equals(STRUCTURE_IDENT_OPTION);
        if (!(isSchemaPath || isSegmentIdent || isStructureIdent)) {
            return true;
        }
        MetadataFormat metadataFormat = metadataType.getMetadataFormat();
        boolean isFixedWidth = FlatfileTypeLoader.FIXED_WIDTH.equals((Object)metadataFormat);
        boolean isCopybook = FlatfileTypeLoader.COPYBOOK.equals((Object)metadataFormat);
        boolean isFlatFile = FlatfileTypeLoader.FLAT_FILE.equals((Object)metadataFormat);
        Optional maybeFlatFileIdent = FlatFileSchemaUtils.getStructureComponent((MetadataType)metadataType);
        return maybeFlatFileIdent.map(ident -> isFixedWidth && !isSchemaPath || isCopybook && !isSchemaPath && (!FlatFileSchemaUtils.FlatFileIdent.SEGMENT.equals(ident) || !isSegmentIdent) && (!FlatFileSchemaUtils.FlatFileIdent.STRUCTURE.equals(ident) || !isStructureIdent) || isFlatFile && !isSchemaPath && (!FlatFileSchemaUtils.FlatFileIdent.SEGMENT.equals(ident) || !isSegmentIdent) && (!FlatFileSchemaUtils.FlatFileIdent.STRUCTURE.equals(ident) || !isStructureIdent) ? false : super.isValidOption(moduleOption, metadataType)).orElse(false);
    }

    public Map<String, ModuleOption> getReaderProperties(MetadataType metadataType) {
        Map properties = super.getReaderProperties(metadataType);
        if (properties.isEmpty()) {
            this.putCommonProperties(properties);
        }
        return properties;
    }

    public Map<String, ModuleOption> getWriterProperties(MetadataType metadataType) {
        Map properties = super.getWriterProperties(metadataType);
        if (properties.isEmpty()) {
            this.putCommonProperties(properties);
        }
        return properties;
    }

    public IOutputViewer getOutputPreviewViewer() {
        return new DataWeaveTextOutputViewer((IWeaveUIModule)this);
    }

    private void putCommonProperties(Map<String, ModuleOption> properties) {
        properties.put(SCHEMA_PATH_OPTION, new ModuleOption(SCHEMA_PATH_OPTION, DFLTypeFactory.STRING.getName(), (Object)"\"", "", new ArrayList()));
        properties.put(SEGMENT_IDENT_OPTION, new ModuleOption(SEGMENT_IDENT_OPTION, DFLTypeFactory.STRING.getName(), (Object)"\"", "", new ArrayList()));
        properties.put(STRUCTURE_IDENT_OPTION, new ModuleOption(STRUCTURE_IDENT_OPTION, DFLTypeFactory.STRING.getName(), (Object)"\"", "", new ArrayList()));
    }
}

