/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.flatfile.extension.format;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.metadata.MetadataTypeHelper;
import org.mule.tooling.ui.flatfile.contribution.FixedWidthTypesManager;
import org.mule.tooling.ui.flatfile.extension.FixedWidthTableElement;
import org.mule.tooling.ui.flatfile.extension.types.BooleanFixedWidthTypeEditorFactory;
import org.mule.tooling.ui.flatfile.extension.types.DateFixedWidthTypeEditorFactory;
import org.mule.tooling.ui.flatfile.extension.types.DateTimeFixedWidthTypeEditorFactory;
import org.mule.tooling.ui.flatfile.extension.types.DecimalFixedWidthTypeEditorFactory;
import org.mule.tooling.ui.flatfile.extension.types.FixedWidthFormatsHelper;
import org.mule.tooling.ui.flatfile.extension.types.FixedWidthTypeEditor;
import org.mule.tooling.ui.flatfile.extension.types.FixedWidthTypeEditorFactory;
import org.mule.tooling.ui.flatfile.extension.types.IntegerFixedWidthTypeEditorFactory;
import org.mule.tooling.ui.flatfile.extension.types.StringFixedWidthTypeEditorFactory;
import org.mule.tooling.ui.utils.ControlFactory;
import org.mule.tooling.ui.utils.UiUtils;
import org.mule.tooling.ui.widgets.treetable.ContentType;
import org.mule.tooling.ui.widgets.util.FormLayoutUtils;
import org.mule.tooling.utils.OsDetect;

public class FixedWidthFormatsDialog
extends Dialog {
    private static final String DIALOG_TITLE = "Format";
    private FixedWidthTypeEditor typeEditor;
    private FixedWidthTableElement<Object> element;
    private static Map<String, FixedWidthTypeEditorFactory> typeEditorFactories = new HashMap<String, FixedWidthTypeEditorFactory>();
    private Combo typeCombo;
    private FixedWidthTableElement<?> result;

    static {
        FixedWidthTypesManager typesManager = new FixedWidthTypesManager();
        for (ContentType<MetadataType> type : typesManager.getTypes()) {
            typeEditorFactories.put(type.getLabel(), FixedWidthFormatsDialog.buildFactory(type));
        }
    }

    public FixedWidthFormatsDialog(FixedWidthTableElement<Object> element) {
        super(Display.getDefault().getActiveShell());
        this.element = element;
        this.setShellStyle(0x10000000 | this.getShellStyle());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DIALOG_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        String elementTypeName = this.element.getType().getLabel();
        List<String> typeLabels = this.typeLabels();
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        int horizontalMargin = this.convertHorizontalDLUsToPixels(7);
        int verticalMargin = this.convertVerticalDLUsToPixels(7);
        composite.setLayout((Layout)FormLayoutUtils.formLayout((int)horizontalMargin, (int)verticalMargin));
        ControlFactory controls = ControlFactory.createChildsOf((Composite)composite);
        FormLayoutUtils.attach((Control)controls.label("Type")).top(4);
        this.typeCombo = controls.dropdown(typeLabels);
        FormLayoutUtils.attach((Control)this.typeCombo).left(50).right();
        final Composite typeEditorWrapper = controls.composite((Layout)new FillLayout());
        this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (typeEditorWrapper.isDisposed()) {
                    return;
                }
                UiUtils.disposeAll((Control[])typeEditorWrapper.getChildren());
                String selectedType = FixedWidthFormatsDialog.this.typeCombo.getText();
                FixedWidthFormatsDialog.this.typeEditor = typeEditorFactories.get(selectedType).create(typeEditorWrapper, FixedWidthFormatsDialog.this.element);
                ContentType<MetadataType> type = FixedWidthFormatsDialog.this.typeEditor.getType();
                FixedWidthFormatsDialog.this.element.setType(type);
                FixedWidthFormatsDialog.this.element.setFormats(FixedWidthFormatsHelper.buildDefaultFormatOptions((MetadataType)FixedWidthFormatsDialog.this.typeEditor.getType().getModel()));
                FixedWidthFormatsDialog.this.typeEditor.refresh();
                FixedWidthFormatsDialog.applyDialogFont((Control)typeEditorWrapper);
                typeEditorWrapper.layout(true);
            }
        });
        FormLayoutUtils.attach((Control)typeEditorWrapper).left().right().bottom(-verticalMargin).topFrom((Control)this.typeCombo, verticalMargin - 5);
        typeEditorWrapper.setBackground(Display.getDefault().getSystemColor(13));
        this.typeEditor = typeEditorFactories.get(elementTypeName).create(typeEditorWrapper, this.element);
        this.typeCombo.select(typeLabels.indexOf(elementTypeName));
        FixedWidthFormatsDialog.applyDialogFont((Control)composite);
        typeEditorWrapper.layout(true);
        return composite;
    }

    protected void okPressed() {
        this.result = this.typeEditor.getResult();
        super.okPressed();
    }

    public FixedWidthTableElement<?> getResult() {
        return this.result;
    }

    private static FixedWidthTypeEditorFactory buildFactory(ContentType<MetadataType> container) {
        FixedWidthTypeEditorFactory factory = null;
        MetadataType metadataType = (MetadataType)container.getModel();
        if (MetadataTypeHelper.isAssignable((MetadataType)FixedWidthTypesManager.STRING_TYPE, (MetadataType)metadataType)) {
            factory = new StringFixedWidthTypeEditorFactory(container);
        } else if (MetadataTypeHelper.isAssignable((MetadataType)FixedWidthTypesManager.INTEGER_TYPE, (MetadataType)metadataType)) {
            factory = new IntegerFixedWidthTypeEditorFactory(container);
        } else if (MetadataTypeHelper.isAssignable((MetadataType)FixedWidthTypesManager.BOOLEAN_TYPE, (MetadataType)metadataType)) {
            factory = new BooleanFixedWidthTypeEditorFactory(container);
        } else if (MetadataTypeHelper.isAssignable((MetadataType)FixedWidthTypesManager.DECIMAL_TYPE, (MetadataType)metadataType)) {
            factory = new DecimalFixedWidthTypeEditorFactory(container);
        } else if (MetadataTypeHelper.isAssignable((MetadataType)FixedWidthTypesManager.DATE_TYPE, (MetadataType)metadataType)) {
            factory = new DateFixedWidthTypeEditorFactory(container);
        } else if (MetadataTypeHelper.isAssignable((MetadataType)FixedWidthTypesManager.DATETIME_TYPE, (MetadataType)metadataType)) {
            factory = new DateTimeFixedWidthTypeEditorFactory(container);
        }
        return factory;
    }

    private List<String> typeLabels() {
        List<ContentType<MetadataType>> types = new FixedWidthTypesManager().getTypes();
        ArrayList<String> list = new ArrayList<String>(types.size());
        for (ContentType<MetadataType> type : types) {
            list.add(type.getLabel());
        }
        return list;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Point getInitialSize() {
        if (OsDetect.getOperatingSystemType() == OsDetect.OsType.Windows) {
            return new Point(600, 550);
        }
        return new Point(400, 300);
    }
}

