/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.flatfile.extension.copybook;

import com.google.common.base.Preconditions;
import com.mulesoft.flatfile.schema.fftools.CopybookImport;
import com.mulesoft.flatfile.schema.fftools.CopybookImportError;
import com.mulesoft.flatfile.schema.model.Copybook$;
import com.mulesoft.flatfile.schema.model.EdiForm$;
import com.mulesoft.flatfile.schema.model.EdiFormConverter;
import com.mulesoft.flatfile.schema.model.EdiSchema;
import com.mulesoft.flatfile.schema.model.Segment;
import com.mulesoft.flatfile.schema.yaml.YamlReader;
import com.mulesoft.flatfile.schema.yaml.YamlWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.flatfile.FlatfileTypeLoader;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.client.metadata.MetadataTypeFormat;
import org.mule.tooling.client.metadata.MetadataTypeOrigin;
import org.mule.tooling.client.metadata.MetadataTypeProxy;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.messageflow.metadata.MetadataTypeGraphicalChildrenProvider;
import org.mule.tooling.metadata.annotations.ElementAnnotation;
import org.mule.tooling.metadata.annotations.FormatAnnotation;
import org.mule.tooling.metadata.annotations.OriginAnnotation;
import org.mule.tooling.metadata.annotations.PathAnnotation;
import org.mule.tooling.ui.flatfile.contribution.FlatFileMetadataTypeBuilder;
import org.mule.tooling.ui.flatfile.extension.copybook.CopybookValidationErrorProvider;
import org.mule.tooling.ui.flatfile.extension.copybook.CopybookValidationFeedback;
import org.mule.tooling.ui.modules.core.metadata.definition.ChangeManager;
import org.mule.tooling.ui.modules.core.metadata.definition.IMetadataDefinitionValidator;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataResult;
import org.mule.tooling.ui.modules.core.metadata.definition.OnValidationMessage;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.BaseMetadataDefinitionEditor;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.ModeElement;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.Resource;
import org.mule.tooling.ui.widgets.action.DisposableToolbarManager;
import org.mule.tooling.ui.widgets.errors.ErrorItem;
import org.mule.tooling.ui.widgets.errors.ErrorManager;
import org.mule.tooling.ui.widgets.errors.ErrorType;
import org.mule.tooling.ui.widgets.listener.IdleModifyEventListener;
import scala.Option;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;

public class CopyBookMetadataDefinitionEditor
extends BaseMetadataDefinitionEditor {
    private ValidatingModeElement fromImportElement = new FromImportElement();
    private ValidatingModeElement fromSchemaElement = new FromSchemaElement();
    private ValidatingModeElement[] modes = new ValidatingModeElement[]{this.fromImportElement, this.fromSchemaElement};
    private Text filePath;
    private ComboViewer modeComboViewer;
    private ComboViewer segmentCombo;
    private TreeViewer detailsTree;
    private Optional<MetadataType> editedModel;
    private ErrorManager<ErrorType, ErrorItem> errorManager;
    private Button openSchemaButton;
    private Label messageLabel;
    private List<Resource> resources = Collections.emptyList();

    public CopyBookMetadataDefinitionEditor(Composite parent, IMuleProject project, IMetadataDefinitionValidator editorValidator, ChangeManager changeManager, String key, OnValidationMessage onValidationMessage) {
        super(parent, project, editorValidator, changeManager, key, onValidationMessage);
        this.createControl((Composite)this);
    }

    public MetadataResult calculateMetadata() {
        try {
            return MetadataResult.from((MetadataType)this.getSelectedMode().getMetadata());
        }
        catch (Exception e) {
            return MetadataResult.from((String)("Error creating metadata... \n" + e.getLocalizedMessage()));
        }
    }

    protected void createControl(Composite parent) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        this.createKey(parent);
        Composite wrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(wrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)wrapper);
        this.createSelectorComposite(wrapper);
        this.messageLabel = this.createMessageLabel(wrapper);
        this.createSegmentCombo(wrapper);
        this.editedModel = Optional.ofNullable(this.getMetadataTypeFromCache(this.getPreviousKey()));
        this.detailsTree = this.createDetailsTree(parent, this.editedModel);
        this.loadMode(this.editedModel);
        this.createUIListerners(wrapper);
    }

    private void createSelectorComposite(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(wrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)wrapper);
        this.createModeViewer(wrapper);
        this.filePath = new Text(wrapper, 2052);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.filePath);
        this.filePath.setMessage(this.getSelectedMode().getMessage());
        this.createErrorIndicator(wrapper);
        this.openSchemaButton = new Button(wrapper, 8);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)this.openSchemaButton);
        this.openSchemaButton.setText("...");
    }

    private void loadMode(Optional<MetadataType> maybeMetadataType) {
        MetadataType metadataType;
        Optional maybeOriginAnnotation;
        if (maybeMetadataType.isPresent() && (maybeOriginAnnotation = (metadataType = maybeMetadataType.get()).getAnnotation(OriginAnnotation.class)).isPresent()) {
            this.modeComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.fromSchemaElement));
            this.filePath.setMessage(this.getSelectedMode().getMessage());
            Optional maybePathAnnotation = metadataType.getAnnotation(PathAnnotation.class);
            if (maybePathAnnotation.isPresent()) {
                String element;
                String path = ((PathAnnotation)maybePathAnnotation.get()).getPath();
                this.filePath.setText(path);
                this.resources = Collections.singletonList(Resource.create((String)path, (File)CoreUtils.pathToFile((String)path, (IMuleProject)this.getMuleProject()), (IMuleProject)this.getMuleProject()));
                Optional maybeElement = metadataType.getAnnotation(ElementAnnotation.class);
                if (maybeElement.isPresent() && StringUtils.isNotBlank((String)(element = ((ElementAnnotation)maybeElement.get()).getElement()))) {
                    this.fillSegmentCombo();
                    this.segmentCombo.setSelection((ISelection)new StructuredSelection((Object)element));
                }
            }
        }
    }

    public void onRefresh() {
        this.refresh();
    }

    private void createUIListerners(final Composite wrapper) {
        this.filePath.addModifyListener((ModifyListener)new IdleModifyEventListener(e -> {
            String schemaPath = this.filePath.getText();
            this.resources = Collections.singletonList(Resource.create((String)schemaPath, (File)CoreUtils.pathToFile((String)schemaPath, (IMuleProject)this.getMuleProject()), (IMuleProject)this.getMuleProject()));
            this.checkFilesToCopy();
            this.fillSegmentCombo();
            this.refresh();
        }, (Control)wrapper));
        this.modeComboViewer.addSelectionChangedListener(e -> {
            ValidatingModeElement mode = this.getSelectedMode();
            this.filePath.setText("");
            this.filePath.setMessage(mode.getMessage());
            this.messageLabel.setText("");
            this.resources = Collections.emptyList();
            this.fillSegmentCombo();
            this.refresh();
        });
        this.openSchemaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[][] namesFilters = CopyBookMetadataDefinitionEditor.this.getSelectedMode().filterNamesExtensions();
                List result = CopyBookMetadataDefinitionEditor.this.filePickerButtonPressed(false, namesFilters[0], namesFilters[1], wrapper.getShell());
                if (!result.isEmpty()) {
                    CopyBookMetadataDefinitionEditor.this.messageLabel.setText("");
                    CopyBookMetadataDefinitionEditor.this.resources = result.stream().map(f -> Resource.create((String)f, (IMuleProject)CopyBookMetadataDefinitionEditor.this.getMuleProject())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
                    CopyBookMetadataDefinitionEditor.this.checkFilesToCopy();
                    CopyBookMetadataDefinitionEditor.this.filePath.setText(CopyBookMetadataDefinitionEditor.this.getFileTextFromSelectedResources(CopyBookMetadataDefinitionEditor.this.resources, "schemas"));
                }
            }
        });
        this.segmentCombo.addSelectionChangedListener(event -> this.refresh());
    }

    private void refresh() {
        this.validate();
        this.refreshPreview();
        this.recordChange();
    }

    private void createErrorIndicator(Composite wrapper) {
        Composite feedback = new Composite(wrapper, 0);
        GridLayoutFactory.fillDefaults().applyTo(feedback);
        GridDataFactory.fillDefaults().exclude(true).applyTo((Control)feedback);
        ToolBar feedbackToolbar = new ToolBar(feedback, 8519936);
        GridLayoutFactory.fillDefaults().applyTo((Composite)feedbackToolbar);
        GridDataFactory.fillDefaults().grab(false, true).align(1, 0x1000000).applyTo((Control)feedbackToolbar);
        ToolBarManager fbManager = new ToolBarManager(feedbackToolbar);
        DisposableToolbarManager targetToolbarManager = new DisposableToolbarManager((IToolBarManager)fbManager);
        this.errorManager = new ErrorManager();
        CopybookValidationFeedback action = new CopybookValidationFeedback((IToolBarManager)targetToolbarManager, new CopybookValidationErrorProvider(this.errorManager), this.errorManager, feedback);
        action.setEnabled(false);
        targetToolbarManager.add((IAction)action);
        targetToolbarManager.update(true);
        Cursor cursor = new Cursor((Device)wrapper.getDisplay(), 21);
        feedbackToolbar.setCursor(cursor);
    }

    private void refreshPreview() {
        MetadataResult metadataResult = this.calculateMetadata();
        if (metadataResult.isValid()) {
            this.editedModel = Optional.ofNullable(this.calculateMetadata().getMetadataType());
            this.detailsTree.setInput((Object)this.getRoot(this.editedModel));
            this.detailsTree.expandToLevel(4);
        }
    }

    private void createModeViewer(Composite wrapper) {
        this.modeComboViewer = new ComboViewer(wrapper);
        GridDataFactory.swtDefaults().applyTo(this.modeComboViewer.getControl());
        this.modeComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.modeComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                ModeElement mode = (ModeElement)element;
                return mode.getLabel();
            }
        });
        this.fillModeCombo();
    }

    private void createSegmentCombo(Composite wrapper) {
        this.segmentCombo = new ComboViewer(wrapper);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(4, 1).applyTo(this.segmentCombo.getControl());
        this.segmentCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fillSegmentCombo();
    }

    private ValidatingModeElement getSelectedMode() {
        StructuredSelection selection = (StructuredSelection)this.modeComboViewer.getSelection();
        return (ValidatingModeElement)selection.getFirstElement();
    }

    private void fillModeCombo() {
        this.modeComboViewer.setInput((Object)this.modes);
        this.modeComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.modes[0]));
    }

    private void fillSegmentCombo() {
        java.util.Map structs;
        EdiSchema schema = this.getSelectedSchema();
        String[] choices = new String[]{};
        if (schema != null && (choices = (structs = JavaConverters$.MODULE$.mapAsJavaMap((Map)schema.structures())).keySet().toArray(choices)).length == 0) {
            java.util.Map segments = JavaConverters$.MODULE$.mapAsJavaMap((Map)schema.segments());
            choices = segments.keySet().toArray(choices);
        }
        this.segmentCombo.setInput((Object)choices);
        if (choices.length > 0) {
            this.segmentCombo.setSelection((ISelection)new StructuredSelection((Object)choices[0]));
        }
        this.segmentCombo.refresh();
    }

    private EdiSchema getSelectedSchema() {
        File resolvedFile;
        String schemaPath = this.getSchemaPath();
        if (StringUtils.isNotBlank((String)schemaPath) && (resolvedFile = CopyBookMetadataDefinitionEditor.resolvePath((IMuleProject)this.getMuleProject(), (Resource)this.resources.get(0))) != null) {
            return this.getSelectedMode().getSchema(resolvedFile);
        }
        return null;
    }

    protected void doValidate() {
        this.errorManager.clear();
        this.getOnValidationMessage().clear();
        if (StringUtils.isNotBlank((String)this.getKey())) {
            boolean validKey = this.getEditorValidator().isValidKey("#Custom Type#", this.getKey());
            if (!validKey) {
                this.getOnValidationMessage().setValidationMessage(this.getEditorValidator().getValidationMessage("#Custom Type#", this.getKey(), "Type Id"));
            } else {
                String schemaPath = this.getSchemaPath();
                if (StringUtils.isNotBlank((String)schemaPath)) {
                    File resolvedFile = CopyBookMetadataDefinitionEditor.resolvePath((IMuleProject)this.getMuleProject(), (Resource)this.resources.get(0));
                    if (resolvedFile.exists() && !resolvedFile.isDirectory()) {
                        this.getSelectedMode().validate(resolvedFile);
                    } else {
                        String errorMessage = MessageFormat.format("The selected {0} is not a valid file path", this.getSelectedMode().getLabel().toLowerCase());
                        this.getOnValidationMessage().setValidationMessage(errorMessage);
                    }
                } else if (this.editedModel.isPresent()) {
                    this.getOnValidationMessage().clear();
                } else {
                    String errorMessage = MessageFormat.format("An input {0} file must be selected", this.getSelectedMode().getLabel().toLowerCase());
                    this.getOnValidationMessage().setValidationMessage(errorMessage);
                }
            }
        }
    }

    private String getSchemaPath() {
        return this.resources.isEmpty() ? "" : this.resources.get(0).getPath();
    }

    private void checkFilesToCopy() {
        StructuredSelection selection = (StructuredSelection)this.modeComboViewer.getSelection();
        if (selection.getFirstElement().equals(this.fromImportElement)) {
            Resource.getResourcesToCopyMessage(this.resources).ifPresent(message -> this.messageLabel.setText(message + " will be transformed into a Schema in src/main/resources/schemas"));
        } else {
            Resource.getResourcesToCopyMessage(this.resources).ifPresent(message -> this.messageLabel.setText(message + " will be copied to src/main/resources/schemas"));
        }
    }

    protected MetadataTypeGraphicalChildrenProvider createMetaDataModelGraphicalChildrenProvider() {
        return new MetadataTypeGraphicalChildrenProvider();
    }

    public void applyChanges() {
        for (Resource resource : this.resources) {
            this.getSelectedMode().applyChanges(resource);
        }
    }

    public String getResourcePath(Resource resource, String defaultFolder) {
        return resource.getPathInClasspath().orElseGet(() -> defaultFolder + "/" + MuleResourceUtils.getUniqueFileName((File)this.getResourceFolder(defaultFolder).getRawLocation().toFile(), (String)this.getSelectedMode().getSchemaName(resource)));
    }

    private final class FromImportElement
    implements ValidatingModeElement {
        private FromImportElement() {
        }

        public String getLabel() {
            return "Import";
        }

        public String getMessage() {
            return "Select the copybook file to import";
        }

        public String getFolder() {
            return "schemas";
        }

        @Override
        public String getSchemaName(Resource resource) {
            return FilenameUtils.removeExtension((String)resource.getFile().getName()) + ".ffd";
        }

        @Override
        public void applyChanges(Resource resource) {
            IFolder resourceFolder = CopyBookMetadataDefinitionEditor.this.getResourceFolder(CopyBookMetadataDefinitionEditor.this.getSelectedMode().getFolder());
            String uniqueName = MuleResourceUtils.getUniqueFileName((File)resourceFolder.getRawLocation().toFile(), (String)this.getSchemaName(resource));
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (FileWriter writer = new FileWriter(resourceFolder.getFile(uniqueName).getRawLocation().toFile());){
                    YamlWriter.write((EdiSchema)CopyBookMetadataDefinitionEditor.this.getSelectedSchema(), (String[])new String[0], (Writer)writer);
                    CopyBookMetadataDefinitionEditor.this.getResourceFolder().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error writing imported schema: " + e.getLocalizedMessage());
            }
        }

        public MetadataType getMetadata() {
            Segment segment = this.getSelectedSegment();
            HashMap<Class, Object> annotations = new HashMap<Class, Object>();
            BaseTypeBuilder metadataBuilder = MetadataFactory.newBuilder((MetadataFormat)FlatfileTypeLoader.COPYBOOK);
            FlatFileMetadataTypeBuilder fieldfact = new FlatFileMetadataTypeBuilder(null, segment, metadataBuilder);
            ArrayType metadataType = metadataBuilder.arrayType().of(fieldfact.build()).build();
            annotations.put(FormatAnnotation.class, new FormatAnnotation(MetadataTypeFormat.APPLICATION_COPYBOOK));
            annotations.put(OriginAnnotation.class, new OriginAnnotation(MetadataTypeOrigin.SCHEMA));
            annotations.put(PathAnnotation.class, new PathAnnotation(this.getResourcePathForImport(CopyBookMetadataDefinitionEditor.this.resources.get(0), this.getFolder())));
            String element = ((IStructuredSelection)CopyBookMetadataDefinitionEditor.this.segmentCombo.getSelection()).getFirstElement().toString();
            annotations.put(ElementAnnotation.class, new ElementAnnotation(element));
            return MetadataTypeProxy.proxying((MetadataType)metadataType, annotations);
        }

        @Override
        public String[][] filterNamesExtensions() {
            String[] names = new String[]{"Copybook definition template"};
            String[] extensions = new String[]{"*.*"};
            return new String[][]{names, extensions};
        }

        @Override
        public void validate(File file) {
            OnValidationMessage validationMsg = CopyBookMetadataDefinitionEditor.this.getOnValidationMessage();
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (FileInputStream is = new FileInputStream(file);){
                    CopybookImport importer = new CopybookImport((InputStream)is, StandardCharsets.UTF_8.name());
                    Tuple2 result = importer.buildSchema();
                    List problems = JavaConverters$.MODULE$.seqAsJavaList((Seq)result._2);
                    if (problems.isEmpty()) {
                        EdiSchema schema = (EdiSchema)((Option)result._1).get();
                        if (schema != null && schema.segments().size() != 0) {
                            validationMsg.clear();
                        } else {
                            validationMsg.setValidationMessage("No segment definitions in schema");
                        }
                    } else {
                        for (CopybookImportError problem : problems) {
                            ErrorItem errorItem = new ErrorItem.ErrorItemBuilder().withErrorType(ErrorType.WARNING).withTitle(problem.message()).withMessage(file.getName()).withDescription(problem.fullText()).build();
                            CopyBookMetadataDefinitionEditor.this.errorManager.addIssue((Object)ErrorType.ERROR, (Object)errorItem);
                        }
                        validationMsg.clear();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                validationMsg.setValidationMessage(e.getLocalizedMessage());
            }
        }

        @Override
        public EdiSchema getSchema(File file) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileInputStream is = new FileInputStream(file);){
                    CopybookImport importer = new CopybookImport((InputStream)is, StandardCharsets.UTF_8.name());
                    Tuple2 result = importer.buildSchema();
                    if (!((Option)result._1).isEmpty()) {
                        return (EdiSchema)((Option)result._1).get();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                MuleCorePlugin.logError((String)("Unexpected error loading Copybook metadata from: " + file.getAbsolutePath()), (Throwable)e);
            }
            return null;
        }

        private String getResourcePathForImport(Resource resource, String defaultFolder) {
            return defaultFolder + "/" + MuleResourceUtils.getUniqueFileName((File)CopyBookMetadataDefinitionEditor.this.getResourceFolder(defaultFolder).getRawLocation().toFile(), (String)this.getSchemaName(resource));
        }

        private Segment getSelectedSegment() {
            EdiSchema loadedSchema = CopyBookMetadataDefinitionEditor.this.getSelectedSchema();
            StructuredSelection selection = (StructuredSelection)CopyBookMetadataDefinitionEditor.this.segmentCombo.getSelection();
            java.util.Map segsMap = JavaConverters$.MODULE$.mapAsJavaMap((Map)loadedSchema.segments());
            if (!selection.isEmpty()) {
                return (Segment)segsMap.get(selection.getFirstElement());
            }
            if (segsMap.size() == 1) {
                return (Segment)segsMap.values().iterator().next();
            }
            throw new IllegalStateException("Must select segment to be used");
        }
    }

    private final class FromSchemaElement
    implements ValidatingModeElement {
        private static final String INVALID_SCHEMA = "Invalid schema: ";

        private FromSchemaElement() {
        }

        public String getLabel() {
            return "Schema";
        }

        public String getMessage() {
            return "Select your schema file";
        }

        public String getFolder() {
            return "schemas";
        }

        @Override
        public String getSchemaName(Resource resource) {
            return resource.getFile().getName();
        }

        @Override
        public void applyChanges(Resource resource) {
            if (!resource.isInValidResourcesFolder()) {
                IFolder resourceFolder = CopyBookMetadataDefinitionEditor.this.getResourceFolder(CopyBookMetadataDefinitionEditor.this.getSelectedMode().getFolder());
                File sourceFile = resource.getFile();
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (FileInputStream is = new FileInputStream(sourceFile);){
                        String uniqueName = MuleResourceUtils.getUniqueFileName((File)resourceFolder.getRawLocation().toFile(), (String)this.getSchemaName(resource));
                        MuleResourceUtils.createFile((IFolder)resourceFolder, (String)uniqueName, (InputStream)is);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | CoreException e) {
                    MuleCorePlugin.logError((String)"Error copying resources", (Throwable)e);
                }
            }
        }

        public MetadataType getMetadata() {
            String path = CopyBookMetadataDefinitionEditor.this.getSchemaPath();
            Objects.requireNonNull(path);
            Preconditions.checkArgument((!path.isEmpty() ? 1 : 0) != 0, (Object)"A Copybook schema should be selected");
            StructuredSelection selection = (StructuredSelection)CopyBookMetadataDefinitionEditor.this.segmentCombo.getSelection();
            Object selectedElement = selection.getFirstElement();
            String element = selectedElement.toString();
            HashMap<Class, Object> annotations = new HashMap<Class, Object>();
            FlatfileTypeLoader loader = new FlatfileTypeLoader(CopyBookMetadataDefinitionEditor.resolvePath((IMuleProject)CopyBookMetadataDefinitionEditor.this.getMuleProject(), (Resource)CopyBookMetadataDefinitionEditor.this.resources.get(0)).getAbsolutePath());
            Optional maybeMetadataType = loader.load(element);
            MetadataType metadataType = (MetadataType)maybeMetadataType.orElseThrow(() -> new IllegalArgumentException("The provided file could not be parsed as Copybook Schema"));
            annotations.put(FormatAnnotation.class, new FormatAnnotation(MetadataTypeFormat.APPLICATION_COPYBOOK));
            annotations.put(OriginAnnotation.class, new OriginAnnotation(MetadataTypeOrigin.SCHEMA));
            annotations.put(PathAnnotation.class, new PathAnnotation(CopyBookMetadataDefinitionEditor.this.getResourcePath(CopyBookMetadataDefinitionEditor.this.resources.get(0), this.getFolder())));
            annotations.put(ElementAnnotation.class, new ElementAnnotation(element));
            return MetadataTypeProxy.proxying((MetadataType)metadataType, annotations);
        }

        @Override
        public String[][] filterNamesExtensions() {
            String[] names = new String[]{"Copybook schema", "All Files (*.*)"};
            String[] extensions = new String[]{"*.ffd", "*.*"};
            return new String[][]{names, extensions};
        }

        @Override
        public void validate(File file) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileInputStream is = new FileInputStream(file);){
                    YamlReader yamlrdr = new YamlReader((EdiFormConverter)EdiForm$.MODULE$);
                    try {
                        Throwable throwable2 = null;
                        Object var7_12 = null;
                        try (InputStreamReader reader = new InputStreamReader((InputStream)is, StandardCharsets.UTF_8.name());){
                            EdiSchema schema = yamlrdr.loadYaml((Reader)reader, JavaConverters$.MODULE$.asScalaBuffer(Collections.emptyList()).toList());
                            if (schema.segments().size() == 0) {
                                CopyBookMetadataDefinitionEditor.this.getOnValidationMessage().setValidationMessage("No segment definitions in schema");
                            } else if (schema.ediVersion().ediForm() != Copybook$.MODULE$) {
                                CopyBookMetadataDefinitionEditor.this.getOnValidationMessage().setValidationMessage(INVALID_SCHEMA + String.valueOf(schema.ediVersion().ediForm()) + " not supported as Copybook schema");
                            } else {
                                CopyBookMetadataDefinitionEditor.this.getOnValidationMessage().clear();
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Exception e) {
                        CopyBookMetadataDefinitionEditor.this.getOnValidationMessage().setValidationMessage(INVALID_SCHEMA + e.getLocalizedMessage());
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                MuleCorePlugin.logError((String)"Error reading schema", (Throwable)e);
                CopyBookMetadataDefinitionEditor.this.getOnValidationMessage().setValidationMessage(e.getLocalizedMessage());
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public EdiSchema getSchema(File file) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private static interface ValidatingModeElement
    extends ModeElement {
        public String[][] filterNamesExtensions();

        public EdiSchema getSchema(File var1);

        public void validate(File var1);

        public String getSchemaName(Resource var1);

        public void applyChanges(Resource var1);
    }
}

