/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.flatfile.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.flatfile.FieldFormatAnnotation;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.ui.flatfile.contribution.FixedWidthTypesManager;
import org.mule.tooling.ui.flatfile.extension.FixedWidthTableElement;
import org.mule.tooling.ui.flatfile.extension.FixedWidthTreeEditor;
import org.mule.tooling.ui.flatfile.extension.format.FixedWidthFormatsDialog;
import org.mule.tooling.ui.flatfile.extension.types.FixedWidthFormatsHelper;
import org.mule.tooling.ui.widgets.treetable.ContentType;
import org.mule.tooling.ui.widgets.treetable.TreeTableEditorPresenter;
import org.mule.tooling.ui.widgets.treetable.TreeTableElement;
import org.mule.tooling.ui.widgets.treetable.TypedTableElement;
import org.mule.tooling.ui.widgets.treetable.TypedTreeEditorPresenter;
import org.mule.tooling.ui.widgets.treetable.TypesManager;

public class FixedWidthTreeEditorPresenter<T extends FixedWidthTreeEditor, Y>
extends TypedTreeEditorPresenter<T, Y> {
    public FixedWidthTreeEditorPresenter(TypesManager<Y> manager, IMuleProject muleProject, Optional<MetadataType> maybePreviousMetadata) {
        super(manager);
        if (maybePreviousMetadata.isPresent()) {
            this.loadPreviousValues(maybePreviousMetadata.get());
        }
    }

    private void loadPreviousValues(MetadataType previousMetadata) {
        if (previousMetadata instanceof ArrayType) {
            previousMetadata = ((ArrayType)previousMetadata).getType();
        }
        if (previousMetadata instanceof ObjectType) {
            Collection fields = ((ObjectType)previousMetadata).getFields();
            ArrayList<FixedWidthTableElement<MetadataType>> newElements = new ArrayList<FixedWidthTableElement<MetadataType>>(fields.size());
            for (ObjectFieldType field : fields) {
                QName fieldName = field.getKey().getName();
                MetadataType metadataType = field.getValue();
                ContentType<MetadataType> contentType = ((FixedWidthTypesManager)this.getManager()).getTypeFromParameterType(metadataType);
                Optional maybeFormats = field.getAnnotation(FieldFormatAnnotation.class);
                FieldFormatAnnotation formats = maybeFormats.orElseGet(() -> FixedWidthFormatsHelper.buildDefaultFormatOptions(field.getValue()));
                newElements.add(new FixedWidthTableElement<MetadataType>(fieldName, contentType, formats));
            }
            this.getElements().clear();
            this.getElements().addAll(newElements);
        }
    }

    protected TreeTableElement createElementToAdd(String name) {
        return new FixedWidthTableElement(new QName(name), (ContentType)this.getManager().getTypes().get(0), FixedWidthFormatsHelper.buildDefaultFormatOptions(MetadataFactory.STRING_TYPE));
    }

    protected void setColumsEditingSupport(T editor, final TreeViewer treeViewer) {
        super.setColumsEditingSupport(editor, treeViewer);
        ((FixedWidthTreeEditor)((Object)editor)).getWidthColumn().setLabelProvider((CellLabelProvider)new TypeElementWidthLabelProvider());
        ((FixedWidthTreeEditor)((Object)editor)).getWidthColumn().setEditingSupport((EditingSupport)new TypeElementWidthEditingSupport((ColumnViewer)treeViewer));
        ((FixedWidthTreeEditor)((Object)editor)).getFormatColumn().setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
            private Map<TreeItem, Button> buttons = new HashMap<TreeItem, Button>();

            public void update(ViewerCell cell) {
                TreeItem item = (TreeItem)cell.getItem();
                if (this.buttons.get(item) != null) {
                    this.buttons.get(item).dispose();
                }
                Button button = new Button((Composite)cell.getViewerRow().getControl(), 0);
                button.setText("...");
                button.addMouseListener((MouseListener)new FormatAction(treeViewer, (FixedWidthTableElement)((Object)item.getData())));
                this.buttons.put(item, button);
                item.addDisposeListener((DisposeListener)new ItemDisposeListener(this.buttons, item));
                TreeEditor editor = new TreeEditor(item.getParent());
                editor.minimumWidth = 25;
                editor.minimumHeight = 14;
                editor.grabVertical = false;
                editor.grabHorizontal = false;
                editor.verticalAlignment = 0x1000000;
                editor.horizontalAlignment = 0x1000000;
                editor.setEditor((Control)button, item, cell.getColumnIndex());
                editor.layout();
            }
        });
    }

    protected void updateTypedTableElement(TypedTableElement<Y> typedTableElement, ContentType<Y> contentType) {
        super.updateTypedTableElement(typedTableElement, contentType);
        FixedWidthTableElement fixedWidthTableElement = (FixedWidthTableElement)typedTableElement;
        fixedWidthTableElement.setFormats(FixedWidthFormatsHelper.buildDefaultFormatOptions((MetadataType)contentType.getModel()));
    }

    private final class FormatAction
    extends MouseAdapter {
        private TreeViewer treeViewer;
        private FixedWidthTableElement<Object> element;

        public FormatAction(TreeViewer treeViewer, FixedWidthTableElement<Object> element) {
            this.treeViewer = treeViewer;
            this.element = element;
        }

        public void mouseUp(MouseEvent e) {
            try {
                if (this.treeViewer.isCellEditorActive()) {
                    this.treeViewer.applyEditorValue();
                }
                FixedWidthFormatsDialog formatDialog = new FixedWidthFormatsDialog(this.element);
                ContentType typeBackup = this.element.getType();
                FieldFormatAnnotation formatsBackup = this.element.getFormats();
                if (formatDialog.open() == 0) {
                    FixedWidthTableElement<?> result = formatDialog.getResult();
                    this.element.setType(result.getType());
                    this.element.setFormats(result.getFormats());
                    this.treeViewer.update(this.element, null);
                    this.treeViewer.refresh();
                    FixedWidthTreeEditorPresenter.this.notify(TreeTableEditorPresenter.EditorActions.MODIFY);
                } else {
                    this.element.setType(typeBackup);
                    this.element.setFormats(formatsBackup);
                }
            }
            catch (Exception ex) {
                MuleCorePlugin.logError((String)"Exception in fixed width presenter", (Throwable)ex);
            }
        }
    }

    private final class ItemDisposeListener
    implements DisposeListener {
        private final TreeItem item;
        private Map<TreeItem, Button> buttons;

        private ItemDisposeListener(Map<TreeItem, Button> buttons, TreeItem item) {
            this.buttons = buttons;
            this.item = item;
        }

        public void widgetDisposed(DisposeEvent e) {
            if (this.buttons.get(this.item) != null) {
                this.buttons.get(this.item).dispose();
            }
        }
    }

    private final class TypeElementWidthEditingSupport
    extends EditingSupport {
        public TypeElementWidthEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected CellEditor getCellEditor(Object element) {
            return new TextCellEditor((Composite)this.getViewer().getControl(), 2048);
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            FixedWidthTableElement e = (FixedWidthTableElement)((Object)element);
            return "" + e.getWidth();
        }

        protected void setValue(Object element, Object value) {
            FixedWidthTableElement fixedElement = (FixedWidthTableElement)((Object)element);
            try {
                fixedElement.setWidth(Integer.valueOf(String.valueOf(value)));
                this.getViewer().update((Object)fixedElement, null);
                FixedWidthTreeEditorPresenter.this.notify(TreeTableEditorPresenter.EditorActions.MODIFY);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private static final class TypeElementWidthLabelProvider
    extends ColumnLabelProvider {
        private TypeElementWidthLabelProvider() {
        }

        public String getText(Object element) {
            FixedWidthTableElement e = (FixedWidthTableElement)((Object)element);
            return "" + e.getWidth();
        }
    }
}

