/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.flatfile.extension;

import com.google.common.base.Optional;
import com.mulesoft.flatfile.lexical.TypeFormat;
import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.schema.fftypes.BooleanFormat;
import com.mulesoft.flatfile.schema.fftypes.BooleanFormat$;
import com.mulesoft.flatfile.schema.fftypes.DecimalFormat;
import com.mulesoft.flatfile.schema.fftypes.DecimalFormat$;
import com.mulesoft.flatfile.schema.fftypes.IntegerFormat;
import com.mulesoft.flatfile.schema.fftypes.IntegerFormat$;
import com.mulesoft.flatfile.schema.fftypes.LocalDateFormat;
import com.mulesoft.flatfile.schema.fftypes.LocalDateFormat$;
import com.mulesoft.flatfile.schema.fftypes.LocalDateTimeFormat;
import com.mulesoft.flatfile.schema.fftypes.LocalDateTimeFormat$;
import com.mulesoft.flatfile.schema.fftypes.LocalTimeFormat;
import com.mulesoft.flatfile.schema.fftypes.LocalTimeFormat$;
import com.mulesoft.flatfile.schema.fftypes.StringFormat;
import com.mulesoft.flatfile.schema.fftypes.StringFormat$;
import com.mulesoft.flatfile.schema.model.Composite;
import com.mulesoft.flatfile.schema.model.EdiForm;
import com.mulesoft.flatfile.schema.model.EdiSchema;
import com.mulesoft.flatfile.schema.model.EdiSchemaVersion;
import com.mulesoft.flatfile.schema.model.Element;
import com.mulesoft.flatfile.schema.model.FixedElementComponent;
import com.mulesoft.flatfile.schema.model.FixedWidth$;
import com.mulesoft.flatfile.schema.model.Rule;
import com.mulesoft.flatfile.schema.model.Segment;
import com.mulesoft.flatfile.schema.model.Structure;
import com.mulesoft.flatfile.schema.model.Usage;
import com.mulesoft.flatfile.schema.model.Usage$;
import com.mulesoft.flatfile.schema.yaml.YamlWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.flatfile.FlatfileTypeLoader;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.ui.flatfile.contribution.FixedWidthMetadataTypeBuilder;
import org.mule.tooling.ui.flatfile.extension.FixedWidthTableElement;
import org.mule.tooling.ui.widgets.treetable.TreeTableElement;
import scala.Option;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;

public class FixedWidthSchemaBuilder {
    private static final String FIXED_WIDTH_EXTENSION = ".ffd";
    private static final Map<String, TypeFormatFactory> typeFormatFactories = new HashMap<String, TypeFormatFactory>();
    private static Option<String> stringNone;
    private static List<Rule> emptyRules;
    private static scala.collection.immutable.Map<String, Element> emptyElements;
    private static scala.collection.immutable.Map<String, Composite> emptyComposites;
    private static scala.collection.immutable.Map<String, Segment> emptySegments;
    private static scala.collection.immutable.Map<String, Structure> emptyStructures;
    private static scala.collection.immutable.Map<String, String> emptyCodeSet;

    static {
        typeFormatFactories.put(StringFormat.code(), new StringTypeFormat());
        typeFormatFactories.put(IntegerFormat.code(), new IntegerTypeFormat());
        typeFormatFactories.put(DecimalFormat.code(), new DecimalTypeFormat());
        typeFormatFactories.put(BooleanFormat.code(), new BooleanTypeFormat());
        typeFormatFactories.put(LocalDateFormat.code(), new DateTypeFormat());
        typeFormatFactories.put(LocalDateTimeFormat.code(), new DateTimeTypeFormat());
        typeFormatFactories.put(LocalTimeFormat.code(), new TimeTypeFormat());
        stringNone = Option.apply(null);
        emptyRules = List$.MODULE$.empty();
        emptyElements = Map$.MODULE$.empty();
        emptyComposites = Map$.MODULE$.empty();
        emptySegments = Map$.MODULE$.empty();
        emptyStructures = Map$.MODULE$.empty();
        emptyCodeSet = Map$.MODULE$.empty();
    }

    private FixedWidthSchemaBuilder() {
    }

    public static Segment buildSegment(java.util.List<TreeTableElement> fields, String name) {
        ArrayList<FixedElementComponent> comps = new ArrayList<FixedElementComponent>();
        int offset = 0;
        for (TreeTableElement field : fields) {
            FixedWidthTableElement fw = (FixedWidthTableElement)field;
            String type = fw.getType().getLabel();
            TypeFormat format = null;
            TypeFormatFactory typeFormatFactory = typeFormatFactories.get(type);
            if (typeFormatFactory != null) {
                format = typeFormatFactory.create(fw);
            }
            Element def = new Element("", fw.getName(), format, emptyCodeSet);
            comps.add(new FixedElementComponent(def, stringNone, fw.getName(), Integer.valueOf(comps.size() + 1).intValue(), (Usage)Usage$.MODULE$.getMandatory(), 1, stringNone, false, stringNone, offset));
            offset += fw.getWidth();
        }
        List clist = JavaConverters$.MODULE$.asScalaBuffer(comps).toList();
        return new Segment(name, name, name, clist, emptyRules);
    }

    public static MetadataType buildMetadataType(Segment segment, String name) {
        BaseTypeBuilder metadataBuilder = MetadataFactory.newBuilder((MetadataFormat)FlatfileTypeLoader.FIXED_WIDTH);
        ArrayTypeBuilder arrayBuilder = metadataBuilder.arrayType();
        FixedWidthMetadataTypeBuilder fixedWidthMetadataBuilder = new FixedWidthMetadataTypeBuilder(null, segment, metadataBuilder);
        return arrayBuilder.of(fixedWidthMetadataBuilder.build()).build();
    }

    public static void writeSchema(Segment segment, IMuleProject muleProject, String name) {
        scala.collection.immutable.Map segmentDefs = emptySegments.$plus(new Tuple2((Object)name, (Object)segment));
        EdiSchemaVersion version = new EdiSchemaVersion((EdiForm)FixedWidth$.MODULE$, "");
        EdiSchema schema = new EdiSchema(version, emptyElements, emptyComposites, segmentDefs, emptyStructures);
        try {
            IFolder srcResources = muleProject.getFolder("src/main/resources");
            IFile fileInProject = srcResources.getFile(FixedWidthSchemaBuilder.buildSchemaFileName(name));
            File file = fileInProject.getRawLocation().toFile();
            if (file.exists()) {
                file.delete();
            }
            Throwable throwable = null;
            Object var10_12 = null;
            try (FileWriter writer = new FileWriter(file);){
                YamlWriter.write((EdiSchema)schema, (String[])new String[0], (Writer)writer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            srcResources.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating schema", e);
        }
    }

    public static File buildSchemaFile(IMuleProject project, String name) {
        IFolder srcResources = project.getFolder("src/main/resources");
        IFile fileInProject = srcResources.getFile(FixedWidthSchemaBuilder.buildSchemaFileName(name));
        return fileInProject.getRawLocation().toFile();
    }

    public static String buildSchemaFileName(String schemaName) {
        return schemaName + FIXED_WIDTH_EXTENSION;
    }

    private static final class BooleanTypeFormat
    implements TypeFormatFactory {
        private BooleanTypeFormat() {
        }

        @Override
        public TypeFormat create(FixedWidthTableElement<?> fw) {
            Optional<TypeFormatConstants.FillMode> align = fw.getAlign();
            Optional<String> trueRepresentation = fw.getTrueRepresentation();
            Optional<String> falseRepresentation = fw.getFalseRepresentation();
            Optional<Boolean> caseSensitive = fw.getCaseSensitive();
            TypeFormat format = BooleanFormat$.MODULE$.apply(fw.getWidth(), (String)trueRepresentation.get(), (String)falseRepresentation.get(), ((Boolean)caseSensitive.get()).booleanValue(), (TypeFormatConstants.FillMode)align.get());
            return format;
        }
    }

    private static final class DateTimeTypeFormat
    implements TypeFormatFactory {
        private DateTimeTypeFormat() {
        }

        @Override
        public TypeFormat create(FixedWidthTableElement<?> fw) {
            Optional<TypeFormatConstants.FillMode> align = fw.getAlign();
            Optional<String> patternMaybe = fw.getPattern();
            TypeFormat format = patternMaybe.isPresent() ? LocalDateTimeFormat$.MODULE$.apply(fw.getWidth(), (TypeFormatConstants.FillMode)align.get(), (String)patternMaybe.get()) : LocalDateTimeFormat$.MODULE$.apply(fw.getWidth(), (TypeFormatConstants.FillMode)align.get());
            return format;
        }
    }

    private static final class DateTypeFormat
    implements TypeFormatFactory {
        private DateTypeFormat() {
        }

        @Override
        public TypeFormat create(FixedWidthTableElement<?> fw) {
            Optional<String> patternMaybe = fw.getPattern();
            Optional<TypeFormatConstants.FillMode> align = fw.getAlign();
            TypeFormat format = patternMaybe.isPresent() ? LocalDateFormat$.MODULE$.apply(fw.getWidth(), (TypeFormatConstants.FillMode)align.get(), (String)patternMaybe.get()) : LocalDateFormat$.MODULE$.apply(fw.getWidth(), (TypeFormatConstants.FillMode)align.get());
            return format;
        }
    }

    private static final class DecimalTypeFormat
    implements TypeFormatFactory {
        private DecimalTypeFormat() {
        }

        @Override
        public TypeFormat create(FixedWidthTableElement<?> fw) {
            Optional<TypeFormatConstants.FillMode> align = fw.getAlign();
            Optional<Locale> localeMaybe = fw.getLocale();
            Optional<String> patternMaybe = fw.getPattern();
            Optional<TypeFormatConstants.NumberSign> numberSignMaybe = fw.getNumberSignMaybe();
            Optional<Integer> impliedDecimalsMaybe = fw.getImpliedDecimalDigits();
            TypeFormat format = localeMaybe.isPresent() ? DecimalFormat$.MODULE$.apply(fw.getWidth(), (String)patternMaybe.get(), (Locale)localeMaybe.get(), (TypeFormatConstants.FillMode)align.get()) : (impliedDecimalsMaybe.isPresent() ? DecimalFormat$.MODULE$.apply(fw.getWidth(), (TypeFormatConstants.NumberSign)numberSignMaybe.get(), ((Integer)impliedDecimalsMaybe.get()).intValue(), (TypeFormatConstants.FillMode)align.get()) : DecimalFormat$.MODULE$.apply(fw.getWidth(), (TypeFormatConstants.NumberSign)numberSignMaybe.get(), (TypeFormatConstants.FillMode)align.get()));
            return format;
        }
    }

    private static final class IntegerTypeFormat
    implements TypeFormatFactory {
        private IntegerTypeFormat() {
        }

        @Override
        public TypeFormat create(FixedWidthTableElement<?> fw) {
            Optional<TypeFormatConstants.FillMode> align = fw.getAlign();
            Optional<Locale> localeMaybe = fw.getLocale();
            Optional<String> patternMaybe = fw.getPattern();
            Optional<TypeFormatConstants.NumberSign> numberSignMaybe = fw.getNumberSignMaybe();
            TypeFormat format = localeMaybe.isPresent() ? IntegerFormat$.MODULE$.apply(fw.getWidth(), (String)patternMaybe.get(), (Locale)localeMaybe.get(), (TypeFormatConstants.FillMode)align.get()) : IntegerFormat$.MODULE$.apply(fw.getWidth(), (TypeFormatConstants.NumberSign)numberSignMaybe.get(), (TypeFormatConstants.FillMode)align.get());
            return format;
        }
    }

    private static final class StringTypeFormat
    implements TypeFormatFactory {
        private StringTypeFormat() {
        }

        @Override
        public TypeFormat create(FixedWidthTableElement<?> fw) {
            Optional<TypeFormatConstants.FillMode> align = fw.getAlign();
            TypeFormat format = StringFormat$.MODULE$.apply(fw.getWidth(), (TypeFormatConstants.FillMode)align.get());
            return format;
        }
    }

    private static final class TimeTypeFormat
    implements TypeFormatFactory {
        private TimeTypeFormat() {
        }

        @Override
        public TypeFormat create(FixedWidthTableElement<?> fw) {
            TypeFormat format = LocalTimeFormat$.MODULE$.apply(fw.getWidth(), TypeFormatConstants.FillMode.LEFT);
            return format;
        }
    }

    private static interface TypeFormatFactory {
        public TypeFormat create(FixedWidthTableElement<?> var1);
    }
}

