/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.flatfile.extension;

import com.mulesoft.flatfile.schema.model.Segment;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.flatfile.FlatfileTypeLoader;
import org.mule.tooling.client.metadata.MetadataTypeFormat;
import org.mule.tooling.client.metadata.MetadataTypeOrigin;
import org.mule.tooling.client.metadata.MetadataTypeProxy;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.Tuple;
import org.mule.tooling.metadata.annotations.ElementAnnotation;
import org.mule.tooling.metadata.annotations.ExamplePathAnnotation;
import org.mule.tooling.metadata.annotations.FormatAnnotation;
import org.mule.tooling.metadata.annotations.OriginAnnotation;
import org.mule.tooling.metadata.annotations.PathAnnotation;
import org.mule.tooling.ui.flatfile.contribution.FixedWidthTypesManager;
import org.mule.tooling.ui.flatfile.extension.FixedWidthSchemaBuilder;
import org.mule.tooling.ui.flatfile.extension.FixedWidthTreeEditor;
import org.mule.tooling.ui.flatfile.extension.FixedWidthTreeEditorPresenter;
import org.mule.tooling.ui.modules.core.metadata.definition.ChangeManager;
import org.mule.tooling.ui.modules.core.metadata.definition.IMetadataDefinitionValidator;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataResult;
import org.mule.tooling.ui.modules.core.metadata.definition.OnValidationMessage;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.BaseMetadataDefinitionEditor;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.Resource;
import org.mule.tooling.ui.widgets.listener.IdleModifyEventListener;
import org.mule.tooling.ui.widgets.treetable.TreeTableEditor;
import org.mule.tooling.ui.widgets.treetable.TreeTableEditorPresenter;

public class FixedWidthMetadataDefinitionEditor
extends BaseMetadataDefinitionEditor {
    private FixedWidthTreeEditor typedEditor;
    private FixedWidthTreeEditorPresenter<FixedWidthTreeEditor, MetadataType> typedEditorPresenter;
    private Segment segment;
    private Text exampleFilePath;
    private Label messageLabel;
    private List<Resource> examples = Collections.emptyList();

    public FixedWidthMetadataDefinitionEditor(Composite parent, IMuleProject project, IMetadataDefinitionValidator editorValidator, ChangeManager changeManager, String key, OnValidationMessage onValidationMessage) {
        super(parent, project, editorValidator, changeManager, key, onValidationMessage);
        this.createControl((Composite)this);
    }

    public MetadataResult calculateMetadata() {
        MetadataResult metadataResult = this.generateMetadataResult();
        if (metadataResult.isValid()) {
            this.writeSchemaFile(this.segment);
        }
        return metadataResult;
    }

    private void writeSchemaFile(Segment segment) {
        FixedWidthSchemaBuilder.writeSchema(segment, this.getMuleProject(), this.getKey());
    }

    protected void createControl(Composite parent) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        this.createKey(parent);
        Optional<MetadataType> maybePreviousMetadata = Optional.ofNullable(this.getMetadataTypeFromCache(this.getPreviousKey()));
        Composite wrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(wrapper);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)wrapper);
        this.createFixedTreeEditor(wrapper, maybePreviousMetadata);
        this.createExampleFileControl(wrapper, maybePreviousMetadata);
        this.messageLabel = this.createMessageLabel(wrapper);
    }

    private void createFixedTreeEditor(Composite wrapper, Optional<MetadataType> maybePreviousMetadata) {
        this.typedEditor = new FixedWidthTreeEditor(wrapper);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.typedEditor);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.typedEditor);
        this.typedEditorPresenter = new FixedWidthTreeEditorPresenter(new FixedWidthTypesManager(), this.getMuleProject(), maybePreviousMetadata);
        TreeTableEditorPresenter.TreeTableEditorListener editorListener = new TreeTableEditorPresenter.TreeTableEditorListener(){

            public void actionPerformed(TreeTableEditorPresenter.EditorActions action) {
                FixedWidthMetadataDefinitionEditor.this.validate();
                if (!TreeTableEditorPresenter.EditorActions.LOAD.equals((Object)action)) {
                    FixedWidthMetadataDefinitionEditor.this.recordChange();
                }
            }
        };
        this.typedEditorPresenter.addListener(editorListener);
        this.typedEditorPresenter.handle((TreeTableEditor)this.typedEditor);
        wrapper.layout();
    }

    private void createExampleFileControl(Composite parent, Optional<MetadataType> maybePreviousMetadata) {
        Optional maybeExamplePathAnnotation;
        Composite fileWrapper = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)fileWrapper);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(fileWrapper);
        Label exampleLabel = new Label(fileWrapper, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)exampleLabel);
        exampleLabel.setText("Example File");
        this.exampleFilePath = new Text(fileWrapper, 2052);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.exampleFilePath);
        this.exampleFilePath.setMessage("Select your FixedWidth example file");
        if (maybePreviousMetadata.isPresent() && (maybeExamplePathAnnotation = maybePreviousMetadata.get().getAnnotation(ExamplePathAnnotation.class)).isPresent()) {
            this.exampleFilePath.setText(((ExamplePathAnnotation)maybeExamplePathAnnotation.get()).getPath());
        }
        this.exampleFilePath.addModifyListener((ModifyListener)new IdleModifyEventListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String examplePath = FixedWidthMetadataDefinitionEditor.this.exampleFilePath.getText();
                FixedWidthMetadataDefinitionEditor.this.examples = Resource.create((String)examplePath, (IMuleProject)FixedWidthMetadataDefinitionEditor.this.getMuleProject()).map(r -> Collections.singletonList(r)).orElse(Collections.emptyList());
                FixedWidthMetadataDefinitionEditor.this.checkExamplesToCopy();
                FixedWidthMetadataDefinitionEditor.this.refresh();
            }
        }, (Control)fileWrapper));
        Button openSchemaButton = new Button(fileWrapper, 8);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)openSchemaButton);
        openSchemaButton.setText("...");
        openSchemaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List result = FixedWidthMetadataDefinitionEditor.this.filePickerButtonPressed(false, new String[]{"FixedWidth file"}, new String[]{"*.*"}, FixedWidthMetadataDefinitionEditor.this.getShell());
                if (!result.isEmpty()) {
                    FixedWidthMetadataDefinitionEditor.this.messageLabel.setText("");
                    FixedWidthMetadataDefinitionEditor.this.examples = result.stream().map(f -> Resource.create((String)f, (IMuleProject)FixedWidthMetadataDefinitionEditor.this.getMuleProject())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
                    FixedWidthMetadataDefinitionEditor.this.checkExamplesToCopy();
                    FixedWidthMetadataDefinitionEditor.this.exampleFilePath.setText(FixedWidthMetadataDefinitionEditor.this.getFileTextFromSelectedResources(FixedWidthMetadataDefinitionEditor.this.examples, "examples"));
                    FixedWidthMetadataDefinitionEditor.this.recordChange();
                }
            }
        });
    }

    private void refresh() {
        this.recordChange();
        this.validate();
    }

    protected void doValidate() {
        if (StringUtils.isBlank((String)this.getKey())) {
            this.getOnValidationMessage().setValidationMessage(this.getEditorValidator().getValidationMessage("#Custom Type#", this.getKey(), "Type Id"));
        } else {
            boolean validKey = this.getEditorValidator().isValidKey("#Custom Type#", this.getKey());
            if (!validKey) {
                this.getOnValidationMessage().setValidationMessage(this.getEditorValidator().getValidationMessage("#Custom Type#", this.getKey(), "Type Id"));
            } else {
                MetadataResult metadataResult = this.generateMetadataResult();
                if (!metadataResult.isValid()) {
                    this.getOnValidationMessage().setValidationMessage(metadataResult.getMessage());
                } else {
                    this.getOnValidationMessage().clear();
                }
            }
        }
    }

    private MetadataResult generateMetadataResult() {
        List elements = this.typedEditorPresenter.getElements();
        if (elements.isEmpty()) {
            return MetadataResult.from((String)"Field list is empty");
        }
        try {
            HashMap<Class<ElementAnnotation>, Object> annotations = new HashMap<Class<ElementAnnotation>, Object>();
            this.segment = FixedWidthSchemaBuilder.buildSegment(elements, this.getKey());
            MetadataType metadataType = FixedWidthSchemaBuilder.buildMetadataType(this.segment, this.getKey());
            String examplePath = this.exampleFilePath.getText();
            if (StringUtils.isNotBlank((String)examplePath)) {
                Optional maybeResource = CoreUtils.getResource((String)examplePath, (IMuleProject)this.getMuleProject());
                Tuple resource = new Tuple((Object)examplePath, (Object)CoreUtils.toClasspathResource((File)(maybeResource.isPresent() ? ((IFile)maybeResource.get()).getRawLocation().toFile() : new File(examplePath)), (IMuleProject)this.getMuleProject()));
                if (((Optional)resource.second()).isPresent()) {
                    annotations.put(ExamplePathAnnotation.class, new ExamplePathAnnotation((String)((Optional)resource.second()).get()));
                } else {
                    File exampleFile = new File((String)resource.first());
                    if (exampleFile.exists()) {
                        annotations.put(ExamplePathAnnotation.class, new ExamplePathAnnotation(this.getResourcePath(this.examples.get(0), "examples")));
                    } else {
                        return MetadataResult.from((String)"Selected example file doesnt exist.");
                    }
                }
            }
            annotations.put(FormatAnnotation.class, new FormatAnnotation(MetadataTypeFormat.APPLICATION_FIXED_WIDTH));
            annotations.put(OriginAnnotation.class, new OriginAnnotation(MetadataTypeOrigin.SCHEMA));
            annotations.put(PathAnnotation.class, new PathAnnotation(FixedWidthSchemaBuilder.buildSchemaFileName(this.getKey())));
            annotations.put(ElementAnnotation.class, new ElementAnnotation(this.getKey()));
            return MetadataResult.from((MetadataType)MetadataTypeProxy.proxying((MetadataType)metadataType, annotations));
        }
        catch (Exception e) {
            return MetadataResult.from((String)("Error creating metadata... \n" + e.getLocalizedMessage()));
        }
    }

    private void checkExamplesToCopy() {
        Resource.getResourcesToCopyMessage(this.examples).ifPresent(message -> this.messageLabel.setText(message + " will be copied to src/main/resources/examples"));
    }

    protected MetadataType filterMetadataType(MetadataType metadataType) {
        MetadataType temp = metadataType;
        if (temp instanceof ArrayType) {
            temp = ((ArrayType)metadataType).getType();
        }
        if (temp instanceof ObjectType && FlatfileTypeLoader.FIXED_WIDTH.equals((Object)temp.getMetadataFormat())) {
            return metadataType;
        }
        return null;
    }

    public void applyChanges() {
        IFolder examplesFolder = this.getExamplesFolder();
        Resource.getResourcesToCopyStream(this.examples).forEach(example -> {
            File sourceFile = example.getFile();
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (FileInputStream is = new FileInputStream(sourceFile);){
                    String uniqueName = MuleResourceUtils.getUniqueFileName((File)examplesFolder.getRawLocation().toFile(), (String)sourceFile.getName());
                    MuleResourceUtils.createFile((IFolder)examplesFolder, (String)uniqueName, (InputStream)is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | CoreException e) {
                MuleCorePlugin.logError((String)"Error copying examples", (Throwable)e);
            }
        });
    }
}

