/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.flatfile.contribution;

import com.mulesoft.flatfile.lexical.TypeFormat;
import com.mulesoft.flatfile.schema.fftypes.BinaryFormat;
import com.mulesoft.flatfile.schema.fftypes.BooleanFormat;
import com.mulesoft.flatfile.schema.fftypes.DecimalFormat;
import com.mulesoft.flatfile.schema.fftypes.IntegerFormat;
import com.mulesoft.flatfile.schema.fftypes.LocalDateFormat;
import com.mulesoft.flatfile.schema.fftypes.LocalDateTimeFormat;
import com.mulesoft.flatfile.schema.fftypes.LocalTimeFormat;
import com.mulesoft.flatfile.schema.fftypes.PackedDecimalFormat;
import com.mulesoft.flatfile.schema.fftypes.StringFormat;
import com.mulesoft.flatfile.schema.fftypes.ZonedFormat;
import com.mulesoft.flatfile.schema.model.BaseCompositeComponent;
import com.mulesoft.flatfile.schema.model.BaseElementComponent;
import com.mulesoft.flatfile.schema.model.Composite;
import com.mulesoft.flatfile.schema.model.Element;
import com.mulesoft.flatfile.schema.model.GroupComponent;
import com.mulesoft.flatfile.schema.model.ReferenceComponent;
import com.mulesoft.flatfile.schema.model.Segment;
import com.mulesoft.flatfile.schema.model.SegmentComponent;
import com.mulesoft.flatfile.schema.model.Structure;
import com.mulesoft.flatfile.schema.model.StructureComponent;
import com.mulesoft.flatfile.schema.model.StructureSequence;
import com.mulesoft.flatfile.schema.model.Usage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.flatfile.metadata.schema.SchemaUtils;
import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.flatfile.FieldFormatAnnotation;
import org.mule.metadata.flatfile.FlatfileTypeLoader;
import org.mule.tooling.client.metadata.MetadataFactory;
import scala.collection.JavaConverters$;
import scala.collection.Seq;

public class FlatFileMetadataTypeBuilder
implements TypeBuilder<MetadataType> {
    protected Map<String, MetadataType> typeConvert = new HashMap<String, MetadataType>();
    private static final Map<String, FieldFormatAnnotationFactory> formatters = new HashMap<String, FieldFormatAnnotationFactory>();
    private final Structure structure;
    private final Segment segment;
    private final BaseTypeBuilder metadataBuilder;

    static {
        formatters.put(StringFormat.code(), new StringFieldFormatAnnotationFactory());
        formatters.put(IntegerFormat.code(), new IntegerFieldFormatAnnotationFactory());
        formatters.put(DecimalFormat.code(), new DecimalFieldFormatAnnotationFactory());
        formatters.put(BooleanFormat.code(), new BooleanFieldFormatAnnotationFactory());
        formatters.put(LocalDateFormat.code(), new DateFieldFormatAnnotationFactory());
        formatters.put(LocalDateTimeFormat.code(), new DateTimeFieldFormatAnnotationFactory());
    }

    public FlatFileMetadataTypeBuilder(Structure struct, Segment seg, BaseTypeBuilder metadataBuilder) {
        this.structure = struct;
        this.segment = seg;
        this.metadataBuilder = metadataBuilder;
        this.initializeFormatters();
    }

    public void initializeFormatters() {
        BaseTypeBuilder typeBuilder = MetadataFactory.newBuilder((MetadataFormat)FlatfileTypeLoader.FLAT_FILE);
        this.typeConvert.put(BinaryFormat.code(), (MetadataType)typeBuilder.numberType().integer().build());
        this.typeConvert.put(BooleanFormat.code(), (MetadataType)typeBuilder.booleanType().build());
        this.typeConvert.put(DecimalFormat.code(), (MetadataType)typeBuilder.numberType().id("double").build());
        this.typeConvert.put(IntegerFormat.code(), (MetadataType)typeBuilder.numberType().integer().build());
        this.typeConvert.put(LocalDateFormat.code(), (MetadataType)typeBuilder.dateType().build());
        this.typeConvert.put(LocalDateTimeFormat.code(), (MetadataType)typeBuilder.dateTimeType().build());
        this.typeConvert.put(LocalTimeFormat.code(), (MetadataType)typeBuilder.dateTimeType().build());
        this.typeConvert.put(PackedDecimalFormat.code(), (MetadataType)typeBuilder.numberType().id("double").build());
        this.typeConvert.put(StringFormat.code(), (MetadataType)typeBuilder.stringType().build());
        this.typeConvert.put(ZonedFormat.code(), (MetadataType)typeBuilder.stringType().build());
    }

    protected LabelAnnotation buildLabelAnnotation(String key, String name) {
        if (name != null && name.length() > 0) {
            return new LabelAnnotation(key + " - " + name);
        }
        return new LabelAnnotation(key);
    }

    public MetadataType build() {
        ObjectTypeBuilder objectTypeBuilder = this.metadataBuilder.objectType();
        if (this.structure != null) {
            List comps = JavaConverters$.MODULE$.seqAsJavaList((Seq)((StructureSequence)this.structure.heading().get()).items());
            new StructureComponentsFieldFactory(comps).execute(objectTypeBuilder);
        } else if (this.segment != null) {
            List comps = JavaConverters$.MODULE$.seqAsJavaList((Seq)this.segment.components());
            new SegmentComponentsFieldFactory(comps).execute(objectTypeBuilder);
        } else {
            throw new IllegalStateException("Missing required structure or segment for metadata generation");
        }
        return objectTypeBuilder.build();
    }

    private static final class BooleanFieldFormatAnnotationFactory
    implements FieldFormatAnnotationFactory {
        private BooleanFieldFormatAnnotationFactory() {
        }

        @Override
        public FieldFormatAnnotation create(TypeFormat format) {
            BooleanFormat.BooleanFormatImpl formatter = (BooleanFormat.BooleanFormatImpl)format;
            FieldFormatAnnotation fieldFormatAnnotation = new FieldFormatAnnotation(Integer.valueOf(formatter.width()));
            fieldFormatAnnotation.withTrueRepresentation(formatter.t()).withFalseRepresentation(formatter.f()).withCaseSensitive(Boolean.valueOf(formatter.caseSensitive())).withAlign(formatter.mode().name());
            return fieldFormatAnnotation;
        }
    }

    private static final class DateFieldFormatAnnotationFactory
    implements FieldFormatAnnotationFactory {
        private DateFieldFormatAnnotationFactory() {
        }

        @Override
        public FieldFormatAnnotation create(TypeFormat format) {
            if (format instanceof LocalDateFormat.LocalDateFormatImpl) {
                LocalDateFormat.LocalDateFormatImpl formatter = (LocalDateFormat.LocalDateFormatImpl)format;
                FieldFormatAnnotation fieldFormatAnnotation = new FieldFormatAnnotation(Integer.valueOf(formatter.width()));
                fieldFormatAnnotation.withAlign(formatter.mode().name());
                return fieldFormatAnnotation;
            }
            if (format instanceof LocalDateFormat.LocalDatePatternImpl) {
                LocalDateFormat.LocalDatePatternImpl formatter = (LocalDateFormat.LocalDatePatternImpl)format;
                FieldFormatAnnotation fieldFormatAnnotation = new FieldFormatAnnotation(Integer.valueOf(formatter.width()));
                fieldFormatAnnotation.withAlign(formatter.mode().name()).withPattern(formatter.pattern()).withLocale(formatter.toString());
                return fieldFormatAnnotation;
            }
            return null;
        }
    }

    private static final class DateTimeFieldFormatAnnotationFactory
    implements FieldFormatAnnotationFactory {
        private DateTimeFieldFormatAnnotationFactory() {
        }

        @Override
        public FieldFormatAnnotation create(TypeFormat format) {
            if (format instanceof LocalDateTimeFormat.LocalDateTimeFormatImpl) {
                LocalDateTimeFormat.LocalDateTimeFormatImpl formatter = (LocalDateTimeFormat.LocalDateTimeFormatImpl)format;
                FieldFormatAnnotation fieldFormatAnnotation = new FieldFormatAnnotation(Integer.valueOf(formatter.width()));
                fieldFormatAnnotation.withAlign(formatter.mode().name());
                return fieldFormatAnnotation;
            }
            if (format instanceof LocalDateTimeFormat.LocalDateTimePatternImpl) {
                LocalDateTimeFormat.LocalDateTimePatternImpl formatter = (LocalDateTimeFormat.LocalDateTimePatternImpl)format;
                FieldFormatAnnotation fieldFormatAnnotation = new FieldFormatAnnotation(Integer.valueOf(formatter.width()));
                fieldFormatAnnotation.withAlign(formatter.mode().name()).withPattern(formatter.pattern()).withLocale(formatter.toString());
                return fieldFormatAnnotation;
            }
            return null;
        }
    }

    private static final class DecimalFieldFormatAnnotationFactory
    implements FieldFormatAnnotationFactory {
        private DecimalFieldFormatAnnotationFactory() {
        }

        @Override
        public FieldFormatAnnotation create(TypeFormat format) {
            if (format instanceof DecimalFormat.DecimalFormatImpl) {
                DecimalFormat.DecimalFormatImpl formatter = (DecimalFormat.DecimalFormatImpl)format;
                FieldFormatAnnotation fieldFormatAnnotation = new FieldFormatAnnotation(Integer.valueOf(formatter.width()));
                fieldFormatAnnotation.withNumberSign(formatter.sign().name()).withAlign(formatter.mode().name());
                return fieldFormatAnnotation;
            }
            if (format instanceof DecimalFormat.DecimalImplicitImpl) {
                DecimalFormat.DecimalImplicitImpl formatter = (DecimalFormat.DecimalImplicitImpl)format;
                FieldFormatAnnotation fieldFormatAnnotation = new FieldFormatAnnotation(Integer.valueOf(formatter.width()));
                fieldFormatAnnotation.withImpliedDecimalDigits(Integer.valueOf(formatter.impl())).withNumberSign(formatter.sign().name()).withAlign(formatter.mode().name());
                return fieldFormatAnnotation;
            }
            if (format instanceof DecimalFormat.DecimalPatternImpl) {
                DecimalFormat.DecimalPatternImpl formatter = (DecimalFormat.DecimalPatternImpl)format;
                FieldFormatAnnotation fieldFormatAnnotation = new FieldFormatAnnotation(Integer.valueOf(formatter.width()));
                fieldFormatAnnotation.withAlign(formatter.mode().name()).withPattern(formatter.pattern()).withLocale(formatter.locale().toString());
                return fieldFormatAnnotation;
            }
            return null;
        }
    }

    private static interface FieldFormatAnnotationFactory {
        public FieldFormatAnnotation create(TypeFormat var1);
    }

    private static final class IntegerFieldFormatAnnotationFactory
    implements FieldFormatAnnotationFactory {
        private IntegerFieldFormatAnnotationFactory() {
        }

        @Override
        public FieldFormatAnnotation create(TypeFormat format) {
            if (format instanceof IntegerFormat.IntegerFormatImpl) {
                IntegerFormat.IntegerFormatImpl formatter = (IntegerFormat.IntegerFormatImpl)format;
                FieldFormatAnnotation fieldFormatAnnotation = new FieldFormatAnnotation(Integer.valueOf(formatter.width()));
                fieldFormatAnnotation.withNumberSign(formatter.sign().name()).withAlign(formatter.mode().name());
                return fieldFormatAnnotation;
            }
            if (format instanceof IntegerFormat.IntegerPatternImpl) {
                IntegerFormat.IntegerPatternImpl formatter = (IntegerFormat.IntegerPatternImpl)format;
                FieldFormatAnnotation fieldFormatAnnotation = new FieldFormatAnnotation(Integer.valueOf(formatter.width()));
                fieldFormatAnnotation.withAlign(formatter.mode().name()).withPattern(formatter.pattern()).withLocale(formatter.locale().toString());
                return fieldFormatAnnotation;
            }
            return null;
        }
    }

    private class SegmentComponentsFieldFactory {
        private final List<SegmentComponent> components;

        public SegmentComponentsFieldFactory(List<SegmentComponent> comps) {
            this.components = comps;
        }

        public void execute(ObjectTypeBuilder object) {
            this.addComponentFields(object, this.components);
        }

        private void addComponentField(ObjectTypeBuilder object, SegmentComponent comp) {
            Element element = ((BaseElementComponent)comp).element();
            TypeFormat typeFormat = element.typeFormat();
            String typeCode = typeFormat.typeCode();
            MetadataType metadataType = FlatFileMetadataTypeBuilder.this.typeConvert.get(typeCode);
            if (comp.count() == 1) {
                ObjectFieldTypeBuilder fieldBuilder = object.addField();
                fieldBuilder.key(comp.key());
                fieldBuilder.value(metadataType);
                FieldFormatAnnotationFactory fieldFormatAnnotationFactory = formatters.get(typeCode);
                if (fieldFormatAnnotationFactory != null) {
                    FieldFormatAnnotation fieldFormatAnnotation = fieldFormatAnnotationFactory.create(typeFormat);
                    fieldBuilder.with((TypeAnnotation)fieldFormatAnnotation);
                }
            } else {
                ObjectFieldTypeBuilder fieldBuilder = object.addField();
                fieldBuilder.key(comp.key());
                fieldBuilder.value().arrayType().of(metadataType);
            }
        }

        private void addComponentFields(ObjectTypeBuilder object, List<SegmentComponent> comps) {
            for (SegmentComponent comp : comps) {
                if (!SchemaUtils.includeForUsage((Usage)comp.usage())) continue;
                if (comp instanceof BaseElementComponent) {
                    this.addComponentField(object, comp);
                    continue;
                }
                if (comp instanceof BaseCompositeComponent) {
                    Composite composite = ((BaseCompositeComponent)comp).composite();
                    List subcomps = JavaConverters$.MODULE$.seqAsJavaList((Seq)composite.components());
                    ObjectFieldTypeBuilder fieldBuilder = object.addField();
                    fieldBuilder.key(comp.key());
                    ObjectTypeBuilder objectBuilder = fieldBuilder.value().objectType();
                    new SegmentComponentsFieldFactory(subcomps).execute(objectBuilder);
                    if (comp.count() == 1) {
                        fieldBuilder.value((TypeBuilder)objectBuilder);
                        continue;
                    }
                    fieldBuilder.value().arrayType().of((TypeBuilder)objectBuilder);
                    continue;
                }
                throw new IllegalStateException("Segment component of unknown type");
            }
        }
    }

    private static final class StringFieldFormatAnnotationFactory
    implements FieldFormatAnnotationFactory {
        private StringFieldFormatAnnotationFactory() {
        }

        @Override
        public FieldFormatAnnotation create(TypeFormat format) {
            StringFormat.StringFormatImpl formatter = (StringFormat.StringFormatImpl)format;
            FieldFormatAnnotation fieldFormatAnnotation = new FieldFormatAnnotation(Integer.valueOf(formatter.width()));
            fieldFormatAnnotation.withAlign(formatter.mode().name());
            return fieldFormatAnnotation;
        }
    }

    private class StructureComponentsFieldFactory {
        private final List<StructureComponent> components;

        public StructureComponentsFieldFactory(List<StructureComponent> comps) {
            this.components = comps;
        }

        public void execute(ObjectTypeBuilder object) {
            for (StructureComponent comp : this.components) {
                LabelAnnotation labelAnnotation;
                if (!SchemaUtils.includeForUsage((Usage)comp.usage())) continue;
                ObjectFieldTypeBuilder fieldBuilder = object.addField();
                fieldBuilder.key(comp.key());
                ObjectTypeBuilder objectBuilder = fieldBuilder.value().objectType();
                if (comp instanceof ReferenceComponent) {
                    ReferenceComponent refc = (ReferenceComponent)comp;
                    comps = JavaConverters$.MODULE$.seqAsJavaList((Seq)refc.segment().components());
                    new SegmentComponentsFieldFactory(comps).execute(objectBuilder);
                    labelAnnotation = FlatFileMetadataTypeBuilder.this.buildLabelAnnotation(refc.key(), refc.segment().name());
                } else if (comp instanceof GroupComponent) {
                    GroupComponent grpc = (GroupComponent)comp;
                    comps = JavaConverters$.MODULE$.seqAsJavaList((Seq)grpc.seq().items());
                    new StructureComponentsFieldFactory(comps).execute(objectBuilder);
                    labelAnnotation = FlatFileMetadataTypeBuilder.this.buildLabelAnnotation(grpc.key(), grpc.ident());
                } else {
                    throw new IllegalStateException("Unexpected type for flat file schema: " + comp.getClass().getName());
                }
                if (comp.count() == 1) {
                    fieldBuilder.value((TypeBuilder)objectBuilder);
                } else {
                    fieldBuilder.value().arrayType().of((TypeBuilder)objectBuilder);
                }
                if (labelAnnotation == null) continue;
                fieldBuilder.withKeyAnnotation((TypeAnnotation)labelAnnotation);
            }
        }
    }
}

