/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.flatfile.contribution;

import com.mulesoft.flatfile.schema.model.EdiForm$;
import com.mulesoft.flatfile.schema.model.EdiFormConverter;
import com.mulesoft.flatfile.schema.model.EdiSchema;
import com.mulesoft.flatfile.schema.model.FlatFile$;
import com.mulesoft.flatfile.schema.yaml.YamlReader;
import com.mulesoft.flatfile.schema.yaml.YamlReader$;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.flatfile.FlatfileTypeLoader;
import org.mule.tooling.client.metadata.MetadataTypeFormat;
import org.mule.tooling.client.metadata.MetadataTypeOrigin;
import org.mule.tooling.client.metadata.MetadataTypeProxy;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.metadata.MetadataTypeGraphicalChildrenProvider;
import org.mule.tooling.metadata.annotations.ElementAnnotation;
import org.mule.tooling.metadata.annotations.FormatAnnotation;
import org.mule.tooling.metadata.annotations.OriginAnnotation;
import org.mule.tooling.metadata.annotations.PathAnnotation;
import org.mule.tooling.metadata.annotations.PropertiesAnnotation;
import org.mule.tooling.ui.modules.core.metadata.definition.ChangeManager;
import org.mule.tooling.ui.modules.core.metadata.definition.IMetadataDefinitionValidator;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataResult;
import org.mule.tooling.ui.modules.core.metadata.definition.OnValidationMessage;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.BaseMetadataDefinitionEditor;
import org.mule.tooling.ui.modules.core.metadata.definition.custom.types.Resource;
import org.mule.tooling.ui.widgets.listener.IdleModifyEventListener;
import scala.collection.JavaConverters$;
import scala.collection.Map;

public class FlatFileMetadataDefinitionEditor
extends BaseMetadataDefinitionEditor {
    private static final String DEFAULT_RECORD_PARSING = "strict";
    private static final String[] RECORD_PARSING_VALUES = new String[]{"strict", "lenient", "noTerminator", "singleRecord"};
    private Text filePath;
    private EdiSchema loadedSchema;
    private ComboViewer identCombo;
    private Optional<MetadataType> editedModel;
    private TreeViewer detailsTree;
    private Label messageLabel;
    private ComboViewer comboViewer;
    private List<Resource> resources = Collections.emptyList();

    public FlatFileMetadataDefinitionEditor(Composite parent, IMuleProject project, IMetadataDefinitionValidator editorValidator, ChangeManager changeManager, String key, OnValidationMessage onValidationMessage) {
        super(parent, project, editorValidator, changeManager, key, onValidationMessage);
        this.createControl((Composite)this);
    }

    public void onRefresh() {
        this.refresh();
    }

    public MetadataResult calculateMetadata() {
        try {
            String path = this.getSchemaPath();
            if (StringUtils.isNotBlank((String)path)) {
                StructuredSelection selection = (StructuredSelection)this.identCombo.getSelection();
                Object selectedElement = selection.getFirstElement();
                if (selectedElement != null) {
                    String element = selectedElement.toString();
                    HashMap<Class<PropertiesAnnotation>, Object> annotations = new HashMap<Class<PropertiesAnnotation>, Object>();
                    FlatfileTypeLoader loader = new FlatfileTypeLoader(FlatFileMetadataDefinitionEditor.resolvePath((IMuleProject)this.getMuleProject(), (Resource)this.resources.get(0)).getAbsolutePath());
                    Optional maybeMetadataType = loader.load(element);
                    MetadataType metadataType = (MetadataType)maybeMetadataType.orElseThrow(() -> new IllegalArgumentException("The provided file could not be parsed as Flat File Schema"));
                    annotations.put(FormatAnnotation.class, new FormatAnnotation(MetadataTypeFormat.APPLICATION_FLAT_FILE));
                    annotations.put(OriginAnnotation.class, new OriginAnnotation(MetadataTypeOrigin.SCHEMA));
                    annotations.put(PathAnnotation.class, new PathAnnotation(this.getResourcePath(this.resources.get(0), "schemas")));
                    annotations.put(ElementAnnotation.class, new ElementAnnotation(element));
                    String recordParsingValue = this.getRecordParsingValue();
                    if (recordParsingValue != null) {
                        HashMap<String, String> properties = new HashMap<String, String>();
                        properties.put("recordParsing", recordParsingValue);
                        annotations.put(PropertiesAnnotation.class, new PropertiesAnnotation(properties));
                    }
                    return MetadataResult.from((MetadataType)MetadataTypeProxy.proxying((MetadataType)metadataType, annotations));
                }
                return MetadataResult.from(null);
            }
            return MetadataResult.from((String)"Schema path is empty");
        }
        catch (Exception e) {
            return MetadataResult.from((String)("Error creating metadata... \n" + e.getLocalizedMessage()));
        }
    }

    protected void createControl(Composite parent) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        this.createKey(parent);
        Composite wrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(wrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)wrapper);
        Button openSchemaButton = this.createSchemaSelector(wrapper);
        this.messageLabel = this.createMessageLabel(wrapper);
        this.createStructureCombo(wrapper);
        this.createRecordParsingCombo(parent);
        this.editedModel = Optional.ofNullable(this.getMetadataTypeFromCache(this.getPreviousKey()));
        this.detailsTree = this.createDetailsTree(parent, this.editedModel);
        this.loadMode(this.editedModel);
        this.createUIListerners(wrapper, openSchemaButton);
    }

    private void createRecordParsingCombo(Composite parent) {
        Composite recordParsingWrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(recordParsingWrapper);
        GridDataFactory.fillDefaults().span(3, 1).grab(true, false).applyTo((Control)recordParsingWrapper);
        Label recordParsingLabel = new Label(recordParsingWrapper, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)recordParsingLabel);
        recordParsingLabel.setText("Record Parsing");
        this.comboViewer = new ComboViewer(recordParsingWrapper, 8);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo(this.comboViewer.getControl());
        this.comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.comboViewer.setInput((Object)RECORD_PARSING_VALUES);
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        StructuredSelection selection = new StructuredSelection((Object)DEFAULT_RECORD_PARSING);
        this.comboViewer.setSelection((ISelection)selection);
        this.comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FlatFileMetadataDefinitionEditor.this.refresh();
            }
        });
    }

    private String getRecordParsingValue() {
        ISelection selection = this.comboViewer.getSelection();
        if (selection != null && !selection.isEmpty()) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return (String)structuredSelection.getFirstElement();
        }
        return null;
    }

    private Button createSchemaSelector(Composite wrapper) {
        Composite schemaSelectorComposite = new Composite(wrapper, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(schemaSelectorComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)schemaSelectorComposite);
        this.filePath = new Text(schemaSelectorComposite, 2052);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.filePath);
        this.filePath.setMessage("Select your flat file schema file");
        Button openSchemaButton = new Button(schemaSelectorComposite, 8);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)openSchemaButton);
        openSchemaButton.setText("...");
        return openSchemaButton;
    }

    private void loadMode(Optional<MetadataType> maybeMetadataType) {
        MetadataType metadataType;
        Optional maybePathAnnotation;
        if (maybeMetadataType.isPresent() && (maybePathAnnotation = (metadataType = maybeMetadataType.get()).getAnnotation(PathAnnotation.class)).isPresent()) {
            Optional maybePropertiesAnnotation;
            String element;
            String schemaPath = ((PathAnnotation)maybePathAnnotation.get()).getPath();
            this.filePath.setText(schemaPath);
            this.resources = Resource.create((String)schemaPath, (IMuleProject)this.getMuleProject()).map(r -> Collections.singletonList(r)).orElse(Collections.emptyList());
            Optional maybeElement = metadataType.getAnnotation(ElementAnnotation.class);
            if (maybeElement.isPresent() && StringUtils.isNotBlank((String)(element = ((ElementAnnotation)maybeElement.get()).getElement()))) {
                String[] choices;
                this.fillStructureCombo();
                String[] stringArray = choices = (String[])this.identCombo.getInput();
                int n = choices.length;
                int n2 = 0;
                while (n2 < n) {
                    String choice = stringArray[n2];
                    if (element.contains(choice)) {
                        this.identCombo.setSelection((ISelection)new StructuredSelection((Object)choice));
                    }
                    ++n2;
                }
            }
            if ((maybePropertiesAnnotation = metadataType.getAnnotation(PropertiesAnnotation.class)).isPresent()) {
                java.util.Map properties = ((PropertiesAnnotation)maybePropertiesAnnotation.get()).getProperties();
                StructuredSelection selection = new StructuredSelection((Object)properties.getOrDefault("recordParsing", DEFAULT_RECORD_PARSING));
                this.comboViewer.setSelection((ISelection)selection);
            }
        }
    }

    private void refresh() {
        this.recordChange();
        this.refreshDetailsTree();
        this.validate();
    }

    private void createUIListerners(final Composite wrapper, Button openSchemaButton) {
        this.filePath.addModifyListener((ModifyListener)new IdleModifyEventListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FlatFileMetadataDefinitionEditor.this.loadedSchema = null;
                String schemaPath = FlatFileMetadataDefinitionEditor.this.filePath.getText();
                FlatFileMetadataDefinitionEditor.this.resources = Resource.create((String)schemaPath, (IMuleProject)FlatFileMetadataDefinitionEditor.this.getMuleProject()).map(r -> Collections.singletonList(r)).orElse(Collections.emptyList());
                FlatFileMetadataDefinitionEditor.this.checkFilesToCopy();
                FlatFileMetadataDefinitionEditor.this.fillStructureCombo();
            }
        }, (Control)wrapper));
        openSchemaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List result = FlatFileMetadataDefinitionEditor.this.filePickerButtonPressed(false, new String[]{"FlatFile Schema", "All Files (*.*)"}, new String[]{"*.ffd", "*.*"}, wrapper.getShell());
                if (!result.isEmpty()) {
                    FlatFileMetadataDefinitionEditor.this.messageLabel.setText("");
                    FlatFileMetadataDefinitionEditor.this.resources = result.stream().map(f -> Resource.create((String)f, (IMuleProject)FlatFileMetadataDefinitionEditor.this.getMuleProject())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
                    FlatFileMetadataDefinitionEditor.this.checkFilesToCopy();
                    FlatFileMetadataDefinitionEditor.this.filePath.setText(FlatFileMetadataDefinitionEditor.this.getFileTextFromSelectedResources(FlatFileMetadataDefinitionEditor.this.resources, "schemas"));
                    FlatFileMetadataDefinitionEditor.this.fillStructureCombo();
                }
            }
        });
        this.identCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FlatFileMetadataDefinitionEditor.this.refresh();
            }
        });
    }

    private void createStructureCombo(Composite parent) {
        Composite structureComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(structureComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)structureComposite);
        this.identCombo = new ComboViewer(structureComposite);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo(this.identCombo.getControl());
        this.identCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fillStructureCombo();
    }

    private void fillStructureCombo() {
        java.util.Map structs;
        EdiSchema schema = this.getSchema();
        String[] choices = new String[]{};
        if (schema != null && (choices = (structs = JavaConverters$.MODULE$.mapAsJavaMap((Map)schema.structures())).keySet().toArray(choices)).length == 0) {
            java.util.Map segments = JavaConverters$.MODULE$.mapAsJavaMap((Map)schema.segments());
            choices = segments.keySet().toArray(choices);
        }
        this.identCombo.setInput((Object)choices);
        if (choices.length > 0) {
            this.identCombo.setSelection((ISelection)new StructuredSelection((Object)choices[0]));
        }
        this.identCombo.refresh();
    }

    private EdiSchema getSchema() {
        if (this.loadedSchema == null && this.isExistingFile()) {
            YamlReader yamlrdr = new YamlReader((EdiFormConverter)EdiForm$.MODULE$);
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (InputStream is = YamlReader$.MODULE$.findSchema(FlatFileMetadataDefinitionEditor.resolvePath((IMuleProject)this.getMuleProject(), (Resource)this.resources.get(0)).getAbsolutePath()).input();){
                    try {
                        Throwable throwable2 = null;
                        Object var6_11 = null;
                        try (InputStreamReader reader = new InputStreamReader(is);){
                            EdiSchema ediSchema = yamlrdr.loadYaml((Reader)reader, JavaConverters$.MODULE$.asScalaBuffer(Collections.emptyList()).toList());
                            if (ediSchema.ediVersion().ediForm() != FlatFile$.MODULE$) {
                                this.getOnValidationMessage().setValidationMessage("Invalid schema: " + String.valueOf(ediSchema.ediVersion().ediForm()) + " not supported as Flat File schema");
                            } else {
                                this.loadedSchema = ediSchema;
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Exception e) {
                        this.getOnValidationMessage().setValidationMessage("Invalid schema: " + e.getLocalizedMessage());
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                MuleCorePlugin.logError((String)"Error reading schema", (Throwable)e);
                this.getOnValidationMessage().setValidationMessage(e.getLocalizedMessage());
            }
        }
        return this.loadedSchema;
    }

    private void refreshDetailsTree() {
        MetadataResult metadataResult = this.calculateMetadata();
        this.editedModel = Optional.ofNullable(metadataResult.getMetadataType());
        this.detailsTree.setInput((Object)this.getRoot(this.editedModel));
        this.detailsTree.expandToLevel(4);
    }

    protected void doValidate() {
        if (StringUtils.isNotBlank((String)this.getKey())) {
            boolean validKey = this.getEditorValidator().isValidKey("#Custom Type#", this.getKey());
            if (!validKey) {
                this.getOnValidationMessage().setValidationMessage(this.getEditorValidator().getValidationMessage("#Custom Type#", this.getKey(), "Type Id"));
            } else if (this.isExistingFile()) {
                try {
                    MetadataResult result = this.getMetadata();
                    if (result.isValid()) {
                        this.getOnValidationMessage().clear();
                    } else {
                        String message = result.getMessage();
                        if (StringUtils.isNotEmpty((String)message)) {
                            this.getOnValidationMessage().setValidationMessage(message);
                        }
                    }
                }
                catch (Exception ex) {
                    this.getOnValidationMessage().setValidationMessage(ex.getMessage());
                }
            } else if (this.editedModel.isPresent()) {
                this.getOnValidationMessage().clear();
            } else {
                String errorMessage = MessageFormat.format("The selected {0} file does not exist", this.filePath.getText());
                this.getOnValidationMessage().setValidationMessage(errorMessage);
            }
        }
    }

    private boolean isExistingFile() {
        File resolvedFile;
        File file = resolvedFile = !this.resources.isEmpty() ? FlatFileMetadataDefinitionEditor.resolvePath((IMuleProject)this.getMuleProject(), (Resource)this.resources.get(0)) : null;
        return resolvedFile != null && resolvedFile.exists() && !resolvedFile.isDirectory();
    }

    private String getSchemaPath() {
        return this.resources.isEmpty() ? "" : this.resources.get(0).getPath();
    }

    private void checkFilesToCopy() {
        Resource.getResourcesToCopyMessage(this.resources).ifPresent(message -> this.messageLabel.setText(message + " will be copied to src/main/resources/schemas"));
    }

    protected MetadataTypeGraphicalChildrenProvider createMetaDataModelGraphicalChildrenProvider() {
        return new MetadataTypeGraphicalChildrenProvider();
    }

    public void applyChanges() {
        IFolder schemasFolder = this.getSchemasFolder();
        for (Resource resource : this.resources) {
            resource.copyTo(schemasFolder);
        }
    }
}

