/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.flatfile.contribution;

import com.mulesoft.flatfile.schema.fftypes.BooleanFormat;
import com.mulesoft.flatfile.schema.fftypes.DecimalFormat;
import com.mulesoft.flatfile.schema.fftypes.IntegerFormat;
import com.mulesoft.flatfile.schema.fftypes.LocalDateFormat;
import com.mulesoft.flatfile.schema.fftypes.LocalDateTimeFormat;
import com.mulesoft.flatfile.schema.fftypes.StringFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.flatfile.FlatfileTypeLoader;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.client.metadata.MetadataTypeHelper;
import org.mule.tooling.ui.widgets.treetable.ContentType;
import org.mule.tooling.ui.widgets.treetable.TypesManager;

public class FixedWidthTypesManager
implements TypesManager<MetadataType> {
    private static final List<ContentType<MetadataType>> metadataTypes = new ArrayList<ContentType<MetadataType>>();
    private static final BaseTypeBuilder typeBuilder = MetadataFactory.newBuilder((MetadataFormat)FlatfileTypeLoader.FIXED_WIDTH);
    public static final MetadataType STRING_TYPE = typeBuilder.stringType().build();
    public static final MetadataType INTEGER_TYPE = typeBuilder.numberType().integer().build();
    public static final MetadataType DECIMAL_TYPE = typeBuilder.numberType().id("double").build();
    public static final MetadataType BOOLEAN_TYPE = typeBuilder.booleanType().build();
    public static final MetadataType DATE_TYPE = typeBuilder.dateType().build();
    public static final MetadataType DATETIME_TYPE = typeBuilder.dateTimeType().build();

    static {
        metadataTypes.add((ContentType<MetadataType>)new ContentType(StringFormat.code(), StringFormat.code().toLowerCase(), (Object)STRING_TYPE));
        metadataTypes.add((ContentType<MetadataType>)new ContentType(IntegerFormat.code(), IntegerFormat.code().toLowerCase(), (Object)INTEGER_TYPE));
        metadataTypes.add((ContentType<MetadataType>)new ContentType(DecimalFormat.code(), DecimalFormat.code().toLowerCase(), (Object)DECIMAL_TYPE));
        metadataTypes.add((ContentType<MetadataType>)new ContentType(BooleanFormat.code(), BooleanFormat.code().toLowerCase(), (Object)BOOLEAN_TYPE));
        metadataTypes.add((ContentType<MetadataType>)new ContentType(LocalDateFormat.code(), LocalDateFormat.code().toLowerCase(), (Object)DATE_TYPE));
        metadataTypes.add((ContentType<MetadataType>)new ContentType(LocalDateTimeFormat.code(), LocalDateTimeFormat.code().toLowerCase(), (Object)DATETIME_TYPE));
    }

    public List<ContentType<MetadataType>> getTypes() {
        return metadataTypes;
    }

    public ContentType<MetadataType> getType(String id) {
        if (StringUtils.isNotBlank((String)id)) {
            for (ContentType<MetadataType> type : metadataTypes) {
                if (!type.getId().equals(id)) continue;
                return type;
            }
        }
        throw new IllegalArgumentException("Id: " + id + " is not a valid id");
    }

    public ContentType<MetadataType> getTypeFromParameterType(MetadataType metadataType) {
        if (metadataType != null) {
            for (ContentType<MetadataType> currentMetadataType : metadataTypes) {
                if (!MetadataTypeHelper.isAssignable((MetadataType)((MetadataType)currentMetadataType.getModel()), (MetadataType)metadataType)) continue;
                return currentMetadataType;
            }
        }
        throw new IllegalArgumentException("ContentType: " + String.valueOf(metadataType) + " is not a valid dataType for Fixed Width.");
    }
}

