/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.external.internal;

import java.io.File;
import java.io.InputStream;
import org.apache.maven.shared.invoker.CommandLineConfigurationException;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.InvokerLogger;
import org.apache.maven.shared.invoker.MavenCommandLineBuilder;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.shared.utils.cli.Commandline;

public class ToolingMavenInvoker
implements Invoker {
    private DefaultInvoker invoker;
    private File javaHome = null;

    public ToolingMavenInvoker(DefaultInvoker invoker) {
        this.invoker = invoker;
    }

    public Process rawExecute(InvocationRequest baseRequest, String commandline) throws MavenInvocationException {
        Commandline cli;
        File workingDirectory;
        File mavenExecutable;
        File mavenHome;
        File localRepo;
        MavenCommandLineBuilder cliBuilder = new MavenCommandLineBuilder();
        InvokerLogger logger = this.getLogger();
        if (logger != null) {
            cliBuilder.setLogger(this.getLogger());
        }
        if ((localRepo = this.getLocalRepositoryDirectory()) != null) {
            cliBuilder.setLocalRepositoryDirectory(this.getLocalRepositoryDirectory());
        }
        if ((mavenHome = this.getMavenHome()) != null) {
            cliBuilder.setMavenHome(this.getMavenHome());
        }
        if ((mavenExecutable = this.getMavenExecutable()) != null) {
            cliBuilder.setMavenExecutable(mavenExecutable);
        }
        if ((workingDirectory = this.getWorkingDirectory()) != null) {
            cliBuilder.setBaseDirectory(this.getWorkingDirectory());
        }
        try {
            cli = cliBuilder.build(baseRequest);
            if (this.getJavaHome() != null) {
                cli.addEnvironment("JAVA_HOME", this.getJavaHome().getAbsolutePath());
            }
            cli.createArg().setLine(commandline);
        }
        catch (CommandLineConfigurationException | CommandLineException e) {
            throw new MavenInvocationException("Error configuring command-line. Reason: " + e.getMessage(), e);
        }
        try {
            return cli.execute();
        }
        catch (CommandLineException e) {
            throw new MavenInvocationException("Error executing the maven command line", (Throwable)e);
        }
    }

    public Process asyncExecute(InvocationRequest request) throws MavenInvocationException {
        Commandline cli;
        File workingDirectory;
        File mavenExecutable;
        File mavenHome;
        File localRepo;
        MavenCommandLineBuilder cliBuilder = new MavenCommandLineBuilder();
        InvokerLogger logger = this.getLogger();
        if (logger != null) {
            cliBuilder.setLogger(this.getLogger());
        }
        if ((localRepo = this.getLocalRepositoryDirectory()) != null) {
            cliBuilder.setLocalRepositoryDirectory(this.getLocalRepositoryDirectory());
        }
        if ((mavenHome = this.getMavenHome()) != null) {
            cliBuilder.setMavenHome(this.getMavenHome());
        }
        if ((mavenExecutable = this.getMavenExecutable()) != null) {
            cliBuilder.setMavenExecutable(mavenExecutable);
        }
        if ((workingDirectory = this.getWorkingDirectory()) != null) {
            cliBuilder.setBaseDirectory(this.getWorkingDirectory());
        }
        try {
            cli = cliBuilder.build(request);
            if (this.getJavaHome() != null) {
                cli.addEnvironment("JAVA_HOME", this.getJavaHome().getAbsolutePath());
            }
        }
        catch (CommandLineConfigurationException e) {
            throw new MavenInvocationException("Error configuring command-line. Reason: " + e.getMessage(), (Throwable)e);
        }
        try {
            return cli.execute();
        }
        catch (CommandLineException e) {
            throw new MavenInvocationException("Error executing the maven command line", (Throwable)e);
        }
    }

    public File getLocalRepositoryDirectory() {
        return this.invoker.getLocalRepositoryDirectory();
    }

    public InvokerLogger getLogger() {
        return this.invoker.getLogger();
    }

    public File getMavenExecutable() {
        return this.invoker.getMavenExecutable();
    }

    public File getMavenHome() {
        return this.invoker.getMavenHome();
    }

    public File getJavaHome() {
        return this.javaHome;
    }

    public File getWorkingDirectory() {
        return this.invoker.getWorkingDirectory();
    }

    public Invoker setErrorHandler(InvocationOutputHandler errorHandler) {
        return this.invoker.setErrorHandler(errorHandler);
    }

    public Invoker setInputStream(InputStream inputStream) {
        return this.invoker.setInputStream(inputStream);
    }

    public Invoker setLocalRepositoryDirectory(File localRepositoryDirectory) {
        return this.invoker.setLocalRepositoryDirectory(localRepositoryDirectory);
    }

    public Invoker setLogger(InvokerLogger logger) {
        return this.invoker.setLogger(logger);
    }

    public Invoker setMavenExecutable(File mavenExecutable) {
        return this.invoker.setMavenExecutable(mavenExecutable);
    }

    public Invoker setMavenHome(File mavenHome) {
        return this.invoker.setMavenHome(mavenHome);
    }

    public Invoker setJavaHome(File javaHome) {
        this.javaHome = javaHome;
        return this.invoker;
    }

    public Invoker setOutputHandler(InvocationOutputHandler outputHandler) {
        return this.invoker.setOutputHandler(outputHandler);
    }

    public Invoker setWorkingDirectory(File workingDirectory) {
        return this.invoker.setWorkingDirectory(workingDirectory);
    }

    public InvocationResult execute(InvocationRequest arg0) throws MavenInvocationException {
        return this.invoker.execute(arg0);
    }
}

