/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.external.internal;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.eclipse.core.resources.IProject;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.maven.cmdline.MavenCommandLine;
import org.mule.tooling.maven.external.internal.ToolingMavenInvoker;
import org.mule.tooling.maven.runner.MavenExecutionException;
import org.mule.tooling.maven.runner.MavenRunner;
import org.mule.tooling.maven.runner.MavenRunnerCallback;
import org.mule.tooling.maven.runner.MavenRuntimeException;
import org.mule.tooling.maven.utils.OutputRedirectorThread;
import org.mule.tooling.maven.utils.RunnableUtils;

public class InvokerMavenRunner
implements MavenRunner {
    private final ToolingMavenInvoker invoker;
    private final String mavenOpts;
    private Process buildProcess;
    private OutputRedirectorThread outputRedirector;
    private OutputRedirectorThread errorRedirector;

    public InvokerMavenRunner(ToolingMavenInvoker invoker, String mavenOpts) {
        this.invoker = invoker;
        this.mavenOpts = mavenOpts;
    }

    public void runBare(MavenCommandLine commandLine, MavenRunnerCallback callback, OutputStream outputStream) {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setMavenOpts(this.mavenOpts);
        this.rawExecute((InvocationRequest)request, commandLine, callback, outputStream);
    }

    public void run(IProject project, MavenCommandLine commandLine, MavenRunnerCallback callback, OutputStream outputStream) throws MavenExecutionException {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setMavenOpts(this.mavenOpts);
        request.setBaseDirectory(project.getLocation().toFile());
        this.rawExecute((InvocationRequest)request, commandLine, callback, outputStream);
    }

    public void run(File pomFile, MavenCommandLine commandline, MavenRunnerCallback callback, OutputStream outputStream) throws MavenExecutionException {
        this.checkPomFileParameter(pomFile);
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setMavenOpts(this.mavenOpts);
        request.setPomFile(pomFile);
        this.rawExecute((InvocationRequest)request, commandline, callback, outputStream);
    }

    private void checkPomFileParameter(File pomFile) {
        if (pomFile == null) {
            throw new NullPointerException("Parameter pomFile received as null");
        }
        if (!pomFile.exists()) {
            throw new IllegalArgumentException("Pom file (" + pomFile.getAbsolutePath() + ") does not exist");
        }
    }

    private void rawExecute(InvocationRequest baseRequest, MavenCommandLine commandline, MavenRunnerCallback callback, OutputStream outputStream) {
        try {
            this.buildProcess = this.invoker.rawExecute(baseRequest, commandline.getRawCommandArguments());
            this.monitor(callback, outputStream);
        }
        catch (MavenInvocationException e) {
            throw new MavenRuntimeException("There was an error constructing the maven command line to execute", (Throwable)e);
        }
    }

    private void monitor(MavenRunnerCallback callback, OutputStream outputStream) {
        InputStream inputStream = this.buildProcess.getInputStream();
        InputStream errorStream = this.buildProcess.getErrorStream();
        this.outputRedirector = new OutputRedirectorThread(inputStream, outputStream, () -> {
            IOUtils.closeQuietly((InputStream)inputStream);
            if (this.outputRedirector.isInterrupted()) {
                this.logBuildInterruption(outputStream);
            }
        });
        this.outputRedirector.start();
        this.errorRedirector = new OutputRedirectorThread(errorStream, outputStream, RunnableUtils.newRunnableClosing((Closeable[])new Closeable[]{errorStream}));
        this.errorRedirector.start();
        new BuildWatchdog(this.buildProcess, callback).start();
    }

    private void logBuildInterruption(OutputStream outputStream) {
        String separator = StringUtils.repeat((String)"-", (int)"Build interrupted by user".length());
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.println("[WARNING] " + separator);
        printWriter.println("[WARNING] Build interrupted by user");
        printWriter.println("[WARNING] " + separator);
        printWriter.flush();
    }

    public void cancelBuild() {
        if (this.outputRedirector != null) {
            this.outputRedirector.interrupt();
        }
        if (this.errorRedirector != null) {
            this.errorRedirector.interrupt();
        }
        if (this.buildProcess != null) {
            try {
                ProcessHandle processHandle = this.buildProcess.toHandle();
                this.destroyProcessHandle(processHandle);
            }
            catch (Exception e) {
                MuleCorePlugin.logError((String)"There was a problem stopping the running Maven process", (Throwable)e);
            }
        }
    }

    private void destroyProcessHandle(ProcessHandle processHandle) {
        processHandle.descendants().forEach(this::destroyProcessHandle);
        boolean destroyed = processHandle.destroy();
        if (!destroyed) {
            processHandle.destroyForcibly();
        }
    }

    public String toString() {
        return "InvokerMavenRunner [mavenOpts=" + this.mavenOpts + "]";
    }

    private class BuildWatchdog
    extends Thread {
        private Process buildProcess;
        private final MavenRunnerCallback callback;

        public BuildWatchdog(Process buildProcess, MavenRunnerCallback callback) {
            super("BuildWatchdog");
            this.buildProcess = buildProcess;
            this.callback = callback;
        }

        @Override
        public void run() {
            try {
                int result = this.buildProcess.waitFor();
                this.buildProcess = null;
                this.callback.finished(result);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.callback.finished(-1);
            }
        }
    }
}

