/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.external;

import java.io.File;
import java.util.Optional;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.mule.tooling.maven.MavenPlugin;
import org.mule.tooling.maven.external.internal.InvokerMavenRunner;
import org.mule.tooling.maven.external.internal.ToolingMavenInvoker;
import org.mule.tooling.maven.runner.MavenBinarySearcher;
import org.mule.tooling.maven.runner.MavenRunner;
import org.mule.tooling.maven.runner.MavenRunnerConfiguration;
import org.mule.tooling.maven.runner.MavenRunnerFactory;

public class ExternalMavenRunnerFactory
implements MavenRunnerFactory {
    public Optional<MavenRunner> create(MavenRunnerConfiguration configuration, Optional<String> javaHome) {
        MavenRunner runner = null;
        if (configuration.isExternalInstallation()) {
            runner = this.doCreate(configuration, javaHome);
        }
        return Optional.ofNullable(runner);
    }

    private MavenRunner doCreate(MavenRunnerConfiguration configuration, Optional<String> javaHome) {
        String mavenHomePath = configuration.getMavenInstallationHome();
        if (mavenHomePath == null) {
            throw new IllegalStateException("Must configure 'Maven installation home directory' in Studio Maven Preferences or set M2_HOME before building");
        }
        String javaHomePath = javaHome.orElse(null);
        if (javaHomePath == null) {
            throw new IllegalStateException("Must have a proper JRE Runtime configure in Studio or set JAVA_HOME before building");
        }
        ToolingMavenInvoker invoker = new ToolingMavenInvoker(new DefaultInvoker());
        File mavenHome = new File(mavenHomePath);
        invoker.setMavenHome(mavenHome);
        invoker.setJavaHome(new File(javaHomePath));
        File mavenExecutable = MavenBinarySearcher.newInstance().search(new File(mavenHome, "bin"));
        if (mavenExecutable != null) {
            invoker.setMavenExecutable(mavenExecutable);
        } else {
            MavenPlugin.logWarning((String)"Couldn't determine Maven executable file");
        }
        return new InvokerMavenRunner(invoker, configuration.getMavenOpts());
    }
}

