/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metrics.impl.meter;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.mule.metrics.api.instrument.builder.LongCounterBuilder;
import org.mule.metrics.api.instrument.builder.LongGaugeBuilder;
import org.mule.metrics.api.instrument.builder.LongUpDownCounterBuilder;
import org.mule.metrics.api.meter.Meter;
import org.mule.metrics.api.meter.builder.MeterBuilder;
import org.mule.metrics.exporter.api.MeterExporter;
import org.mule.metrics.impl.instrument.DefaultLongCounter;
import org.mule.metrics.impl.instrument.DefaultLongGauge;
import org.mule.metrics.impl.instrument.DefaultLongUpDownCounter;
import org.mule.metrics.impl.instrument.repository.InstrumentRepository;
import org.mule.metrics.impl.meter.builder.MeterBuilderWithRepository;
import org.mule.metrics.impl.meter.repository.MeterRepository;

public class DefaultMeter
implements Meter {
    private final MeterExporter meterExporter;
    private final Map<String, String> meterAttributes;
    private final String meterName;
    private final String description;
    private final InstrumentRepository instrumentRepository = new InstrumentRepository();

    public static MeterBuilderWithRepository builder(String meterName) {
        return new DefaultMeterBuilder(meterName);
    }

    public DefaultMeter(String meterName, String description, MeterExporter meterExporter, Map<String, String> meterAttributes) {
        this.meterName = meterName;
        this.description = description;
        this.meterExporter = meterExporter;
        this.meterAttributes = meterAttributes;
        meterExporter.registerMeterToExport((Meter)this);
    }

    public String getName() {
        return this.meterName;
    }

    public String getDescription() {
        return this.description;
    }

    public void forEachAttribute(BiConsumer<String, String> biConsumer) {
        this.meterAttributes.forEach(biConsumer);
    }

    public LongUpDownCounterBuilder upDownCounterBuilder(String counterName) {
        return DefaultLongUpDownCounter.builder(counterName, this).withInstrumentRepository(this.instrumentRepository).withMeterExporter(this.meterExporter);
    }

    public LongCounterBuilder counterBuilder(String counterName) {
        return DefaultLongCounter.builder(counterName, this).withInstrumentRepository(this.instrumentRepository).withMeterExporter(this.meterExporter);
    }

    public LongGaugeBuilder gaugeBuilder(String gaugeName) {
        return DefaultLongGauge.builder(gaugeName, this).withInstrumentRepository(this.instrumentRepository).withMeterExporter(this.meterExporter);
    }

    private static class DefaultMeterBuilder
    implements MeterBuilderWithRepository {
        private final String meterName;
        private String description;
        private MeterRepository meterRepository;
        private MeterExporter meterExporter;
        private final Map<String, String> meterAttributes = new HashMap<String, String>();

        public DefaultMeterBuilder(String meterName) {
            this.meterName = meterName;
        }

        public MeterBuilder withDescription(String description) {
            this.description = description;
            return this;
        }

        public MeterBuilder withMeterAttribute(String key, String value) {
            this.meterAttributes.put(key, value);
            return this;
        }

        public Meter build() {
            Objects.requireNonNull(this.meterExporter);
            if (this.meterRepository != null) {
                return this.meterRepository.create(this.meterName, name -> this.doBuild((String)name, this.description, this.meterExporter, this.meterAttributes));
            }
            return this.doBuild(this.meterName, this.description, this.meterExporter, this.meterAttributes);
        }

        private Meter doBuild(String meterName, String description, MeterExporter meterExporter, Map<String, String> meterAttributes) {
            return new DefaultMeter(meterName, description, meterExporter, meterAttributes);
        }

        @Override
        public MeterBuilderWithRepository withMeterRepository(MeterRepository meterRepository) {
            this.meterRepository = meterRepository;
            return this;
        }

        @Override
        public MeterBuilderWithRepository withMeterExporter(MeterExporter meterExporter) {
            this.meterExporter = meterExporter;
            return this;
        }
    }
}

