/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.alert;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.mule.api.annotation.Experimental;
import org.mule.runtime.api.alert.TimedDataAggregation;
import org.mule.runtime.api.time.TimeSupplier;
import org.mule.runtime.internal.alert.TimedData;

@Experimental
public class TimedDataBuffer<T> {
    private final Supplier<Instant> instantSupplier;
    private Deque<TimedData<T>> buffer = new ConcurrentLinkedDeque<TimedData<T>>();

    public TimedDataBuffer() {
        this.instantSupplier = () -> Instant.now();
    }

    public TimedDataBuffer(TimeSupplier timeSupplier) {
        this.instantSupplier = timeSupplier::getAsInstant;
    }

    public void put(T data) {
        Instant now = this.instantSupplier.get();
        this.evictOldEntries(now);
        this.buffer.addFirst(new TimedData<T>(now, data));
    }

    public int size() {
        this.evictOldEntries(this.instantSupplier.get());
        return this.buffer.size();
    }

    public <A> TimedDataAggregation<A> aggregate(A baseIntevalAggregation, BiFunction<A, T, A> accumulator) {
        Instant now = this.instantSupplier.get();
        this.evictOldEntries(now);
        A agg60 = baseIntevalAggregation;
        A agg15 = baseIntevalAggregation;
        A agg5 = baseIntevalAggregation;
        A agg1 = baseIntevalAggregation;
        Instant mark15 = now.minus(15L, ChronoUnit.MINUTES);
        Instant mark5 = now.minus(5L, ChronoUnit.MINUTES);
        Instant mark1 = now.minus(1L, ChronoUnit.MINUTES);
        Iterator<TimedData<T>> it = this.buffer.descendingIterator();
        while (it.hasNext()) {
            TimedData<T> next = it.next();
            agg60 = accumulator.apply(agg60, next.getData());
            if (next.getTime().isAfter(mark15)) {
                agg15 = accumulator.apply(agg15, next.getData());
            }
            if (next.getTime().isAfter(mark5)) {
                agg5 = accumulator.apply(agg5, next.getData());
            }
            if (!next.getTime().isAfter(mark1)) continue;
            agg1 = accumulator.apply(agg1, next.getData());
        }
        return new TimedDataAggregation<A>(now, agg1, agg5, agg15, agg60);
    }

    private void evictOldEntries(Instant now) {
        Instant timeLimit = now.minus(60L, ChronoUnit.MINUTES);
        TimedData<T> last = this.buffer.peekLast();
        while (last != null && last.getTime().isBefore(timeLimit)) {
            this.buffer.removeLast();
            last = this.buffer.peekLast();
        }
    }
}

