/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.Scope;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.decorator.MuleConfigurationDecorator;

public class AttributeContext {
    protected final IMuleProject muleProject;
    private MuleConfiguration muleConfiguration;
    private MuleConfigurationDecorator decorator;
    private IContainer parent;
    private IFile xmlConfigFile;

    public AttributeContext(IMuleProject project) {
        IEditorPart activeEditor;
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWorkbenchWindow;
        this.muleProject = project;
        this.xmlConfigFile = null;
        if (Display.getCurrent() != null && (activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (activePage = activeWorkbenchWindow.getActivePage()) != null && (activeEditor = activePage.getActiveEditor()) != null && activeEditor instanceof MultiPageMessageFlowEditor) {
            MultiPageMessageFlowEditor muleEditor = (MultiPageMessageFlowEditor)activeEditor;
            this.muleConfiguration = muleEditor.getMuleConfiguration();
            this.decorator = muleEditor.getMuleConfigurationDecorator();
            IEditorInput editorInput = muleEditor.getEditorInput();
            if (editorInput != null && editorInput instanceof IFileEditorInput && this.parent == null) {
                IFileEditorInput m = (IFileEditorInput)editorInput;
                this.xmlConfigFile = m.getFile();
                this.parent = m.getFile().getParent();
            }
        }
    }

    public AttributeContext(IMuleProject project, MuleConfiguration config, IFile actualXmlConfigFile) {
        this.xmlConfigFile = actualXmlConfigFile;
        this.muleProject = project;
        this.muleConfiguration = config;
        IContainer iContainer = this.parent = actualXmlConfigFile != null ? actualXmlConfigFile.getParent() : null;
        if (Display.getCurrent() != null && PlatformUI.isWorkbenchRunning()) {
            IEditorPart activeEditor;
            IWorkbenchPage activePage;
            IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (activeWorkbenchWindow != null && (activePage = activeWorkbenchWindow.getActivePage()) != null && (activeEditor = activePage.getActiveEditor()) != null && activeEditor instanceof MultiPageMessageFlowEditor) {
                MultiPageMessageFlowEditor muleEditor = (MultiPageMessageFlowEditor)activeEditor;
                this.decorator = muleEditor.getMuleConfigurationDecorator();
                IEditorInput editorInput = muleEditor.getEditorInput();
                if (editorInput != null && editorInput instanceof IFileEditorInput) {
                    IFileEditorInput m = (IFileEditorInput)editorInput;
                    this.parent = m.getFile().getParent();
                }
            }
        } else {
            this.parent = actualXmlConfigFile.getParent();
        }
    }

    public AttributeContext() {
        IFile fl;
        if (Display.getCurrent() != null) {
            MultiPageMessageFlowEditor activeEditor = (MultiPageMessageFlowEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            this.muleConfiguration = activeEditor != null ? activeEditor.getMuleConfiguration() : null;
            this.decorator = activeEditor != null ? activeEditor.getMuleConfigurationDecorator() : null;
            this.xmlConfigFile = fl = (IFile)activeEditor.getEditorInput().getAdapter(IFile.class);
            this.muleProject = MuleRuntime.create((IProject)fl.getProject());
            if (this.muleProject == null) {
                throw new IllegalStateException("Null Mule project at attribute context");
            }
        } else {
            throw new IllegalStateException("Should be used from GUI Thread only");
        }
        this.parent = fl.getParent();
    }

    public MuleConfigurationDecorator getDecorator() {
        return this.decorator;
    }

    public void setDecorator(MuleConfigurationDecorator decorator) {
        this.decorator = decorator;
    }

    public void setMuleConfiguration(MuleConfiguration muleConfiguration) {
        this.muleConfiguration = muleConfiguration;
    }

    public List<IMessageFlowEntity> getGlobalEntries() {
        return Lists.newArrayList((Iterable)Iterables.concat(this.getGlobalEntriesWithConfig().values()));
    }

    public Map<MuleConfiguration, List<IMessageFlowEntity>> getGlobalEntriesWithConfig() {
        HashMap<MuleConfiguration, List<IMessageFlowEntity>> configWithEntities = new HashMap<MuleConfiguration, List<IMessageFlowEntity>>();
        if (this.parent != null) {
            List<MuleConfiguration> configurations = this.collectMuleConfigurations();
            for (MuleConfiguration configuration : configurations) {
                if (!CoreUtils.belongToSameVisibilityScope((MuleConfiguration)this.getMuleConfiguration(), (MuleConfiguration)configuration)) {
                    Scope.Visibility configVisibility = Scope.Visibility.parse((String)configuration.getVisibility());
                    if (configVisibility == Scope.Visibility.LOCAL) continue;
                    configWithEntities.put(configuration, configuration.getGlobalEntries());
                    continue;
                }
                configWithEntities.put(configuration, configuration.getGlobalEntries());
            }
        }
        return configWithEntities;
    }

    public List<Container> getFlows() {
        return Lists.newArrayList((Iterable)Iterables.concat(this.getConfigWithFlows().values()));
    }

    public Map<MuleConfiguration, List<Container>> getConfigWithFlows() {
        HashMap<MuleConfiguration, List<Container>> configsWithFlows = new HashMap<MuleConfiguration, List<Container>>();
        List<MuleConfiguration> entries = this.collectMuleConfigurations();
        for (MuleConfiguration configuration : entries) {
            if (!CoreUtils.belongToSameVisibilityScope((MuleConfiguration)this.getMuleConfiguration(), (MuleConfiguration)configuration)) {
                Scope.Visibility configVisibility = Scope.Visibility.parse((String)configuration.getVisibility());
                if (configVisibility == Scope.Visibility.LOCAL) continue;
                configsWithFlows.put(configuration, configuration.getFlows());
                continue;
            }
            configsWithFlows.put(configuration, configuration.getFlows());
        }
        return configsWithFlows;
    }

    private List<MuleConfiguration> collectMuleConfigurations() {
        List<Object> deployableConfigs = new ArrayList<MuleConfiguration>();
        try {
            MuleConfiguration muleConfiguration = this.getMuleConfiguration();
            boolean configPresent = this.getXmlConfigFile() != null && muleConfiguration != null;
            deployableConfigs = CoreUtils.collectDeployableMuleConfigurationsFromProjectExcluding((IMuleProject)this.getProject(), (IFile)(configPresent ? this.getXmlConfigFile() : null), (this.getXmlConfigFile() == null ? 1 : 0) != 0);
            if (configPresent && !deployableConfigs.contains(muleConfiguration)) {
                deployableConfigs.add(muleConfiguration);
            }
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)"Error getting MuleConfigurations...", (Throwable)e);
        }
        return deployableConfigs;
    }

    public boolean isTestConfigFile() {
        if (MuleProjectKind.APPLICATION.classifies(this.muleProject)) {
            return ((IMuleApplicationProject)MuleProjectKind.APPLICATION.adapt(this.muleProject)).isTestResource((IResource)this.getXmlConfigFile());
        }
        return false;
    }

    private IFile getXmlConfigFile() {
        return this.xmlConfigFile;
    }

    public MuleConfiguration getMuleConfiguration() {
        if (this.muleConfiguration == null) {
            if (this.muleProject != null && this.xmlConfigFile != null) {
                this.muleConfiguration = this.muleProject.getConfigurationsCache().getConfiguration(this.xmlConfigFile);
            } else {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        AttributeContext.this.muleConfiguration = MessageFlowUtils.getMuleConfigFromActivePage();
                    }
                });
            }
        }
        return this.muleConfiguration;
    }

    public IMuleProject getProject() {
        return this.muleProject;
    }

    public String getVersion() {
        if (this.getProject() != null && this.getProject().getServerDefinition() != null) {
            return this.getProject().getServerDefinition().getVersionWithEESign();
        }
        return null;
    }
}

