/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.util;

import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.List;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.core.StudioDesignContextRunner;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.dom.INodeListWrapper;
import org.mule.tooling.core.dom.INodeWrapper;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.messageflow.util.ExpressionPathParser;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.CommentContainer;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.UnknownNode;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.model.messageflow.util.IMessageProcessorNode;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitorAdapter;
import org.mule.tooling.model.messageflow.util.TreeMuleConfiguration;
import org.mule.tooling.model.messageflow.util.TreeMuleConfigurationGenerator;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.model.module.NestedContainerDefinition;

public class MulePathBuilder {
    private static final NullPositionCalculator NULL_CALCULATOR = new NullPositionCalculator();
    private final IMuleProject muleProject;
    private final TreeMuleConfiguration muleConfiguration;
    private final HashBiMap<MessageFlowEntity, MulePath> pathsMap = HashBiMap.create();

    public MulePathBuilder(MuleConfiguration muleConfiguration) {
        this(muleConfiguration, null);
    }

    public MulePathBuilder(MuleConfiguration muleConfiguration, IMuleProject muleProject) {
        this.muleConfiguration = new TreeMuleConfigurationGenerator().generateTreeConfiguration(muleConfiguration);
        this.muleProject = muleProject;
    }

    public HashBiMap<MessageFlowEntity, MulePath> getAllMulePaths() {
        if (this.getPathsMap().isEmpty()) {
            this.load();
        }
        return this.getPathsMap();
    }

    protected void load() {
        IMessageProcessorNode root = this.muleConfiguration.getRoot();
        List children = root.getChildren();
        for (IMessageProcessorNode processorNode : children) {
            this.buildPath(processorNode, null, NULL_CALCULATOR);
        }
    }

    protected void buildPath(IMessageProcessorNode<?> elementNode, MulePath parentPath, PositionCalculator calculator) {
        elementNode.getValue().accept((MessageFlowEntityVisitor)new MulePathBuilderVisitor(elementNode, parentPath, calculator));
    }

    private HashBiMap<MessageFlowEntity, MulePath> getPathsMap() {
        return this.pathsMap;
    }

    private class MulePathBuilderVisitor
    extends MessageFlowEntityVisitorAdapter {
        private final IMessageProcessorNode<?> elementNode;
        private final MulePath parentPath;
        private final PositionCalculator calculator;

        private MulePathBuilderVisitor(IMessageProcessorNode<?> elementNode, MulePath parentPath, PositionCalculator calculator) {
            this.elementNode = elementNode;
            this.parentPath = parentPath;
            this.calculator = calculator;
        }

        public void visitContainer(Container container) {
            if (MulePathBuilder.this.muleProject == null) {
                this.createContainerPath(this.elementNode, this.parentPath, container);
            } else {
                StudioDesignContextRunner.runSilentWithMuleProject(() -> this.createContainerPath(this.elementNode, this.parentPath, container), (IMuleProject)MulePathBuilder.this.muleProject);
            }
        }

        private void createContainerPath(IMessageProcessorNode<?> elementNode, MulePath parentPath, Container container) {
            ContainerDefinition definition;
            MulePath containerPath = null;
            if (CoreUtils.isExceptionStrategy((IMessageFlowNode)container) && "http://www.mulesoft.org/schema/mule/core/exceptionStrategyLane".equals(MessageFlowUtils.getType((IMessageFlowEntity)elementNode.getParent().getValue()))) {
                containerPath = parentPath;
            }
            if (containerPath == null && (definition = (ContainerDefinition)container.getDefinition()) != null) {
                containerPath = new ExpressionPathParser(definition.getPathExpression()).forName(container.getName()).onIndex(this.getPosition(elementNode)).ofType(container.getType()).parseUsing(parentPath);
            }
            MulePathBuilder.this.getPathsMap().forcePut((Object)container, containerPath);
            this.addChildren(elementNode, containerPath, NULL_CALCULATOR);
        }

        public void visitEndpointNode(EndpointNode endpointNode) {
            this.createMulePath(this.elementNode, this.parentPath);
        }

        public void visitUnknownNode(UnknownNode unknownNode) {
            this.createMulePath(this.elementNode, this.parentPath);
        }

        public void visitCommentNode(CommentContainer commentNode) {
        }

        public void visitGlobalElement(GlobalElement globalElement) {
            if (CoreUtils.isExceptionStrategy((IMessageFlowNode)globalElement)) {
                MulePath mulePath = new MulePath(CoreUtils.getNameProperty((IMessageFlowNode)globalElement));
                MulePathBuilder.this.getPathsMap().forcePut((Object)globalElement, (Object)mulePath);
                this.addChildren(this.elementNode, mulePath.createChild("errorHandler"), NULL_CALCULATOR);
            } else {
                MulePath mulePath = new MulePath(CoreUtils.getNameProperty((IMessageFlowNode)globalElement));
                MulePathBuilder.this.getPathsMap().forcePut((Object)globalElement, (Object)mulePath);
                this.addChildren(this.elementNode, mulePath, this.calculator);
            }
        }

        public void visitNestedContainer(NestedContainer nestedContainer) {
            if (MulePathBuilder.this.muleProject == null) {
                this.createNestedContainerDefinition(this.elementNode, this.parentPath, nestedContainer);
            } else {
                StudioDesignContextRunner.runSilentWithMuleProject(() -> this.createNestedContainerDefinition(this.elementNode, this.parentPath, nestedContainer), (IMuleProject)MulePathBuilder.this.muleProject);
            }
        }

        private void createNestedContainerDefinition(IMessageProcessorNode<?> elementNode, MulePath parentPath, NestedContainer nestedContainer) {
            NestedContainerDefinition definition = (NestedContainerDefinition)nestedContainer.getDefinition();
            if (definition.contributesToPath()) {
                int location = this.getLocationFor(elementNode);
                MulePath nestedContainerPath = new ExpressionPathParser(definition.getPathExpression()).forName(nestedContainer.getName()).onIndex(this.getPosition(elementNode)).ofType(nestedContainer.getType()).atLocation(location).parseUsing(parentPath);
                MulePathBuilder.this.getPathsMap().forcePut((Object)nestedContainer, (Object)nestedContainerPath);
                this.addChildren(elementNode, nestedContainerPath, NULL_CALCULATOR);
            } else {
                this.addChildren(elementNode, parentPath, new OffsetPositionCalculator(this.getOffset(elementNode)));
            }
        }

        private int getLocationFor(IMessageProcessorNode<?> messageProcessorNode) {
            ArrayList sortedChildrenWithDefinitions = new ArrayList();
            IMessageProcessorNode processorParentNode = messageProcessorNode.getParent();
            List siblingProcessorNodes = processorParentNode.getChildren();
            IElementWrapper parentElement = processorParentNode.getValue().getElement();
            IElementWrapper element = messageProcessorNode.getValue().getElement();
            if (parentElement.getChildElements() != null) {
                parentElement.getChildElements().forEach(child -> {
                    boolean isInVisualModelAndXml = siblingProcessorNodes.stream().map(IMessageProcessorNode::getValue).map(MessageFlowEntity::getElement).anyMatch(el -> el.equals(child));
                    if (isInVisualModelAndXml) {
                        sortedChildrenWithDefinitions.add(child);
                    }
                });
            }
            int position = sortedChildrenWithDefinitions.indexOf(element);
            return position;
        }

        protected void addChildren(IMessageProcessorNode<?> root, MulePath createChild, PositionCalculator calculator) {
            List children = root.getChildren();
            for (IMessageProcessorNode processorNode : children) {
                MulePathBuilder.this.buildPath(processorNode, createChild, calculator);
            }
        }

        public void visitCompartment(Compartment compartment) {
            this.addChildren(this.elementNode, this.parentPath, NULL_CALCULATOR);
        }

        public void visitCompartmentLane(CompartmentLane lane) {
            this.addChildren(this.elementNode, this.parentPath, NULL_CALCULATOR);
        }

        protected MulePath createMulePath(IMessageProcessorNode<?> parentNode, MulePath parent) {
            if (parent == null) {
                return new MulePath("");
            }
            int position = this.calculator.calculateFrom(parentNode);
            IMessageProcessorNode firstChild = parentNode.getParent().getFirstChild();
            MessageFlowEntity firstElement = firstChild.getValue();
            if (ModelUtils.isMessageSource((IMessageFlowEntity)firstElement)) {
                MulePathBuilder.this.getPathsMap().forcePut((Object)parentNode.getValue(), (Object)parent);
                return parent;
            }
            MulePath createChild = parent.createChild(position);
            MulePathBuilder.this.getPathsMap().forcePut((Object)parentNode.getValue(), (Object)createChild);
            return createChild;
        }

        protected MulePath createMulePath(IMessageProcessorNode<?> parentNode, MulePath parent, String lanePath, String processesMarker) {
            if (parent == null) {
                return new MulePath("");
            }
            int position = this.calculator.calculateFrom(parentNode);
            IMessageProcessorNode firstChild = parentNode.getParent().getFirstChild();
            MessageFlowEntity firstElement = firstChild.getValue();
            if (ModelUtils.isMessageSource((IMessageFlowEntity)firstElement)) {
                MulePathBuilder.this.getPathsMap().forcePut((Object)parentNode.getValue(), (Object)parent);
                return parent;
            }
            MulePath createChild = parent.createChild(lanePath);
            MulePath laneChild = createChild.createChild(position);
            MulePath laneWithProcessorsChild = laneChild.createChild(processesMarker);
            MulePathBuilder.this.getPathsMap().forcePut((Object)parentNode.getValue(), (Object)laneChild);
            return laneWithProcessorsChild;
        }

        public void visitPatternNode(PatternNode patternNode) {
            this.createMulePath(this.elementNode, this.parentPath);
        }

        public void visitSplitterNode(SplitterNode splitterNode) {
            MulePath splitterPath = this.createMulePath(this.elementNode, this.parentPath);
            MulePathBuilder.this.getPathsMap().forcePut((Object)splitterNode, (Object)splitterPath);
            if (ModelUtils.isAll((IMessageFlowEntity)splitterNode)) {
                List children = this.elementNode.getFirstChild().getChildren();
                for (IMessageProcessorNode branchNode : children) {
                    if (branchNode.getChildren().size() >= 2) {
                        this.addChildren(branchNode, this.createMulePath(branchNode, splitterPath, "route", "processors"), NULL_CALCULATOR);
                        continue;
                    }
                    if (branchNode.getChildren().isEmpty()) continue;
                    MulePath branchPath = splitterPath.createChild(branchNode.getPosition());
                    IMessageProcessorNode elementNode = (IMessageProcessorNode)branchNode.getChildren().get(0);
                    MulePathBuilder.this.getPathsMap().forcePut((Object)elementNode.getValue(), (Object)branchPath);
                    this.addChildren(elementNode, this.createMulePath(branchNode, splitterPath, "route", "processors"), NULL_CALCULATOR);
                }
            } else {
                List children = this.elementNode.getFirstChild().getChildren();
                INodeListWrapper xmlChildElements = this.elementNode.getValue().getElement().getChildElements();
                for (IMessageProcessorNode branchNode : children) {
                    boolean isInXml;
                    IElementWrapper branchXmlElement = branchNode.getValue().getElement();
                    boolean bl = isInXml = xmlChildElements.indexOf((INodeWrapper)branchXmlElement) >= 0;
                    if (!isInXml) continue;
                    this.addChildren(branchNode, this.createMulePath(branchNode, splitterPath, "route", "processors"), NULL_CALCULATOR);
                }
            }
        }

        private int getOffset(IMessageProcessorNode<?> elementNode) {
            int offset = 0;
            for (IMessageProcessorNode el : elementNode.getParent().getChildren()) {
                if (el.equals(elementNode)) break;
                offset += el.getChildren().size();
            }
            return offset;
        }

        private String getPosition(IMessageProcessorNode<?> elementNode) {
            return elementNode == null ? "0" : String.valueOf(elementNode.getPosition());
        }
    }

    private static class NullPositionCalculator
    implements PositionCalculator {
        private NullPositionCalculator() {
        }

        @Override
        public int calculateFrom(IMessageProcessorNode<?> parentNode) {
            return parentNode.getPosition();
        }
    }

    private static class OffsetPositionCalculator
    implements PositionCalculator {
        private int offset = 0;

        public OffsetPositionCalculator(int offset) {
            this.offset = offset;
        }

        @Override
        public int calculateFrom(IMessageProcessorNode<?> parentNode) {
            return this.offset + parentNode.getPosition();
        }
    }

    private static interface PositionCalculator {
        public int calculateFrom(IMessageProcessorNode<?> var1);
    }
}

