/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.util.IMuleFlowProvider;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;

public class MuleFlowProviderImpl
implements IMuleFlowProvider {
    private Map<String, Container> flows;
    private Map<String, GlobalElement> globalElements;
    private Map<String, MuleConfiguration> globalElementToConfigMap;
    private Map<String, MuleConfiguration> flowToConfigMap;
    private IMuleProject project;
    private MuleConfiguration currentConfiguration;

    public MuleFlowProviderImpl(IMuleProject project, MuleConfiguration currentConfiguration) {
        this.project = project;
        this.currentConfiguration = currentConfiguration;
    }

    @Override
    public Collection<Container> getFlows() {
        this.initFlowsIfNecessary();
        return this.flows.values();
    }

    @Override
    public Container getFlowByName(String flowName) {
        this.initFlowsIfNecessary();
        return this.flows.get(flowName);
    }

    @Override
    public MuleConfiguration getConfigForFlow(String flowName) {
        this.initFlowsIfNecessary();
        return this.flowToConfigMap.get(flowName);
    }

    @Override
    public MuleConfiguration getConfigForGlobalElement(String flowName) {
        this.initFlowsIfNecessary();
        return this.globalElementToConfigMap.get(flowName);
    }

    public void initFlowsIfNecessary() {
        if (this.flows == null || this.globalElements == null) {
            this.doInitFlows();
        }
    }

    private void doInitFlows() {
        this.flows = new HashMap<String, Container>();
        this.flowToConfigMap = new HashMap<String, MuleConfiguration>();
        this.globalElements = new HashMap<String, GlobalElement>();
        this.globalElementToConfigMap = new HashMap<String, MuleConfiguration>();
        this.addFlowsFromConfig(this.currentConfiguration);
        this.addGlobalElementFromConfig(this.currentConfiguration);
        List<MuleConfiguration> configurations = this.collectMuleConfigurations();
        for (MuleConfiguration configuration : configurations) {
            this.addFlowsFromConfig(configuration);
            this.addGlobalElementFromConfig(configuration);
        }
    }

    public void addFlowsFromConfig(MuleConfiguration configuration) {
        if (configuration == null) {
            return;
        }
        List configFlows = configuration.getFlows();
        for (Container flow : configFlows) {
            this.flows.put(flow.getName(), flow);
            this.flowToConfigMap.put(flow.getName(), configuration);
        }
    }

    public void addGlobalElementFromConfig(MuleConfiguration configuration) {
        if (configuration == null) {
            return;
        }
        for (IMessageFlowEntity value : configuration.getGlobalEntries()) {
            if (!(value instanceof GlobalElement)) continue;
            GlobalElement globalElem = (GlobalElement)value;
            String elementName = MessageFlowUtils.getPropertyValue(globalElem.getProperties(), "name");
            this.globalElements.put(elementName, globalElem);
            this.globalElementToConfigMap.put(elementName, configuration);
        }
    }

    private List<MuleConfiguration> collectMuleConfigurations() {
        return this.project.getConfigurationsCache().getConfigurations();
    }
}

