/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.util;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.Category;
import org.mule.tooling.core.ICategory;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.builder.messageflow.IQNameMeta;
import org.mule.tooling.core.dom.IConfigurableElement;
import org.mule.tooling.core.dom.IDocumentWrapper;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.generator.NewFlowTransformerContext;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.css.events.FigureDisposedEvent;
import org.mule.tooling.messageflow.ScrollingGraphicalViewerWithoutGrid;
import org.mule.tooling.messageflow.dialog.ISimpleHost;
import org.mule.tooling.messageflow.editor.DefinitionsHelper;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.editpart.ContainerEditPart;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.editpart.ICollapsibleEditPart;
import org.mule.tooling.messageflow.editpart.MessageFlowEditPartFactory;
import org.mule.tooling.messageflow.editpart.ScalableRootWithoutGridEditPart;
import org.mule.tooling.messageflow.editpart.SplitterEditPart;
import org.mule.tooling.messageflow.events.CreatedElementOnCanvasEvent;
import org.mule.tooling.messageflow.events.ToggleCommentElementOnCanvasEvent;
import org.mule.tooling.messageflow.figure.FigureImageRegistry;
import org.mule.tooling.messageflow.module.MessageFlowNodeComposite;
import org.mule.tooling.messageflow.util.GetAllFigureChildren;
import org.mule.tooling.messageflow.util.MessageFlowEntityRef;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.ComponentId;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.DefaultNodeNameProvider;
import org.mule.tooling.model.messageflow.EndpointDirection;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.INodeNameProvider;
import org.mule.tooling.model.messageflow.IPropertyCollectionReadCapability;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.Route;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.UnknownNode;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.messageflow.decorator.MuleConfigurationDecorator;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitorAdapter;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.model.module.EndpointDefinition;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.utils.UiUtils;
import org.mule.tooling.ui.widgets.util.ImageDecorator;
import org.mule.tooling.ui.widgets.util.OverlayImageIcon;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.utils.InMemoryConfigurationFile;
import org.mule.tooling.utils.ObjectHolder;
import org.mule.tooling.utils.UtilsPlugin;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEvent;

public class MessageFlowUtils {
    private static final Pattern NAME_PATTERN_REGEX = Pattern.compile("<([A-Za-z0-9]+) ");
    private static final Pattern DOC_NAME_REGEX = Pattern.compile(".*doc:name=\"([^\"]+)");
    public static final String XML_EXTENSION = ".xml";

    private MessageFlowUtils() {
    }

    public static Image getImageForPreview(Figure figure) {
        int xPosition = figure.getLocation().x;
        int yPosition = figure.getLocation().y;
        double zoom = MessageFlowUtils.getCurrentZoom();
        int width = figure.getBounds().width;
        int height = figure.getBounds().height;
        Image tmpImage = new Image((Device)Display.getCurrent(), xPosition + width, yPosition + height);
        Image resultImage = new Image((Device)Display.getCurrent(), width, height);
        GC gc = new GC((Drawable)tmpImage);
        SWTGraphics graphics = new SWTGraphics(gc);
        figure.paint((Graphics)graphics);
        gc.copyArea(resultImage, xPosition, yPosition);
        graphics.dispose();
        if (!gc.isDisposed()) {
            gc.dispose();
        }
        if (!tmpImage.isDisposed()) {
            tmpImage.dispose();
        }
        width = (int)((double)width * zoom);
        height = (int)((double)height * zoom);
        boolean needResize = false;
        int maxWidth = MessageFlowUtils.getCanvasWidth();
        int maxHeight = MessageFlowUtils.getCanvasHeight();
        if (width > maxWidth) {
            height = (int)((double)maxWidth / ((double)width / (double)height));
            width = maxWidth;
            needResize = true;
        }
        if (height > maxHeight) {
            width = (int)((double)maxHeight / ((double)height / (double)width));
            height = maxHeight;
            needResize = true;
        }
        if (needResize || zoom != 1.0) {
            resultImage = MessageFlowUtils.resize(resultImage, width, height);
        }
        return resultImage;
    }

    private static Image resize(Image image, int width, int height) {
        Image scaled = new Image((Device)Display.getDefault(), width, height);
        GC gc = new GC((Drawable)scaled);
        gc.setAntialias(1);
        gc.setInterpolation(2);
        gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, width, height);
        gc.dispose();
        image.dispose();
        return scaled;
    }

    private static double getCurrentZoom() {
        MessageFlowEditor flowEditorFromActivePage = MessageFlowUtils.getFlowEditorFromActivePage();
        if (flowEditorFromActivePage != null) {
            ScrollingGraphicalViewer viewer = (ScrollingGraphicalViewer)flowEditorFromActivePage.getViewer();
            ScalableRootEditPart editPart = (ScalableRootEditPart)viewer.getRootEditPart();
            ZoomManager zoomManager = editPart.getZoomManager();
            return zoomManager.getZoom();
        }
        return 1.0;
    }

    private static int getCanvasHeight() {
        MessageFlowEditor flowEditorFromActivePage = MessageFlowUtils.getFlowEditorFromActivePage();
        if (flowEditorFromActivePage != null) {
            return flowEditorFromActivePage.getViewer().getControl().getBounds().height;
        }
        return 600;
    }

    private static int getCanvasWidth() {
        MessageFlowEditor flowEditorFromActivePage = MessageFlowUtils.getFlowEditorFromActivePage();
        if (flowEditorFromActivePage != null) {
            return flowEditorFromActivePage.getViewer().getControl().getBounds().width;
        }
        return 600;
    }

    public static Image getImage(EntityEditPart<MessageFlowEntity> entityEditPart) {
        int xPosition = ((Figure)entityEditPart.getFigure()).getLocation().x;
        int yPosition = ((Figure)entityEditPart.getFigure()).getLocation().y;
        int width = entityEditPart.getFigure().getBounds().width;
        int height = entityEditPart.getFigure().getBounds().height;
        Image tmpImage = new Image((Device)Display.getCurrent(), xPosition + width, yPosition + height);
        Image resultImage = new Image((Device)Display.getCurrent(), width, height);
        GC gc = new GC((Drawable)tmpImage);
        entityEditPart.getFigure().paint((Graphics)new SWTGraphics(gc));
        gc.copyArea(resultImage, xPosition, yPosition);
        gc.dispose();
        tmpImage.dispose();
        return resultImage;
    }

    public static ImageDescriptor getOrCreateIconDescriptorFromCache(NodeDefinition containerDefinition, ImageDescriptor icon, com.google.common.base.Optional<IMuleModuleManager> muleProject) {
        return MessageFlowUtils.createAndCachePaletteIcon(containerDefinition, icon);
    }

    public static Image getOrCreateIconImageFromCache(NodeDefinition containerDefinition, ImageDescriptor icon, com.google.common.base.Optional<IMuleModuleManager> muleProject) {
        MessageFlowUtils.createAndCachePaletteIcon(containerDefinition, icon);
        return FigureImageRegistry.getDefault().get(containerDefinition.getId());
    }

    public static Image getCompleteImage(Image image, ImageDescriptor[] overlays, ImageDescriptor severityDecorator, com.google.common.base.Optional<MessageFlowNode> node) {
        OverlayImageIcon overlayIcon = new OverlayImageIcon(image);
        if (severityDecorator != null) {
            overlayIcon.addDecoration(new ImageDecorator(severityDecorator, 0));
        }
        overlayIcon.addDecorations(overlays);
        Image resultImageOverlay = overlayIcon.createImage();
        return resultImageOverlay;
    }

    private static ImageDescriptor createAndCachePaletteIcon(NodeDefinition containerDefinition, ImageDescriptor icon) {
        ImageDescriptor cachedImage = FigureImageRegistry.getDefault().getImageDescriptor(containerDefinition.getId());
        if (cachedImage == null) {
            FigureImageRegistry.getDefault().register(containerDefinition.getId(), icon);
            return icon;
        }
        return cachedImage;
    }

    public static void fireDisposedIFigureEvent(List<IFigure> figures) {
        EventBus eventBus = UtilsPlugin.getEventBus();
        ImmutableList children = FluentIterable.from(figures).transformAndConcat((Function)new GetAllFigureChildren()).toList();
        FigureDisposedEvent event = new FigureDisposedEvent((List)children);
        eventBus.fireEvent((IEvent)event);
    }

    public static Image getImageToExport(EntityEditPart<?> entityEditPart) {
        Figure theFigure = (Figure)entityEditPart.getFigure();
        Color originalBackgroundColor = theFigure.getBackgroundColor();
        Boolean originalIsOpaque = theFigure.isOpaque();
        theFigure.setOpaque(true);
        theFigure.setBackgroundColor(MessageFlowUtils.getBackgroundColorForExport());
        ThemeUtils.applyStylingTo((IFigure)theFigure);
        int xPosition = theFigure.getLocation().x;
        int yPosition = theFigure.getLocation().y;
        int width = theFigure.getBounds().width;
        int height = theFigure.getBounds().height;
        Image tmpImage = new Image((Device)Display.getCurrent(), xPosition + width, yPosition + height);
        Image resultImage = new Image((Device)Display.getCurrent(), width, height);
        GC gc = new GC((Drawable)tmpImage);
        GraphicalEditPart rootEditPart = (GraphicalEditPart)entityEditPart.getRoot();
        Viewport viewport = (Viewport)rootEditPart.getFigure();
        IFigure figure = viewport.getContents();
        SWTGraphics graphics = new SWTGraphics(gc);
        figure.paint((Graphics)graphics);
        gc.copyArea(resultImage, xPosition, yPosition);
        graphics.dispose();
        if (!gc.isDisposed()) {
            gc.dispose();
        }
        if (!tmpImage.isDisposed()) {
            tmpImage.dispose();
        }
        theFigure.setOpaque(originalIsOpaque.booleanValue());
        theFigure.setBackgroundColor(originalBackgroundColor);
        return resultImage;
    }

    private static Color getBackgroundColorForExport() {
        return ThemeUtils.getCurrentTheme().getBackgroundColor();
    }

    public static GraphicalViewer createViewer(IMuleProject muleProject, MuleConfigurationDecorator muleConfigurationDecorator) {
        ScrollingGraphicalViewerWithoutGrid viewer = new ScrollingGraphicalViewerWithoutGrid();
        viewer.createControl((Composite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        ScalableRootWithoutGridEditPart root = new ScalableRootWithoutGridEditPart();
        viewer.setRootEditPart((RootEditPart)root);
        viewer.getControl().setBackground(ColorConstants.white);
        viewer.setEditPartFactory(new MessageFlowEditPartFactory(muleProject));
        viewer.setContents(muleConfigurationDecorator);
        return viewer;
    }

    public static String getUnknownName(UnknownNode node) {
        String content = node.getContent();
        return (String)MessageFlowUtils.lookForPattern(DOC_NAME_REGEX, content).or(MessageFlowUtils.lookForPattern(NAME_PATTERN_REGEX, content)).or((Object)"Unknown");
    }

    private static com.google.common.base.Optional<String> lookForPattern(Pattern regexPattern, String content) {
        Matcher docNameMatcher = regexPattern.matcher(content);
        if (docNameMatcher.find()) {
            return com.google.common.base.Optional.fromNullable((Object)docNameMatcher.group(1));
        }
        return com.google.common.base.Optional.absent();
    }

    public static String getType(IMessageFlowEntity entity) {
        if (entity instanceof IMessageFlowNode) {
            return ((IMessageFlowNode)entity).getType();
        }
        if (entity instanceof MuleConfiguration) {
            return "http://www.mulesoft.org/schema/mule/core/mule";
        }
        return null;
    }

    public static NodeDefinition getDefinition(IMessageFlowEntity entity) {
        if (entity instanceof IMessageFlowNode) {
            return ((IMessageFlowNode)entity).getDefinition();
        }
        return MuleCorePlugin.getModuleManager().getDefinition("http://www.mulesoft.org/schema/mule/core/mule");
    }

    public static Optional<MultiPageMessageFlowEditor> getOrOpenMultiPageEditorFor(MuleConfiguration muleConfig, IMuleProject muleProject) {
        Optional<MultiPageMessageFlowEditor> multiPageEditorForFile = Optional.empty();
        Collection<MultiPageMessageFlowEditor> openMultipageMessageFlowEditors = MessageFlowUtils.getOpenMultipageMessageFlowEditors();
        for (MultiPageMessageFlowEditor editor : openMultipageMessageFlowEditors) {
            if (!editor.getMuleConfiguration().equals(muleConfig)) continue;
            multiPageEditorForFile = Optional.of(editor);
        }
        return Optional.ofNullable(multiPageEditorForFile.orElseGet(() -> {
            IFile targetConfigurationFile = muleProject.getConfigurationsCache().getConfigurationFile(muleConfig);
            try {
                IEditorPart openEditorForFile = UiUtils.openEditorForFile((IFile)targetConfigurationFile);
                if (openEditorForFile instanceof MultiPageMessageFlowEditor) {
                    return (MultiPageMessageFlowEditor)openEditorForFile;
                }
                return null;
            }
            catch (PartInitException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    public static Collection<MultiPageMessageFlowEditor> getOpenMultipageMessageFlowEditors() {
        return MessageFlowUtils.getOpenMultipageMessageFlowEditors(false);
    }

    public static Collection<MultiPageMessageFlowEditor> getOpenMultipageMessageFlowEditors(boolean restore) {
        IEditorReference[] editorReferences;
        ArrayList<MultiPageMessageFlowEditor> editorsCollection = new ArrayList<MultiPageMessageFlowEditor>();
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return editorsCollection;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return editorsCollection;
        }
        IEditorReference[] iEditorReferenceArray = editorReferences = activePage.getEditorReferences();
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference iEditorRef = iEditorReferenceArray[n2];
            IWorkbenchPart part = iEditorRef.getPart(restore);
            if (part instanceof MultiPageMessageFlowEditor) {
                MultiPageMessageFlowEditor editorPart = (MultiPageMessageFlowEditor)part;
                editorsCollection.add(editorPart);
            }
            ++n2;
        }
        return editorsCollection;
    }

    public static Collection<MessageFlowEditor> getOpenMessageFlowEditors() {
        Collection<MultiPageMessageFlowEditor> multipageEditors = MessageFlowUtils.getOpenMultipageMessageFlowEditors();
        ArrayList<MessageFlowEditor> editors = new ArrayList<MessageFlowEditor>();
        for (MultiPageMessageFlowEditor multiPageMessageFlowEditor : multipageEditors) {
            editors.add(multiPageMessageFlowEditor.getFlowEditor());
        }
        return editors;
    }

    public static IMessageFlowNode getParentMessageFlowNode(EntityEditPart<MessageFlowEntity> editPart) {
        EditPart parent = editPart.getParent();
        if (parent == null) {
            return null;
        }
        Object parentModel = parent.getModel();
        if (parentModel instanceof EntityDecorator) {
            IMessageFlowEntity entity = ((EntityDecorator)parentModel).getEntity();
            if (ModelUtils.isFlowOrSubflow((IMessageFlowEntity)entity)) {
                return (IMessageFlowNode)entity;
            }
            if (entity instanceof IMessageFlowNode && !(entity instanceof Compartment)) {
                return (IMessageFlowNode)entity;
            }
            return MessageFlowUtils.getParentMessageFlowNode((EntityEditPart)parent);
        }
        return null;
    }

    public static String mulePathToStudioPath(String path) {
        String studioPath = MulePath.fromPath((String)path).toPath();
        return studioPath;
    }

    public static boolean isSourcePath(MulePath path) {
        if (path == null) {
            return false;
        }
        return path.getLastNode().getMarker().equals("source");
    }

    public static MulePath findMulePathForEntity(IMuleProject muleProject, MuleConfiguration muleConfig, IMessageFlowEntity entityToFind) {
        return muleConfig.getPathFor(entityToFind, muleProject);
    }

    public static MessageFlowEntityRef findMulePathForEntityInOpenEditors(IMessageFlowEntity entityToFind) {
        Collection<MultiPageMessageFlowEditor> openFlowEditors = MessageFlowUtils.getOpenMultipageMessageFlowEditors();
        for (MultiPageMessageFlowEditor multiPageMessageFlowEditor : openFlowEditors) {
            MulePath pathFound;
            MessageFlowEditor flowEditor = multiPageMessageFlowEditor.getFlowEditor();
            if (flowEditor == null || (pathFound = MessageFlowUtils.findMulePathForEntity(flowEditor.getMuleProject(), (MuleConfiguration)flowEditor.getModelRoot().getEntity(), entityToFind)) == null) continue;
            return new MessageFlowEntityRef(flowEditor.getMuleConfiguration(), flowEditor.getMuleProject(), pathFound);
        }
        return null;
    }

    public static MessageFlowEntity findEntityForMulePathInOpenEditors(String path, String projectName) {
        MulePath fromPath = MulePath.fromPath((String)path);
        String flowName = fromPath.getFlowName();
        MuleConfiguration muleConfiguration = MessageFlowUtils.findMuleConfigurationWithElementInOpenEditors(flowName, projectName);
        if (muleConfiguration == null) {
            return null;
        }
        return muleConfiguration.getEntityFor(fromPath);
    }

    private static MuleConfiguration findMuleConfigurationWithElementInOpenEditors(String flowName, String projectName) {
        IEditorReference[] editorReferences;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        IEditorReference[] iEditorReferenceArray = editorReferences = activePage.getEditorReferences();
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            MultiPageMessageFlowEditor editorPart;
            IEditorReference editorRef = iEditorReferenceArray[n2];
            IWorkbenchPart part = editorRef.getPart(false);
            if (part != null && part instanceof MultiPageMessageFlowEditor && !((editorPart = (MultiPageMessageFlowEditor)part).getInputFile() instanceof InMemoryConfigurationFile ? !((InMemoryConfigurationFile)editorPart.getInputFile()).getProject().getName().equals(projectName) : projectName != null && !editorPart.getFilePath().split("/")[1].equals(projectName))) {
                MessageFlowEditor flowEditor = editorPart.getFlowEditor();
                MuleConfiguration muleConfig = (MuleConfiguration)flowEditor.getModelRoot().getEntity();
                List flows = muleConfig.getFlows();
                for (Container flow : flows) {
                    if (!flow.getName().equals(flowName)) continue;
                    return muleConfig;
                }
                for (IMessageFlowEntity value : muleConfig.getGlobalEntries()) {
                    MessageFlowNode node;
                    if (!(value instanceof MessageFlowNode) || !MessageFlowUtils.isExceptionStrategy((IMessageFlowEntity)(node = (MessageFlowNode)value)) || !flowName.equals(MessageFlowUtils.getPropertyValue(node.getProperties(), "name"))) continue;
                    return muleConfig;
                }
            }
            ++n2;
        }
        return null;
    }

    public static void fireCreatedEvent(IMessageFlowEntity entity) {
        EventBus eventBus = UtilsPlugin.getEventBus();
        CreatedElementOnCanvasEvent event = new CreatedElementOnCanvasEvent(MuleCorePlugin.getDesignContext().getMuleProject(), entity);
        eventBus.fireEvent((IEvent)event);
    }

    public static <PC extends IPropertyCollectionReadCapability<PC, P>, P extends IReadOnlyProperty> String getPropertyValue(IPropertyCollectionReadCapability<PC, P> propCol, String propertyName) {
        List propertyCollections;
        List properties = propCol.getProperties();
        if (properties != null) {
            for (IReadOnlyProperty p : properties) {
                if (!p.getName().equals(propertyName)) continue;
                return p.getValue();
            }
        }
        if ((propertyCollections = propCol.getPropertyCollections()) != null) {
            for (IPropertyCollectionReadCapability pc : propertyCollections) {
                String propertyValue = MessageFlowUtils.getPropertyValue(pc, propertyName);
                if (propertyValue == null) continue;
                return propertyValue;
            }
        }
        return null;
    }

    public static boolean isExceptionStrategy(IMessageFlowEntity entity) {
        if (entity instanceof IMessageFlowNode) {
            IMessageFlowNode node = (IMessageFlowNode)entity;
            return CoreUtils.isExceptionStrategy((IMessageFlowNode)node);
        }
        return false;
    }

    public static MessageFlowEditor getFlowEditorFromActivePage() {
        MultiPageMessageFlowEditor multiPageMessageFlowEditor = MessageFlowUtils.getMultiPageMessageFlowEditor();
        return multiPageMessageFlowEditor != null ? multiPageMessageFlowEditor.getFlowEditor() : null;
    }

    public static Rectangle getFlowEditorScrollOffset() {
        FigureCanvas control = (FigureCanvas)MessageFlowUtils.getFlowEditorFromActivePage().getViewer().getControl();
        return control.getViewport().getClientArea();
    }

    public static MuleConfiguration getMuleConfigFromActivePage() {
        MessageFlowEditor flowEditor = MessageFlowUtils.getFlowEditorFromActivePage();
        if (flowEditor == null) {
            return null;
        }
        MuleConfiguration muleConfig = (MuleConfiguration)flowEditor.getMuleConfigurationDecorator().getEntity();
        return muleConfig;
    }

    public static MultiPageMessageFlowEditor getMultiPageMessageFlowEditor() {
        com.google.common.base.Optional<IWorkbenchPage> activePage = MessageFlowUtils.getActiveWorkbenchPage();
        if (activePage.isPresent()) {
            IEditorPart activeEditor = ((IWorkbenchPage)activePage.get()).getActiveEditor();
            if (activeEditor == null) {
                return null;
            }
            if (!(activeEditor instanceof MultiPageMessageFlowEditor)) {
                return null;
            }
            return (MultiPageMessageFlowEditor)activeEditor;
        }
        return null;
    }

    public static com.google.common.base.Optional<IWorkbenchPage> getActiveWorkbenchPage() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return com.google.common.base.Optional.absent();
        }
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return com.google.common.base.Optional.absent();
        }
        return com.google.common.base.Optional.fromNullable((Object)activeWorkbenchWindow.getActivePage());
    }

    public static boolean hasChildren(IMessageFlowEntity messageFlowNode) {
        return messageFlowNode instanceof Compartment || messageFlowNode instanceof SplitterNode;
    }

    public static List<? extends IMessageFlowEntity> getChildren(IMessageFlowEntity messageFlowNode) {
        final ObjectHolder children = new ObjectHolder(new ArrayList());
        messageFlowNode.accept((MessageFlowEntityVisitor)new MessageFlowEntityVisitorAdapter(){

            public void visitGlobalElement(GlobalElement globalElement) {
            }

            public void visitContainer(Container container) {
                children.set((Object)container.getLanes());
            }

            public void visitNestedContainer(NestedContainer nestedContainer) {
                ArrayList<IMessageFlowEntity> innerElements = new ArrayList<IMessageFlowEntity>();
                this.addCompartmentLane((CompartmentLane)nestedContainer, innerElements);
                children.set(innerElements);
            }

            protected void addCompartmentLane(CompartmentLane compartmentLane, ArrayList<IMessageFlowEntity> innerElements) {
                List compartmentLaneEntries = compartmentLane.getCompartmentLaneEntries();
                for (IMessageFlowEntity compartmentLaneEntry : compartmentLaneEntries) {
                    innerElements.add(compartmentLaneEntry);
                }
            }

            public void visitCompartment(Compartment compartment) {
                List lanes = compartment.getLanes();
                ArrayList<IMessageFlowEntity> innerElements = new ArrayList<IMessageFlowEntity>();
                for (CompartmentLane compartmentLane : lanes) {
                    this.addCompartmentLane(compartmentLane, innerElements);
                }
                children.set(innerElements);
            }

            public void visitCompartmentLane(CompartmentLane lane) {
                ArrayList<IMessageFlowEntity> innerElements = new ArrayList<IMessageFlowEntity>();
                this.addCompartmentLane(lane, innerElements);
                children.set(innerElements);
            }

            public void visitSplitterNode(SplitterNode splitterNode) {
                splitterNode.getCompartment().accept((MessageFlowEntityVisitor)this);
            }
        });
        return (List)children.get();
    }

    public static MessageFlowNode generateNodeToTest(IMessageFlowNode node, ISimpleHost simpleHost) {
        MessageFlowNode nodeToTest = MessageFlowUtils.generateNodeToTest(node, node.getProperties());
        PropertyCollectionMap updated = new PropertyCollectionMap();
        Display.getDefault().syncExec(() -> {
            Composite[] compositeArray = simpleHost.getAllPages();
            int n = compositeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Composite current = compositeArray[n2];
                ((MessageFlowNodeComposite)current).saveTo((IMessageFlowNode)nodeToTest, updated);
                ++n2;
            }
        });
        PropertyCollection updatedProperty = updated.asPropertyCollection();
        nodeToTest.setProperties(updatedProperty);
        ComponentId.copyComponentId((IMessageFlowNode)node, (IMessageFlowNode)nodeToTest);
        return nodeToTest;
    }

    public static MessageFlowNode generateNodeToTest(IMessageFlowNode nodeWithOldProperties, IReadOnlyPropertyCollection newProperties) {
        EndpointNode nodeToTest;
        ICategory category = CoreUtils.getCategory((IMessageFlowNode)nodeWithOldProperties);
        NodeDefinition nodeDefinition = nodeWithOldProperties.getDefinition();
        if (category == Category.ENDPOINTS && nodeWithOldProperties instanceof EndpointNode) {
            EndpointNode endpoint = new EndpointNode((INodeNameProvider)new DefaultNodeNameProvider());
            endpoint.setDirection(((EndpointNode)nodeWithOldProperties).getDirection());
            nodeToTest = endpoint;
        } else {
            IDocumentWrapper documentWrapper = nodeWithOldProperties.getElement().getDocument();
            IFlowTransformerContext context = NewFlowTransformerContext.create((IMuleProject)MuleCorePlugin.getDesignContext().getMuleProject(), (IDocumentWrapper)documentWrapper);
            com.google.common.base.Optional direction = nodeWithOldProperties instanceof EndpointNode ? com.google.common.base.Optional.of((Object)((EndpointNode)nodeWithOldProperties).getDirection()) : com.google.common.base.Optional.absent();
            nodeToTest = (MessageFlowNode)MessageFlowFactory.create((NodeDefinition)nodeDefinition, (com.google.common.base.Optional)direction, (IFlowTransformerContext)context);
        }
        ComponentId.copyComponentId((IMessageFlowNode)nodeWithOldProperties, (IMessageFlowNode)nodeToTest);
        nodeToTest.setEntityId(nodeWithOldProperties.getEntityId());
        nodeToTest.setType(nodeDefinition.getId());
        nodeToTest.setDefinition(nodeDefinition);
        nodeToTest.setName(nodeWithOldProperties.getName());
        PropertiesUtils.copyPropertyCollection((IMessageFlowNode)nodeToTest, (IPropertyCollectionReadCapability)newProperties);
        return nodeToTest;
    }

    public static IMessageFlowNode getMessageFlowNodeWithUpdatedProperties(IMessageFlowNode messageFlowNode, List<MessageFlowNodeComposite> pages) {
        MessageFlowNode updatedMessageFlowNode = MessageFlowUtils.generateNodeToTest(messageFlowNode, messageFlowNode.getProperties());
        java.util.function.Function<IMessageFlowNode, PropertyCollectionMap> updatedPropertiesProvider = MessageFlowUtils.updatedPropertiesProvider(pages);
        updatedMessageFlowNode.setProperties(updatedPropertiesProvider.apply((IMessageFlowNode)updatedMessageFlowNode).asPropertyCollection());
        return updatedMessageFlowNode;
    }

    public static boolean checkNodeEquality(IMessageFlowNode leftNode, IMessageFlowNode rightNode) {
        return MessageFlowUtils.checkNodeEquality(leftNode, leftNode.getProperties(), rightNode, rightNode.getProperties());
    }

    public static boolean checkNodeEquality(IMessageFlowNode leftNode, IReadOnlyPropertyCollection leftProperties, IMessageFlowNode rightNode, IReadOnlyPropertyCollection rightProperties) {
        return leftNode != null && rightNode != null && (leftNode.equals(rightNode) || leftNode.getClass().equals(rightNode.getClass()) && PropertiesUtils.removeAllInternalAttribues((IReadOnlyPropertyCollection)leftProperties).equals((Object)PropertiesUtils.removeAllInternalAttribues((IReadOnlyPropertyCollection)rightProperties)) && leftNode.getType().equals(rightNode.getType()) && leftNode.getEntityId().equals(rightNode.getEntityId()) && leftNode.getName().equals(rightNode.getName()) && CoreUtils.getCategory((IMessageFlowNode)leftNode).equals(CoreUtils.getCategory((IMessageFlowNode)rightNode)));
    }

    public static String getName(IMessageFlowEntity entity) {
        if (entity instanceof IMessageFlowNode) {
            return ((IMessageFlowNode)entity).getName();
        }
        if (entity instanceof UnknownNode) {
            return MessageFlowUtils.getUnknownName((UnknownNode)entity);
        }
        return "";
    }

    public static Point getCursorPosition() {
        MessageFlowEditor flowEditor = MessageFlowUtils.getFlowEditorFromActivePage();
        if (flowEditor != null) {
            Display display = Display.getDefault();
            org.eclipse.swt.graphics.Point point = flowEditor.getViewer().getControl().toControl(display.getCursorLocation());
            FigureCanvas figureCanvas = (FigureCanvas)flowEditor.getViewer().getControl();
            Point location = figureCanvas.getViewport().getViewLocation();
            Point resultPoint = new Point(point.x + location.x, point.y + location.y);
            return resultPoint;
        }
        return null;
    }

    private static boolean isFlowNestedContainer(EditPart editPart, String nestedContainerType) {
        if (!(editPart instanceof NestedContainer)) {
            return false;
        }
        NestedContainer nested = (NestedContainer)editPart;
        boolean isFlowNested = nested.getType().equals(nestedContainerType);
        return isFlowNested;
    }

    public static boolean isFlowNested(EditPart editPart) {
        return MessageFlowUtils.isFlowInput(editPart) || MessageFlowUtils.isFlowProcess(editPart) || MessageFlowUtils.isFlowES(editPart);
    }

    public static boolean isFlowInput(EditPart editPart) {
        return MessageFlowUtils.isFlowNestedContainer(editPart, "http://www.mulesoft.org/schema/mule/core/inboundCompartmentLane");
    }

    public static boolean isFlowProcess(EditPart editPart) {
        return MessageFlowUtils.isFlowNestedContainer(editPart, "http://www.mulesoft.org/schema/mule/core/messageProcessorsLane");
    }

    public static boolean isFlowES(EditPart editPart) {
        return MessageFlowUtils.isFlowNestedContainer(editPart, "http://www.mulesoft.org/schema/mule/core/exceptionStrategyLane");
    }

    public static boolean isFlow(EditPart editPart) {
        return MessageFlowUtils.validateContainerEditPart(editPart, ModelUtils::isFlow);
    }

    public static boolean isSubFlow(EditPart editPart) {
        return MessageFlowUtils.validateContainerEditPart(editPart, ModelUtils::isSubflow);
    }

    public static boolean isErrorHandler(EditPart editPart) {
        return MessageFlowUtils.validateContainerEditPart(editPart, ModelUtils::isErrorHandler);
    }

    private static boolean validateContainerEditPart(EditPart editPart, Predicate<IMessageFlowEntity> validator) {
        if (editPart instanceof ContainerEditPart) {
            ContainerEditPart container = (ContainerEditPart)editPart;
            IMessageFlowEntity model = container.getEntityDecorator().getEntity();
            return validator.test(model);
        }
        return false;
    }

    public static boolean isFlowOrSubflowEditPart(EditPart editPart) {
        return MessageFlowUtils.isFlow(editPart) || MessageFlowUtils.isSubFlow(editPart);
    }

    public static boolean isFirstElementOnly(IMessageFlowEntity entity) {
        return ModelUtils.isIndboundEndpoint((IMessageFlowEntity)entity);
    }

    public static MessageFlowEntity adaptOutboundFromInboundEndpoint(MuleConfiguration muleConfiguration, EndpointNode endpointNode) {
        EndpointNode result = null;
        EndpointDefinition definition = (EndpointDefinition)endpointNode.getDefinition();
        IFlowTransformerContext context = NewFlowTransformerContext.create((IMuleProject)MuleCorePlugin.getDesignContext().getMuleProject(), (MuleConfiguration)muleConfiguration);
        if (definition.isCloudConnectorEndpoint()) {
            String messageProcessorAlternative = DefinitionsHelper.getMessageProcessorAlternative(endpointNode.getType());
            if (messageProcessorAlternative != null) {
                result = MessageFlowFactory.createPatternNode((IFlowTransformerContext)context, (NodeDefinition)MuleCorePlugin.getModuleManager().getDefinition(messageProcessorAlternative));
            } else {
                result = MessageFlowFactory.createEndpointNode((IFlowTransformerContext)context, (EndpointDefinition)definition, (EndpointDirection)EndpointDirection.INBOUND);
                result.setProperties(PropertiesUtils.toWritablePropertyCollection((IPropertyCollectionReadCapability)endpointNode.getProperties()), false);
                result.setName(endpointNode.getName());
            }
        } else {
            result = MessageFlowFactory.createEndpointNode((IFlowTransformerContext)context, (EndpointDefinition)definition, (EndpointDirection)EndpointDirection.OUTBOUND);
            result.setProperties(PropertiesUtils.toWritablePropertyCollection((IPropertyCollectionReadCapability)endpointNode.getProperties()), false);
            result.setName(endpointNode.getName());
        }
        return result;
    }

    public static boolean isConnector(MessageFlowNode messageFlowNode) {
        NodeDefinition nodeDefinition = messageFlowNode.getDefinition();
        return nodeDefinition != null && nodeDefinition.getCategoryId() != null && (nodeDefinition.getCategoryId().equals(Category.GLOBAL_CLOUD_CONNECTORS.getCategoryString()) || nodeDefinition.getCategoryId().equals(Category.JMS_CONNECTORS.getCategoryString()) || nodeDefinition.getCategoryId().equals(Category.DATA_SOURCES.getCategoryString()) || nodeDefinition.getCategoryId().equals(Category.GLOBAL_CONNECTORS.getCategoryString()));
    }

    public static boolean isContainer(IMessageFlowNode node) {
        return node instanceof Container;
    }

    public static boolean isInboundEndpoint(IMessageFlowNode node) {
        return node instanceof EndpointNode && EndpointDirection.INBOUND.equals((Object)((EndpointNode)node).getDirection());
    }

    public static boolean isFlowRefNode(IMessageFlowNode node) {
        return "http://www.mulesoft.org/schema/mule/core/flow-ref".equals(node.getType());
    }

    public static boolean isBatchAggregator(MessageFlowEntity entity) {
        if (entity instanceof IMessageFlowNode) {
            IMessageFlowNode node = (IMessageFlowNode)entity;
            return "http://www.mulesoft.org/schema/mule/batch/aggregator".equals(node.getType());
        }
        return false;
    }

    public static Supplier<IMessageFlowNode> generateNodeToTestSupplier(IMessageFlowNode messageFlowNode) {
        return () -> MessageFlowUtils.generateNodeToTest(messageFlowNode, messageFlowNode.getProperties());
    }

    public static java.util.function.Function<IMessageFlowNode, PropertyCollectionMap> updatedPropertiesProvider(List<MessageFlowNodeComposite> pages) {
        return currentElement -> {
            PropertyCollectionMap updated = new PropertyCollectionMap();
            Display.getDefault().syncExec(() -> {
                for (MessageFlowNodeComposite current : pages) {
                    updated.addProperty("BACKUP_STATE", Boolean.TRUE.toString());
                    current.saveTo((IMessageFlowNode)currentElement, updated);
                    updated.removeProperty("BACKUP_STATE");
                }
            });
            return updated;
        };
    }

    public static IElementWrapper createElement(IMessageFlowNode node, PropertyCollection collection) {
        return MessageFlowUtils.createElement(node, collection, -1);
    }

    public static IElementWrapper createElement(IDocumentWrapper document, NestedDefinition nestedDefinition) {
        return MessageFlowUtils.createElement(document, nestedDefinition, -1);
    }

    public static IElementWrapper createElement(IMessageFlowNode node, NodeDefinition nodeDefinition) {
        return MessageFlowUtils.createElement(node, nodeDefinition, -1);
    }

    public static IElementWrapper createElement(IMessageFlowNode node, PropertyCollection collection, int xmlOrder) {
        String nodeDefinitionId = PropertiesUtils.getNodeDefinitionId((String)collection.getName());
        NestedDefinition nodeDefinition = MuleCorePlugin.getModuleManager().getNestedDefinition(nodeDefinitionId);
        return MessageFlowUtils.createElement(node, (NodeDefinition)nodeDefinition, xmlOrder);
    }

    public static IElementWrapper createElement(IMessageFlowNode node, NodeDefinition nodeDefinition, int xmlOrder) {
        IDocumentWrapper document = node.getElement().getDocument();
        IQNameMeta qNameService = (IQNameMeta)nodeDefinition.getService(IQNameMeta.class);
        QName qName = qNameService.getQName((MessageFlowEntity)node);
        return MessageFlowUtils.createElement(document, qName, xmlOrder);
    }

    public static IElementWrapper createElement(IDocumentWrapper document, NestedDefinition nestedDefinition, int xmlOrder) {
        IQNameMeta qNameService = (IQNameMeta)nestedDefinition.getService(IQNameMeta.class);
        QName qName = qNameService.getQName(null);
        return MessageFlowUtils.createElement(document, qName, xmlOrder);
    }

    public static IElementWrapper createElement(IDocumentWrapper document, QName qName, int xmlOrder) {
        IElementWrapper newElement = document.createElement(qName);
        MessageFlowUtils.setElementXmlOrder(newElement, xmlOrder);
        return newElement;
    }

    public static void setElementXmlOrder(IElementWrapper element, int xmlOrder) {
        if (element instanceof IConfigurableElement) {
            ((IConfigurableElement)element).setXmlOrder(xmlOrder);
        }
    }

    public static Optional<IElementWrapper> generateSplitterLaneXml(IMuleProject project, EntityEditPart<?> compartmentPart, CompartmentLane lane) {
        EditPart parentOfParent = compartmentPart.getParent();
        if (parentOfParent instanceof SplitterEditPart) {
            IFlowTransformerContext context = NewFlowTransformerContext.create((IMuleProject)project, (MuleConfiguration)compartmentPart.getMuleConfiguration());
            SplitterEditPart splitterPart = (SplitterEditPart)parentOfParent;
            SplitterNode splitterNode = (SplitterNode)splitterPart.getEntity();
            context.getEntityStack().push(splitterNode);
            IElementWrapper laneXmlElement = lane instanceof Route ? MessageFlowFactory.generateRouteXml((IFlowTransformerContext)context, (Route)((Route)lane)) : MessageFlowFactory.generateLaneXml((IFlowTransformerContext)context, (CompartmentLane)lane);
            return Optional.of(laneXmlElement);
        }
        return Optional.empty();
    }

    public static void hideFlowComponentConnections(AbstractGraphicalEditPart abstractGraphicalEditPart) {
        List children = abstractGraphicalEditPart.getChildren();
        children.stream().filter(editPart -> editPart instanceof AbstractGraphicalEditPart).map(editPart -> editPart).forEach(editPart -> {
            boolean applied = MessageFlowUtils.hideConnection(editPart);
            if (applied) {
                MessageFlowUtils.hideFlowComponentConnections(editPart);
            }
        });
    }

    public static void showFlowComponentConnections(AbstractGraphicalEditPart abstractGraphicalEditPart) {
        List children = abstractGraphicalEditPart.getChildren();
        children.stream().filter(editPart -> editPart instanceof AbstractGraphicalEditPart).map(editPart -> editPart).forEach(editPart -> {
            boolean applied = MessageFlowUtils.showConnection(editPart);
            if (applied) {
                MessageFlowUtils.showFlowComponentConnections(editPart);
            }
        });
    }

    private static boolean showConnection(AbstractGraphicalEditPart editPart) {
        if (editPart instanceof EntityEditPart) {
            EntityEditPart entity = (EntityEditPart)editPart;
            entity.showConnections();
            if (entity instanceof ICollapsibleEditPart && ((ICollapsibleEditPart)((Object)entity)).isCollapsed()) {
                return false;
            }
        }
        return true;
    }

    private static boolean hideConnection(AbstractGraphicalEditPart editPart) {
        if (editPart instanceof EntityEditPart) {
            EntityEditPart entity = (EntityEditPart)editPart;
            entity.hideConnections();
            if (entity instanceof ICollapsibleEditPart && ((ICollapsibleEditPart)((Object)entity)).isCollapsed()) {
                return false;
            }
        }
        return true;
    }

    public static void firePreToggleCommentEvent(MessageFlowEntity messageFlowEntity) {
        MessageFlowEditor messageFlowEditor = MessageFlowUtils.getFlowEditorFromActivePage();
        IFile configFile = MessageFlowUtils.getFlowEditorFromActivePage().getInputXmlConfigFile();
        MuleConfiguration muleConfig = MessageFlowUtils.getMuleConfigFromActivePage();
        if (ModelUtils.isComment((IMessageFlowEntity)messageFlowEntity)) {
            Object nextEditPart;
            EntityEditPart<?> editPart = messageFlowEditor.findEditPart((IMessageFlowEntity)messageFlowEntity);
            List siblings = editPart.getParent().getChildren();
            if (siblings.indexOf(editPart) != siblings.size() - 1 && (nextEditPart = siblings.get(siblings.indexOf(editPart) + 1)) != null && nextEditPart instanceof EntityEditPart) {
                ToggleCommentElementOnCanvasEvent toggleCommentElementOnCanvasEvent = new ToggleCommentElementOnCanvasEvent(false, MuleCorePlugin.getDesignContext().getMuleProject(), (IMessageFlowEntity)((EntityEditPart)nextEditPart).getEntity(), configFile, muleConfig);
                UtilsPlugin.getEventBus().fireEvent((IEvent)toggleCommentElementOnCanvasEvent);
            }
        } else {
            ToggleCommentElementOnCanvasEvent toggleCommentElementOnCanvasEvent = new ToggleCommentElementOnCanvasEvent(true, MuleCorePlugin.getDesignContext().getMuleProject(), (IMessageFlowEntity)messageFlowEntity, configFile, muleConfig);
            UtilsPlugin.getEventBus().fireEvent((IEvent)toggleCommentElementOnCanvasEvent);
        }
    }
}

