/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.util;

import java.io.StringReader;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

public class HTMLUtils {
    private HTMLUtils() {
    }

    public static String removeHtmlTags(String text) {
        StringReader reader = new StringReader(text);
        final StringBuilder textResult = new StringBuilder();
        ParserDelegator parserDelegator = new ParserDelegator();
        HTMLEditorKit.ParserCallback parserCallback = new HTMLEditorKit.ParserCallback(){

            @Override
            public void handleText(char[] data, int pos) {
                textResult.append(data);
            }

            @Override
            public void handleStartTag(HTML.Tag tag, MutableAttributeSet attribute, int pos) {
                this.addNewLineOnBreakOrParagraph(textResult, tag);
            }

            @Override
            public void handleEndTag(HTML.Tag t, int pos) {
            }

            @Override
            public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet a, int pos) {
                this.addNewLineOnBreakOrParagraph(textResult, tag);
            }

            @Override
            public void handleComment(char[] data, int pos) {
            }

            @Override
            public void handleError(String errMsg, int pos) {
            }

            private void addNewLineOnBreakOrParagraph(StringBuilder textResult2, HTML.Tag tag) {
                if (HTML.Tag.BR.equals(tag) || HTML.Tag.P.equals(tag)) {
                    textResult2.append("\n");
                }
            }
        };
        try {
            parserDelegator.parse(reader, parserCallback, true);
            return textResult.toString();
        }
        catch (Exception exception) {
            return text;
        }
    }
}

