/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.util;

import java.util.HashMap;
import org.mule.tooling.messageflow.handler.IGoToImplementationHandler;
import org.mule.tooling.messageflow.util.GoToImplementationContribution;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.utils.extensionpoint.IExtensionPointReader;

public enum GoToImplementationHandlerManager {
    INSTANCE;

    private HashMap<String, GoToImplementationContribution> idContributionMap;

    private GoToImplementationHandlerManager() {
        this.init();
    }

    private void init() {
        this.idContributionMap = new HashMap();
        IExtensionPointReader extensionPointReader = IExtensionPointReader.create(GoToImplementationContribution.class);
        for (GoToImplementationContribution contribution : extensionPointReader.readAll()) {
            this.idContributionMap.put(contribution.getElementType(), contribution);
        }
    }

    public boolean hasHandler(String elementType) {
        return this.idContributionMap.containsKey(elementType);
    }

    public Object execute(MessageFlowNode messageFlowNode) {
        String elementType = messageFlowNode.getType();
        if (!this.hasHandler(elementType)) {
            throw new RuntimeException("There is no \"go to implementation\" handler for the selected component");
        }
        IGoToImplementationHandler handler = this.getHandler(elementType);
        handler.execute(messageFlowNode);
        return null;
    }

    public IGoToImplementationHandler getHandler(String elementType) {
        GoToImplementationContribution goToImplementationContribution = this.idContributionMap.get(elementType);
        IGoToImplementationHandler handler = goToImplementationContribution.getHandler();
        return handler;
    }

    public String getActionName(String type) {
        GoToImplementationContribution goToImplementationContribution = this.idContributionMap.get(type);
        if (goToImplementationContribution == null) {
            throw new RuntimeException("There is no \"go to implementation\" contribution for the given type.");
        }
        return goToImplementationContribution.getActionName();
    }
}

