/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.util;

import java.util.ArrayList;
import java.util.List;
import org.mule.tooling.messageflow.dialog.GlobalElementDialog;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;

public class GlobalElementUtils {
    public static boolean areAnyChanges(IReadOnlyPropertyCollection previous, PropertyCollection updated, GlobalElementDialog dialog) {
        PropertyCollection mergedProperties = PropertiesUtils.mergeProperties((IReadOnlyPropertyCollection)previous, (PropertyCollection)dialog.getPropertiesBeforeSave().asPropertyCollection());
        if (updated.getProperties().size() != mergedProperties.getProperties().size() || updated.getPropertyCollections().size() != mergedProperties.getPropertyCollections().size()) {
            return true;
        }
        for (Property property : updated.getProperties()) {
            IReadOnlyProperty propertyFound = GlobalElementUtils.findProperty(mergedProperties.getProperties(), property.getName());
            if (propertyFound == null) {
                return true;
            }
            if (propertyFound.equals(property)) continue;
            return true;
        }
        for (PropertyCollection propertyCollection : updated.getPropertyCollections()) {
            PropertyCollection propertyCollectionFound = PropertiesUtils.findPropertyCollection((List)mergedProperties.getPropertyCollections(), (String)propertyCollection.getName());
            if (propertyCollectionFound == null) {
                return true;
            }
            if (propertyCollectionFound.equals((Object)propertyCollection)) continue;
            return true;
        }
        List<PropertyCollection> previousPropertyCollections = GlobalElementUtils.getPreviousPropertyCollections(previous);
        List<PropertyCollection> updatedPropertyCollections = GlobalElementUtils.getUpdatesPropertyCollections(updated);
        if (previousPropertyCollections.size() != updatedPropertyCollections.size()) {
            return true;
        }
        for (PropertyCollection updatedPropertyCollection : updatedPropertyCollections) {
            if (GlobalElementUtils.propertyCollectionExisting(updatedPropertyCollection.getProperties(), previousPropertyCollections)) continue;
            return true;
        }
        return false;
    }

    public static IReadOnlyProperty findProperty(List<? extends IReadOnlyProperty> properties, String propertyName) {
        for (IReadOnlyProperty iReadOnlyProperty : properties) {
            if (!iReadOnlyProperty.getName().equals(propertyName)) continue;
            return iReadOnlyProperty;
        }
        return null;
    }

    private static List<PropertyCollection> getPreviousPropertyCollections(IReadOnlyPropertyCollection previous) {
        ArrayList<PropertyCollection> previousPropertyCollections = new ArrayList<PropertyCollection>();
        PropertyCollection properties = new PropertyCollection();
        GlobalElementUtils.previousPreorderTraversal(previous, properties);
        if (properties.getPropertyCollections() != null && properties.getPropertyCollections().size() > 0) {
            for (PropertyCollection propertyCollection : properties.getPropertyCollections()) {
                previousPropertyCollections.addAll(propertyCollection.getPropertyCollections());
            }
        }
        return previousPropertyCollections;
    }

    private static void previousPreorderTraversal(IReadOnlyPropertyCollection previous, PropertyCollection properties) {
        List propertyCollections = previous.getPropertyCollections();
        propertyCollections.forEach(propertyCollection2 -> {
            properties.addPropertyCollection(propertyCollection2.toPropertyCollectionMap().asPropertyCollection());
            GlobalElementUtils.previousPreorderTraversal(propertyCollection2, properties);
        });
    }

    private static List<PropertyCollection> getUpdatesPropertyCollections(PropertyCollection updated) {
        ArrayList<PropertyCollection> updatedWithoutErase = new ArrayList<PropertyCollection>();
        if (updated.getPropertyCollections() != null && updated.getPropertyCollections().size() > 0) {
            ArrayList<PropertyCollection> updatedPropertyCollections = new ArrayList<PropertyCollection>();
            GlobalElementUtils.updatedPreorderTraversal(updated, updatedPropertyCollections);
            for (PropertyCollection updatedPropertyCollection : updatedPropertyCollections) {
                if (updatedPropertyCollection.isErased()) continue;
                updatedWithoutErase.add(updatedPropertyCollection);
            }
        }
        return updatedWithoutErase;
    }

    private static void updatedPreorderTraversal(PropertyCollection updated, List<PropertyCollection> updatedPropertyCollections) {
        for (PropertyCollection propertyCollection : updated.getPropertyCollections()) {
            updatedPropertyCollections.addAll(propertyCollection.getPropertyCollections());
            GlobalElementUtils.updatedPreorderTraversal(propertyCollection, updatedPropertyCollections);
        }
    }

    private static boolean propertyCollectionExisting(List<Property> properties, List<PropertyCollection> previousPropertyCollections) {
        for (PropertyCollection previousPropertyCollection : previousPropertyCollections) {
            if (!properties.equals(previousPropertyCollection.getProperties())) continue;
            return true;
        }
        return false;
    }
}

