/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.regex.Matcher;
import org.mule.tooling.model.messageflow.path.MulePath;

class ExpressionPathParser {
    private String pathExpression;
    private String name;
    private String type;
    private String index;
    private String location;

    public ExpressionPathParser(String pathExpression) {
        this.pathExpression = pathExpression;
    }

    public ExpressionPathParser forName(String name) {
        this.name = name;
        return this;
    }

    public ExpressionPathParser ofType(String type) {
        this.type = type;
        return this;
    }

    public ExpressionPathParser onIndex(String index) {
        this.index = index;
        return this;
    }

    public ExpressionPathParser atLocation(int location) {
        this.location = String.valueOf(location);
        return this;
    }

    public MulePath parseUsing(MulePath parentPath) {
        String[] nodes = this.parsePathExpression();
        MulePath containerPath = null;
        containerPath = parentPath == null ? new MulePath(this.name) : parentPath.createChild(nodes[0]);
        int i = 1;
        while (i < nodes.length) {
            containerPath = containerPath.createChild(nodes[i]);
            ++i;
        }
        return containerPath;
    }

    private String simplify(String type) {
        int lastIndexOf = type.lastIndexOf("/");
        return type.substring(lastIndexOf + 1);
    }

    private String[] parsePathExpression() {
        String[] split = this.pathExpression.split("/");
        ArrayList nodes = Lists.newArrayList();
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            nodes.add(this.replacePathVariables(s));
            ++n2;
        }
        return nodes.toArray(new String[nodes.size()]);
    }

    private String replacePathVariables(String str) {
        String replacedStr = str;
        if (this.name != null) {
            replacedStr = replacedStr.replaceAll("\\$\\{name\\}", Matcher.quoteReplacement(this.name));
        }
        if (this.index != null) {
            replacedStr = replacedStr.replaceAll("\\$\\{index\\}", Matcher.quoteReplacement(this.index));
        }
        if (this.type != null) {
            replacedStr = replacedStr.replaceAll("\\$\\{type\\}", this.simplify(Matcher.quoteReplacement(this.type)));
        }
        if (this.location != null) {
            replacedStr = replacedStr.replaceAll("\\$\\{childIndex\\}", this.simplify(Matcher.quoteReplacement(this.location)));
        }
        return replacedStr;
    }
}

