/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.util;

import java.util.Stack;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.eclipse.jface.preference.IPreferenceStore;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.builder.messageflow.IQNameMeta;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.dom.INodeWrapper;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.generator.NewFlowTransformerContext;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.model.messageflow.CommentContainer;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.EndpointDirection;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.GlobalUnknown;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.Route;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.UnknownNode;
import org.mule.tooling.model.messageflow.decorator.CompartmentDecorator;
import org.mule.tooling.model.messageflow.decorator.CompartmentLaneDecorator;
import org.mule.tooling.model.messageflow.decorator.ContainerOfMovableEntities;
import org.mule.tooling.model.messageflow.decorator.NestedContainerDecorator;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.model.module.EndpointDefinition;
import org.mule.tooling.model.module.GraphicalContainerDefinition;
import org.mule.tooling.model.module.NestedContainerDefinition;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.RouteDefinition;
import org.mule.tooling.ui.MuleUIPlugin;

public class CloneEntityVisitor
implements MessageFlowEntityVisitor {
    private static final String DOC_NAMESPACE = "doc:";
    private IMuleProject muleProject;
    private MessageFlowEntity clonedEntity;
    private MuleConfiguration muleConfiguration;
    private Stack<ContainerOfMovableEntities> models = new Stack();
    private Stack<SplitterNode> splitters = new Stack();
    private Stack<Compartment> compartments = new Stack();
    private Stack<IElementWrapper> graphicalContainerParents = new Stack();
    private Stack<IElementWrapper> previousNestedContainerElements = new Stack();
    private final boolean generateSuffixToProcessors;

    public CloneEntityVisitor(ContainerOfMovableEntities model, MuleConfiguration muleConfiguration, IMuleProject muleProject) {
        this.muleConfiguration = muleConfiguration;
        this.muleProject = muleProject;
        this.models.push(model);
        IPreferenceStore preferenceStore = MuleUIPlugin.getDefault().getPreferenceStore();
        this.generateSuffixToProcessors = preferenceStore.getBoolean("add_suffix_to_cloned_entities");
    }

    public void visitGlobalUnknown(GlobalUnknown globalUnknown) {
    }

    public void visitMuleConfiguration(MuleConfiguration muleConfiguration) {
    }

    public void visitEndpointNode(EndpointNode endpointNode) {
        IFlowTransformerContext context = this.createContext();
        EndpointNode newEndpoint = MessageFlowFactory.createEndpointNode((IFlowTransformerContext)context, (EndpointDefinition)((EndpointDefinition)endpointNode.getDefinition()), (EndpointDirection)endpointNode.getDirection());
        newEndpoint.setEndpointTemplate(endpointNode.getEndpointTemplate());
        newEndpoint.setEndpointUri(endpointNode.getEndpointUri());
        newEndpoint.setMessageExchangePattern(endpointNode.getMessageExchangePattern());
        this.copyCommonAttributesFrom((IMessageFlowNode)endpointNode, (MessageFlowNode)newEndpoint);
        this.setClonedEntity((MessageFlowEntity)newEndpoint);
    }

    public void visitGlobalElement(GlobalElement globalElement) {
    }

    public void visitPatternNode(PatternNode patternNode) {
        IFlowTransformerContext context = this.createContext();
        PatternNode newPattern = MessageFlowFactory.createPatternNode((IFlowTransformerContext)context, (NodeDefinition)patternNode.getDefinition());
        this.copyCommonAttributesFrom((IMessageFlowNode)patternNode, (MessageFlowNode)newPattern);
        this.setClonedEntity((MessageFlowEntity)newPattern);
    }

    protected NodeDefinition getDefinition(String type) {
        return MuleCorePlugin.getModuleManager().getDefinition(type);
    }

    public void visitSplitterNode(SplitterNode splitterNode) {
        IFlowTransformerContext context = this.createContext();
        SplitterNode newSplitterNode = MessageFlowFactory.createSplitterNode((IFlowTransformerContext)context, (NodeDefinition)splitterNode.getDefinition());
        PatternNode pattern = splitterNode.getPattern();
        pattern.accept((MessageFlowEntityVisitor)this);
        newSplitterNode.setIndex(splitterNode.getIndex());
        newSplitterNode.setPattern((PatternNode)this.retrieveClonedEntity());
        this.copyCommonAttributesFrom((IMessageFlowNode)splitterNode, (MessageFlowNode)newSplitterNode);
        Compartment compartment = splitterNode.getCompartment();
        this.splitters.push(newSplitterNode);
        this.compartments.push(newSplitterNode.getCompartment());
        compartment.accept((MessageFlowEntityVisitor)this);
        this.splitters.pop();
        this.compartments.pop();
        newSplitterNode.setCompartment((Compartment)this.retrieveClonedEntity());
        this.setClonedEntity((MessageFlowEntity)newSplitterNode);
    }

    public void visitUnknownNode(UnknownNode unknownNode) {
        UnknownNode newElement = MessageFlowFactory.createUnknownNode((IElementWrapper)unknownNode.getElement().createCopy());
        newElement.setEntityId(UUID.randomUUID().toString());
        newElement.setDescription(unknownNode.getDescription());
        newElement.setContent(unknownNode.getContent());
        this.setClonedEntity((MessageFlowEntity)newElement);
    }

    public void visitCommentNode(CommentContainer commentNode) {
    }

    public MessageFlowEntity retrieveClonedEntity() {
        MessageFlowEntity result = this.clonedEntity;
        this.clonedEntity = null;
        return result;
    }

    public void setClonedEntity(MessageFlowEntity clonedEntity) {
        this.clonedEntity = clonedEntity;
    }

    public void visitCompartment(Compartment compartment) {
        CompartmentDecorator compartmentDecorator = new CompartmentDecorator(this.compartments.peek(), true);
        for (CompartmentLane compartmentLaneToClone : compartment.getLanes()) {
            compartmentLaneToClone.accept((MessageFlowEntityVisitor)this);
            CompartmentLane compartmentLane = (CompartmentLane)this.retrieveClonedEntity();
            compartmentDecorator.addLane(compartmentLane);
        }
        this.setClonedEntity((MessageFlowEntity)this.compartments.peek());
    }

    public void visitCompartmentLane(CompartmentLane compartmentLane) {
        IFlowTransformerContext context = this.createContext();
        context.getEntityStack().push((MessageFlowEntity)this.splitters.peek());
        CompartmentLane newCompartmentLane = MessageFlowFactory.createCompartmentLane((IFlowTransformerContext)context);
        newCompartmentLane.setIndex(compartmentLane.getIndex());
        newCompartmentLane.setHadOnlyOneElement(compartmentLane.getHadOnlyOneElement());
        newCompartmentLane.setEntityId(compartmentLane.getEntityId());
        CompartmentLaneDecorator compartmentLaneDecorator = (CompartmentLaneDecorator)MessageFlowFactory.getWrappedEntity((IMessageFlowEntity)newCompartmentLane);
        this.models.push((ContainerOfMovableEntities)compartmentLaneDecorator);
        for (IMessageFlowEntity value : compartmentLane.getCompartmentLaneEntries()) {
            value.accept((MessageFlowEntityVisitor)this);
            MessageFlowEntity createdElement = this.retrieveClonedEntity();
            compartmentLaneDecorator.addEntity((IMessageFlowEntity)createdElement);
        }
        this.models.pop();
        this.setClonedEntity((MessageFlowEntity)newCompartmentLane);
    }

    private void copyCommonAttributesFrom(IMessageFlowNode element, MessageFlowNode newElement) {
        newElement.setType(element.getType());
        newElement.setDefinition(element.getDefinition());
        newElement.setEntityId(UUID.randomUUID().toString());
        newElement.setDescription(element.getDescription());
        newElement.setProperties(this.clone(newElement, element.getProperties()));
        String name = element.getName();
        if (this.muleConfiguration != null && ModelUtils.isFlowOrSubflow((IMessageFlowEntity)element) || this.generateSuffixToProcessors) {
            name = this.models.peek().getAvailableName(name);
        }
        newElement.setName(name);
    }

    public void visitContainer(Container topLevelContainer) {
        ContainerDefinition definition = (ContainerDefinition)topLevelContainer.getDefinition();
        IFlowTransformerContext context = this.createContext();
        Container newContainer = MessageFlowFactory.createContainer((IFlowTransformerContext)context, (MuleConfiguration)this.muleConfiguration, (ContainerDefinition)definition);
        this.copyCommonAttributesFrom((IMessageFlowNode)topLevelContainer, (MessageFlowNode)newContainer);
        newContainer.getLanes().clear();
        for (CompartmentLane compartmentLaneToClone : topLevelContainer.getLanes()) {
            this.graphicalContainerParents.push(newContainer.getElement());
            compartmentLaneToClone.accept((MessageFlowEntityVisitor)this);
            NestedContainer nestedContainer = (NestedContainer)this.retrieveClonedEntity();
            NestedContainerDefinition nestedContainerDefinition = (NestedContainerDefinition)MuleCorePlugin.getModuleManager().getDefinition(nestedContainer.getType());
            if (!(nestedContainerDefinition instanceof GraphicalContainerDefinition)) {
                newContainer.getElement().add((INodeWrapper)nestedContainer.getElement());
            }
            newContainer.addNestedContainer(nestedContainer);
            this.previousNestedContainerElements.push(nestedContainer.getElement());
        }
        this.graphicalContainerParents.pop();
        this.previousNestedContainerElements.pop();
        this.setClonedEntity((MessageFlowEntity)newContainer);
    }

    public void visitNestedContainer(NestedContainer nestedContainerCompartmentLane) {
        NestedContainerDefinition definition = (NestedContainerDefinition)MuleCorePlugin.getModuleManager().getDefinition(nestedContainerCompartmentLane.getType());
        IFlowTransformerContext context = this.createContext();
        NestedContainer nestedContainer = null;
        if (definition instanceof GraphicalContainerDefinition) {
            nestedContainer = MessageFlowFactory.createGraphicalContainer((IFlowTransformerContext)context, (IElementWrapper)this.graphicalContainerParents.peek(), (NestedContainerDefinition)definition);
            MessageFlowFactory.configureNestedContainerElement((IElementWrapper)nestedContainer.getElement(), !this.previousNestedContainerElements.isEmpty() ? this.previousNestedContainerElements.peek() : null, (NestedContainerDefinition)definition);
        } else {
            nestedContainer = MessageFlowFactory.createDeferredNestedContainer((IFlowTransformerContext)context, (NestedContainerDefinition)definition);
            MessageFlowFactory.configureNestedContainerElement((IElementWrapper)nestedContainer.getElement(), !this.previousNestedContainerElements.isEmpty() ? this.previousNestedContainerElements.peek() : null, (NestedContainerDefinition)definition);
        }
        nestedContainer.setIndex(nestedContainerCompartmentLane.getIndex());
        nestedContainer.setName(nestedContainerCompartmentLane.getName());
        nestedContainer.setProperties(new PropertyCollectionMap(nestedContainerCompartmentLane.getProperties()).asPropertyCollection());
        nestedContainer.setEntityId(UUID.randomUUID().toString());
        NestedContainerDecorator nestedContainerDecorator = (NestedContainerDecorator)MessageFlowFactory.getWrappedEntity((IMessageFlowEntity)nestedContainer);
        this.models.push((ContainerOfMovableEntities)nestedContainerDecorator);
        for (IMessageFlowEntity value : nestedContainerCompartmentLane.getCompartmentLaneEntries()) {
            value.accept((MessageFlowEntityVisitor)this);
            MessageFlowEntity createdElement = this.retrieveClonedEntity();
            nestedContainerDecorator.addEntity((IMessageFlowEntity)createdElement);
        }
        this.models.pop();
        this.setClonedEntity((MessageFlowEntity)nestedContainer);
    }

    public void visitRoute(Route route) {
        IFlowTransformerContext context = this.createContext();
        context.getEntityStack().push((MessageFlowEntity)this.splitters.peek());
        Route newRoute = MessageFlowFactory.createRoute((IFlowTransformerContext)context, (RouteDefinition)route.getDefinition());
        newRoute.setIndex(route.getIndex());
        newRoute.setHadOnlyOneElement(route.getHadOnlyOneElement());
        newRoute.setProperties(new PropertyCollectionMap(route.getProperties()).asPropertyCollection());
        newRoute.setEntityId(UUID.randomUUID().toString());
        CompartmentLaneDecorator compartmentLaneDecorator = (CompartmentLaneDecorator)MessageFlowFactory.getWrappedEntity((IMessageFlowEntity)newRoute);
        this.models.push((ContainerOfMovableEntities)compartmentLaneDecorator);
        for (IMessageFlowEntity value : route.getCompartmentLaneEntries()) {
            value.accept((MessageFlowEntityVisitor)this);
            MessageFlowEntity createdElement = this.retrieveClonedEntity();
            compartmentLaneDecorator.addEntity((IMessageFlowEntity)createdElement);
        }
        this.models.pop();
        this.setClonedEntity((MessageFlowEntity)newRoute);
    }

    private IFlowTransformerContext createContext() {
        return NewFlowTransformerContext.create((IMuleProject)this.muleProject, (MuleConfiguration)this.muleConfiguration);
    }

    private PropertyCollection clone(MessageFlowNode node, IReadOnlyPropertyCollection properties) {
        if (properties == null) {
            return null;
        }
        PropertyCollection clonedCollection = new PropertyCollection();
        clonedCollection.setName(properties.getName());
        clonedCollection.setErased(properties.isErased());
        properties.getProperties().stream().filter(property -> !property.getName().startsWith(DOC_NAMESPACE)).forEach(property -> {
            Property newProperty = new Property();
            newProperty.setName(property.getName());
            newProperty.setValue(property.getValue());
            clonedCollection.getProperties().add(newProperty);
        });
        if (properties.getPropertyCollections() != null) {
            for (IReadOnlyPropertyCollection propertyCollectionToClone : properties.getPropertyCollections()) {
                PropertyCollection clonedPropertyCollection = this.clone(node, propertyCollectionToClone);
                String nodeDefinitionId = PropertiesUtils.getNodeDefinitionId((String)clonedPropertyCollection.getName());
                NestedDefinition nestedDefinition = MuleCorePlugin.getModuleManager().getNestedDefinition(nodeDefinitionId);
                if (nestedDefinition != null) {
                    IElementWrapper element = this.createElement((IMessageFlowNode)node, (NodeDefinition)nestedDefinition);
                    clonedPropertyCollection.setElement(element);
                }
                clonedCollection.getPropertyCollections().add(clonedPropertyCollection);
            }
        }
        return clonedCollection;
    }

    private IElementWrapper createElement(IMessageFlowNode node, NodeDefinition nestedDefinition) {
        IQNameMeta service = (IQNameMeta)nestedDefinition.getService(IQNameMeta.class);
        QName qName = service.getQName((MessageFlowEntity)node);
        return node.getElement().getDocument().createElement(qName);
    }
}

