/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.referenced;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.outline.AbstractOutlinePopupDialog;
import org.mule.tooling.messageflow.referenced.FlowReferencedByMuleTreeBuilderVisitor;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.util.IMessageProcessorNode;
import org.mule.tooling.model.messageflow.util.RootAwareEntityVisitor;
import org.mule.tooling.model.messageflow.util.TreeMuleConfiguration;
import org.mule.tooling.model.messageflow.util.TreeMuleConfigurationGenerator;

public class FlowReferencedByPopupDialog
extends AbstractOutlinePopupDialog {
    private String nodeName;

    public FlowReferencedByPopupDialog(String nodeName, Shell parent) {
        super(parent, 16, true, true, false, true, true, null, null);
        this.nodeName = nodeName;
    }

    @Override
    protected Optional<MessageFlowEditor> getAndOpenFlowEditorForElement(IMessageProcessorNode<?> element) {
        Optional<MultiPageMessageFlowEditor> optionalMultiPageEditor = MessageFlowUtils.getOrOpenMultiPageEditorFor((MuleConfiguration)element.getRoot().getValue(), MuleCorePlugin.getDesignContext().getMuleProject());
        optionalMultiPageEditor.ifPresent(multiPageEditor -> {
            try {
                multiPageEditor.openEditor();
            }
            catch (PartInitException e) {
                throw new RuntimeException("Couldn't open the multi page message flow editor", e);
            }
        });
        return optionalMultiPageEditor.map(multiPageEditor -> multiPageEditor.getFlowEditor());
    }

    @Override
    protected Object getTreeViewerInput() {
        TreeMuleConfigurationGenerator treeGenerator = new TreeMuleConfigurationGenerator();
        ArrayList<TreeMuleConfiguration> treeViewerInput = new ArrayList<TreeMuleConfiguration>();
        List configs = MuleCorePlugin.getDesignContext().getMuleProject().getConfigurationsCache().getConfigurations();
        for (MuleConfiguration config : configs) {
            TreeMuleConfiguration muleConfigTree = treeGenerator.generateTreeConfiguration(config, (RootAwareEntityVisitor)new FlowReferencedByMuleTreeBuilderVisitor(this.nodeName));
            if (muleConfigTree.getRoot().getChildren().isEmpty()) continue;
            treeViewerInput.add(muleConfigTree);
        }
        return treeViewerInput;
    }
}

