/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.referenced;

import java.util.Optional;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.CommentContainer;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.GlobalUnknown;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.UnknownNode;
import org.mule.tooling.model.messageflow.util.AbstractMessageFlowEntityVisitor;
import org.mule.tooling.model.messageflow.util.IMessageProcessorNode;
import org.mule.tooling.model.messageflow.util.MessageProcessorNode;
import org.mule.tooling.model.messageflow.util.RootAwareEntityVisitor;

public class FlowReferencedByMuleTreeBuilderVisitor
extends AbstractMessageFlowEntityVisitor
implements RootAwareEntityVisitor {
    private IMessageProcessorNode<MuleConfiguration> root;
    private IMessageProcessorNode<? extends MessageFlowEntity> current;
    private String nodeName;

    public FlowReferencedByMuleTreeBuilderVisitor(String nodeName) {
        this.nodeName = nodeName;
    }

    public void visitEndpointNode(EndpointNode endpointNode) {
    }

    public void visitPatternNode(PatternNode patternNode) {
        Optional.ofNullable((IReadOnlyProperty)patternNode.getProperties().getProperty("name")).ifPresent(property -> {
            if (ModelUtils.isFlowRef((IMessageFlowNode)patternNode) && this.nodeName.equals(property.getValue())) {
                this.current.addChild((IMessageProcessorNode)new MessageProcessorNode((MessageFlowEntity)patternNode));
            }
        });
    }

    public void visitGlobalUnknown(GlobalUnknown globalUnknown) {
    }

    public void visitUnknownNode(UnknownNode unknownNode) {
    }

    public void visitCommentNode(CommentContainer commentNode) {
    }

    public boolean preCompartment(Compartment compartment) {
        return true;
    }

    public boolean postCompartment(Compartment compartment) {
        return true;
    }

    public boolean postMuleConfiguration(MuleConfiguration muleConfiguration) {
        return true;
    }

    public boolean preCompartmentLane(CompartmentLane lane) {
        if (this.current.getValue() instanceof SplitterNode) {
            MessageProcessorNode laneNode = new MessageProcessorNode((MessageFlowEntity)lane);
            this.current.addChild((IMessageProcessorNode)laneNode);
            this.current = laneNode;
        }
        return true;
    }

    public boolean postCompartmentLane(CompartmentLane lane) {
        IMessageProcessorNode parent = this.current.getParent();
        if (parent != null && parent.getValue() instanceof SplitterNode) {
            if (this.current.getChildren().isEmpty() && parent != null) {
                parent.getChildren().removeIf(a -> a.equals(this.current));
            }
            this.current = parent;
        }
        return true;
    }

    public boolean preGlobalElement(GlobalElement globalElement) {
        if (MessageFlowUtils.isExceptionStrategy((IMessageFlowEntity)globalElement)) {
            MessageProcessorNode laneNode = new MessageProcessorNode((MessageFlowEntity)globalElement);
            this.current.addChild((IMessageProcessorNode)laneNode);
            this.current = laneNode;
        }
        return true;
    }

    public boolean postGlobalElement(GlobalElement globalElement) {
        if (MessageFlowUtils.isExceptionStrategy((IMessageFlowEntity)globalElement)) {
            this.current = this.current.getParent();
        }
        return true;
    }

    public boolean preMuleConfiguration(MuleConfiguration muleConfiguration) {
        this.root = new MessageProcessorNode((MessageFlowEntity)muleConfiguration);
        this.current = this.root;
        return true;
    }

    public void preChildrenVisit(MessageFlowEntity entity) {
        MessageProcessorNode messageProcessorNode = new MessageProcessorNode(entity);
        this.current.addChild((IMessageProcessorNode)messageProcessorNode);
        this.current = messageProcessorNode;
    }

    public void postChildrenVisit(MessageFlowEntity entity) {
        if (this.current.getChildren().isEmpty() && this.current.getParent() != null) {
            this.current.getParent().getChildren().removeIf(a -> a.equals(this.current));
        }
        this.current = this.current.getParent();
    }

    public IMessageProcessorNode<MuleConfiguration> getRoot() {
        return this.root;
    }
}

