/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.referenced;

import java.util.Optional;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.CommentContainer;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.GlobalUnknown;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.UnknownNode;
import org.mule.tooling.model.messageflow.util.AbstractMessageFlowEntityVisitor;
import org.mule.tooling.model.messageflow.util.IMessageProcessorNode;
import org.mule.tooling.model.messageflow.util.MessageProcessorNode;
import org.mule.tooling.model.messageflow.util.RootAwareEntityVisitor;
import org.mule.tooling.model.module.NodeDefinition;

public class ErrorHandlerReferencedByMuleTreeBuilderVisitor
extends AbstractMessageFlowEntityVisitor
implements RootAwareEntityVisitor {
    private IMessageProcessorNode<MuleConfiguration> root;
    private IMessageProcessorNode<? extends MessageFlowEntity> current;
    private String nodeName;

    public ErrorHandlerReferencedByMuleTreeBuilderVisitor(String nodeName) {
        this.nodeName = nodeName;
    }

    public void visitEndpointNode(EndpointNode endpointNode) {
    }

    public void visitPatternNode(PatternNode patternNode) {
    }

    public void visitGlobalUnknown(GlobalUnknown globalUnknown) {
    }

    public void visitUnknownNode(UnknownNode unknownNode) {
    }

    public void visitCommentNode(CommentContainer commentNode) {
    }

    public boolean preCompartment(Compartment compartment) {
        return true;
    }

    public boolean postCompartment(Compartment compartment) {
        return true;
    }

    public boolean postMuleConfiguration(MuleConfiguration muleConfiguration) {
        return true;
    }

    public boolean preCompartmentLane(CompartmentLane lane) {
        if (lane instanceof NestedContainer) {
            return !ModelUtils.isErrorHandler((NodeDefinition)((NestedContainer)lane).getDefinition());
        }
        return true;
    }

    public boolean postCompartmentLane(CompartmentLane lane) {
        if (lane instanceof NestedContainer) {
            return !ModelUtils.isErrorHandler((NodeDefinition)((NestedContainer)lane).getDefinition());
        }
        return true;
    }

    public boolean preGlobalElement(GlobalElement globalElement) {
        if (MessageFlowUtils.isExceptionStrategy((IMessageFlowEntity)globalElement)) {
            MessageProcessorNode laneNode;
            this.current = laneNode = new MessageProcessorNode((MessageFlowEntity)globalElement);
        }
        return true;
    }

    public boolean postGlobalElement(GlobalElement globalElement) {
        if (MessageFlowUtils.isExceptionStrategy((IMessageFlowEntity)globalElement)) {
            this.current = this.current.getParent();
        }
        return true;
    }

    public boolean preMuleConfiguration(MuleConfiguration muleConfiguration) {
        this.root = new MessageProcessorNode((MessageFlowEntity)muleConfiguration);
        this.current = this.root;
        return true;
    }

    public void preChildrenVisit(MessageFlowEntity entity) {
        MessageProcessorNode messageProcessorNode = new MessageProcessorNode(entity);
        this.current.addChild((IMessageProcessorNode)messageProcessorNode);
        this.current = messageProcessorNode;
    }

    public void postChildrenVisit(MessageFlowEntity entity) {
        if (this.current.getChildren().isEmpty() && this.current.getParent() != null) {
            this.current.getParent().getChildren().removeIf(a -> a.equals(this.current));
        }
        this.current = this.current.getParent();
    }

    public IMessageProcessorNode<MuleConfiguration> getRoot() {
        return this.root;
    }

    public void visitNestedContainer(NestedContainer nestedContainer) {
        super.visitNestedContainer(nestedContainer);
        if (ModelUtils.isErrorHandler((NodeDefinition)nestedContainer.getDefinition())) {
            Optional.ofNullable((IReadOnlyProperty)nestedContainer.getProperties().getProperty("ref")).ifPresent(property -> {
                if (this.nodeName.equals(property.getValue())) {
                    this.current.addChild((IMessageProcessorNode)new MessageProcessorNode((MessageFlowEntity)nestedContainer));
                }
            });
        }
    }
}

