/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.outline;

import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.CommentContainer;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.GlobalUnknown;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.UnknownNode;
import org.mule.tooling.model.messageflow.util.AbstractMessageFlowEntityVisitor;
import org.mule.tooling.model.messageflow.util.IMessageProcessorNode;
import org.mule.tooling.model.messageflow.util.MessageProcessorNode;
import org.mule.tooling.model.messageflow.util.RootAwareEntityVisitor;
import org.mule.tooling.model.module.NodeDefinition;

public class VisibleMuleTreeBuilderVisitor
extends AbstractMessageFlowEntityVisitor
implements RootAwareEntityVisitor {
    private IMessageProcessorNode<MuleConfiguration> root;
    private IMessageProcessorNode<? extends MessageFlowEntity> current;

    public void visitEndpointNode(EndpointNode endpointNode) {
        this.current.addChild((IMessageProcessorNode)new MessageProcessorNode((MessageFlowEntity)endpointNode));
    }

    public void visitPatternNode(PatternNode patternNode) {
        this.current.addChild((IMessageProcessorNode)new MessageProcessorNode((MessageFlowEntity)patternNode));
    }

    public void visitGlobalUnknown(GlobalUnknown globalUnknown) {
    }

    public void visitUnknownNode(UnknownNode unknownNode) {
        this.current.addChild((IMessageProcessorNode)new MessageProcessorNode((MessageFlowEntity)unknownNode));
    }

    public void visitCommentNode(CommentContainer commentNode) {
        this.current.addChild((IMessageProcessorNode)new MessageProcessorNode((MessageFlowEntity)commentNode));
    }

    public boolean preCompartment(Compartment compartment) {
        return true;
    }

    public boolean postCompartment(Compartment compartment) {
        return true;
    }

    public boolean preCompartmentLane(CompartmentLane lane) {
        if (this.current.getValue() instanceof SplitterNode) {
            MessageProcessorNode laneNode = new MessageProcessorNode((MessageFlowEntity)lane);
            this.current.addChild((IMessageProcessorNode)laneNode);
            this.current = laneNode;
        }
        if (lane instanceof NestedContainer) {
            return !ModelUtils.isErrorHandler((NodeDefinition)((NestedContainer)lane).getDefinition());
        }
        return true;
    }

    public boolean postCompartmentLane(CompartmentLane lane) {
        IMessageProcessorNode parent = this.current.getParent();
        if (parent != null && parent.getValue() instanceof SplitterNode) {
            this.current = this.current.getParent();
        }
        if (lane instanceof NestedContainer) {
            return !ModelUtils.isErrorHandler((NodeDefinition)((NestedContainer)lane).getDefinition());
        }
        return true;
    }

    public boolean preGlobalElement(GlobalElement globalElement) {
        if (MessageFlowUtils.isExceptionStrategy((IMessageFlowEntity)globalElement)) {
            MessageProcessorNode laneNode = new MessageProcessorNode((MessageFlowEntity)globalElement);
            this.current.addChild((IMessageProcessorNode)laneNode);
            this.current = laneNode;
        }
        return true;
    }

    public boolean postGlobalElement(GlobalElement globalElement) {
        if (MessageFlowUtils.isExceptionStrategy((IMessageFlowEntity)globalElement)) {
            this.current = this.current.getParent();
        }
        return true;
    }

    public boolean preMuleConfiguration(MuleConfiguration muleConfiguration) {
        this.root = new MessageProcessorNode((MessageFlowEntity)muleConfiguration);
        this.current = this.root;
        return true;
    }

    public void preChildrenVisit(MessageFlowEntity entity) {
        MessageProcessorNode messageProcessorNode = new MessageProcessorNode(entity);
        this.current.addChild((IMessageProcessorNode)messageProcessorNode);
        this.current = messageProcessorNode;
    }

    public void postChildrenVisit(MessageFlowEntity entity) {
        this.current = this.current.getParent();
    }

    public IMessageProcessorNode<MuleConfiguration> getRoot() {
        return this.root;
    }
}

