/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.outline;

import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.StudioDesignContextRunner;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.outline.LabelRetrieverEntityVisitor;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.CommentContainer;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.GlobalUnknown;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.Route;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.UnknownNode;
import org.mule.tooling.model.messageflow.util.IMessageProcessorNode;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitorAdapter;
import org.mule.tooling.model.messageflow.util.TreeMuleConfiguration;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public final class OutlineLabelProvider
extends StyledCellLabelProvider
implements ILabelProvider,
IColorProvider,
IFontProvider {
    public static final String BULLET_BLUE_KEY = "bullet-blue-alt";
    public static final String BULLET_RED_KEY = "bullet-red-alt";
    public static final String BULLET_GREEN_KEY = "bullet-green-alt";
    public static final String BULLET_YELLOW_KEY = "bullet-yellow-alt";
    public static final String BULLET_ORANGE_KEY = "bullet-orange-alt";
    public static final String MULE_IMG_KEY = "mule-icon-outline";
    public static final ImageDescriptor BULLET_BLUE = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.mule.tooling.messageflow", (String)"icons/bullet-blue-alt.png");
    public static final ImageDescriptor BULLET_RED = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.mule.tooling.messageflow", (String)"icons/bullet-red-alt.png");
    public static final ImageDescriptor BULLET_GREEN = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.mule.tooling.messageflow", (String)"icons/bullet-green-alt.png");
    public static final ImageDescriptor BULLET_YELLOW = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.mule.tooling.messageflow", (String)"icons/bullet-yellow-alt.png");
    public static final ImageDescriptor BULLET_ORANGE = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.mule.tooling.messageflow", (String)"icons/bullet-orange-alt.png");
    public static final ImageDescriptor MULE_IMG = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.mule.tooling.messageflow", (String)"icons/Mule-16x16.png");
    private IMuleProject muleProject;

    public OutlineLabelProvider() {
        this(MuleCorePlugin.getDesignContext().getMuleProject());
    }

    public OutlineLabelProvider(IMuleProject muleProject) {
        super(1);
        this.muleProject = muleProject;
        if (JFaceResources.getImageRegistry().get(BULLET_BLUE_KEY) == null) {
            JFaceResources.getImageRegistry().put(BULLET_BLUE_KEY, BULLET_BLUE);
            JFaceResources.getImageRegistry().put(BULLET_RED_KEY, BULLET_RED);
            JFaceResources.getImageRegistry().put(BULLET_GREEN_KEY, BULLET_GREEN);
            JFaceResources.getImageRegistry().put(BULLET_YELLOW_KEY, BULLET_YELLOW);
            JFaceResources.getImageRegistry().put(BULLET_ORANGE_KEY, BULLET_ORANGE);
            JFaceResources.getImageRegistry().put(MULE_IMG_KEY, MULE_IMG);
        }
    }

    private IMessageProcessorNode<?> getMessageProcessorNodeFromElementOrRoot(Object element) {
        if (element instanceof TreeMuleConfiguration) {
            TreeMuleConfiguration configNode = (TreeMuleConfiguration)element;
            element = configNode.getRoot();
        }
        return (IMessageProcessorNode)element;
    }

    public String getText(Object element) {
        IMessageProcessorNode<?> node = this.getMessageProcessorNodeFromElementOrRoot(element);
        MessageFlowEntity entity = node.getValue();
        LabelRetrieverEntityVisitor visitor = new LabelRetrieverEntityVisitor(node);
        entity.accept((MessageFlowEntityVisitor)visitor);
        return visitor.getLabel();
    }

    protected String getTypeData(Object element) {
        MessageFlowNode messageFlowNode;
        IMessageProcessorNode<?> node = this.getMessageProcessorNodeFromElementOrRoot(element);
        MessageFlowEntity entity = node.getValue();
        if (entity instanceof MessageFlowNode && (messageFlowNode = (MessageFlowNode)entity).getDefinition() != null) {
            NodeDefinition definition = messageFlowNode.getDefinition();
            return definition.getName();
        }
        TypeRetrieverEntityVisitor visitor = new TypeRetrieverEntityVisitor();
        entity.accept((MessageFlowEntityVisitor)visitor);
        return visitor.getType();
    }

    public Color getForeground(Object element) {
        return ThemeUtils.getCurrentTheme().getForegroundColor();
    }

    public Color getBackground(Object element) {
        return ThemeUtils.getCurrentTheme().getBackgroundColor();
    }

    public Image getImage(final Object element) {
        return (Image)StudioDesignContextRunner.runSilentWithMuleProject((Callable)new Callable<Image>(){

            @Override
            public Image call() throws Exception {
                IMessageProcessorNode<?> node = OutlineLabelProvider.this.getMessageProcessorNodeFromElementOrRoot(element);
                MessageFlowEntity entity = node.getValue();
                ImageRetrieverEntityVisitor visitor = new ImageRetrieverEntityVisitor();
                entity.accept((MessageFlowEntityVisitor)visitor);
                return visitor.getImage();
            }
        }, (IMuleProject)this.muleProject, null);
    }

    public void update(final ViewerCell cell) {
        StudioDesignContextRunner.runSilentWithMuleProject((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                final Object element = cell.getElement();
                cell.setImage(OutlineLabelProvider.this.getImage(element));
                String text = OutlineLabelProvider.this.getText(element);
                StyledString styledString = new StyledString();
                StyledString.Styler dataStyler = new StyledString.Styler(){

                    public void applyStyles(TextStyle textStyle) {
                        textStyle.foreground = OutlineLabelProvider.this.getForeground(element);
                        textStyle.background = OutlineLabelProvider.this.getBackground(element);
                        textStyle.font = OutlineLabelProvider.this.getFont(element);
                    }
                };
                text = text != null ? text : "";
                styledString.append(text, dataStyler);
                String typeData = OutlineLabelProvider.this.getTypeData(element);
                if (StringUtils.isNotBlank((String)typeData)) {
                    StyledString.Styler typeStyler = new StyledString.Styler(){

                        public void applyStyles(TextStyle textStyle) {
                            textStyle.foreground = ThemeUtils.getCurrentTheme().getAnnotationRulerColor();
                            textStyle.font = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
                        }
                    };
                    styledString.append(" : " + typeData, typeStyler);
                }
                cell.setStyleRanges(styledString.getStyleRanges());
                cell.setText(styledString.getString());
                OutlineLabelProvider.super.update(cell);
                return null;
            }
        }, (IMuleProject)this.muleProject);
    }

    public Font getFont(Object element) {
        return null;
    }

    public static final class ImageRetrieverEntityVisitor
    extends MessageFlowEntityVisitorAdapter {
        private Image image;

        public Image getImage() {
            return this.image;
        }

        public void visitMuleConfiguration(MuleConfiguration muleConfiguration) {
            this.image = JFaceResources.getImageRegistry().get(OutlineLabelProvider.MULE_IMG_KEY);
        }

        public void visitContainer(Container container) {
            this.image = ModelUtils.isFlowOrSubflow((IMessageFlowEntity)container) ? JFaceResources.getImageRegistry().get(OutlineLabelProvider.BULLET_BLUE_KEY) : (ModelUtils.isErrorHandler((IMessageFlowEntity)container) ? JFaceResources.getImageRegistry().get(OutlineLabelProvider.BULLET_RED_KEY) : JFaceResources.getImageRegistry().get(OutlineLabelProvider.BULLET_GREEN_KEY));
        }

        public void visitNestedContainer(NestedContainer nestedContainer) {
            this.image = JFaceResources.getImageRegistry().get(OutlineLabelProvider.BULLET_BLUE_KEY);
            if (ModelUtils.isErrorHandler((NodeDefinition)nestedContainer.getDefinition())) {
                this.image = JFaceResources.getImageRegistry().get(OutlineLabelProvider.BULLET_RED_KEY);
            }
        }

        public void visitGlobalElement(GlobalElement globalElement) {
            if (MessageFlowUtils.isExceptionStrategy((IMessageFlowEntity)globalElement)) {
                this.image = JFaceResources.getImageRegistry().get(OutlineLabelProvider.BULLET_ORANGE_KEY);
            }
        }

        public void visitCompartment(Compartment compartment) {
        }

        public void visitCompartmentLane(CompartmentLane lane) {
        }

        public void visitEndpointNode(EndpointNode endpointNode) {
            this.image = JFaceResources.getImageRegistry().get(OutlineLabelProvider.BULLET_BLUE_KEY);
        }

        public void visitPatternNode(PatternNode patternNode) {
            this.image = JFaceResources.getImageRegistry().get(OutlineLabelProvider.BULLET_GREEN_KEY);
        }

        public void visitSplitterNode(SplitterNode splitterNode) {
            this.image = JFaceResources.getImageRegistry().get(OutlineLabelProvider.BULLET_YELLOW_KEY);
        }

        public void visitGlobalUnknown(GlobalUnknown globalUnknown) {
        }

        public void visitRoute(Route route) {
            this.image = JFaceResources.getImageRegistry().get(OutlineLabelProvider.BULLET_YELLOW_KEY);
        }

        public void visitUnknownNode(UnknownNode unknownNode) {
            this.image = JFaceResources.getImageRegistry().get(OutlineLabelProvider.BULLET_GREEN_KEY);
        }

        public void visitCommentNode(CommentContainer commentNode) {
            this.image = JFaceResources.getImageRegistry().get(OutlineLabelProvider.BULLET_GREEN_KEY);
        }
    }

    public static final class TypeRetrieverEntityVisitor
    extends MessageFlowEntityVisitorAdapter {
        private String type = "";

        public String getType() {
            return this.type;
        }

        public void visitUnknownNode(UnknownNode unknownNode) {
            this.type = "Unknown";
        }

        public void visitCommentNode(CommentContainer commentNode) {
            this.type = "Comment";
        }

        public void visitSplitterNode(SplitterNode splitterNode) {
            String longStringType = splitterNode.getType();
            if (longStringType.equals("http://www.mulesoft.org/schema/mule/core/choice")) {
                this.type = "choice";
            } else {
                String[] splitted = longStringType.split("/");
                this.type = splitted[splitted.length - 1];
            }
        }

        public void visitPatternNode(PatternNode patternNode) {
            String longStringType = patternNode.getType();
            this.type = this.parseType(longStringType);
        }

        protected String parseType(String longStringType) {
            String[] splitted = longStringType.split("/");
            return splitted.length > 1 ? splitted[splitted.length - 1] : longStringType;
        }

        public void visitMuleConfiguration(MuleConfiguration muleConfiguration) {
            this.type = "Mule Configuration";
        }

        public void visitGlobalUnknown(GlobalUnknown globalUnknown) {
            this.type = "Global Unknown";
        }

        public void visitGlobalElement(GlobalElement globalElement) {
        }

        public void visitEndpointNode(EndpointNode endpointNode) {
            String longStringType = endpointNode.getType();
            String[] splitted = longStringType.split("/");
            this.type = splitted.length > 2 ? splitted[splitted.length - 2] : longStringType;
        }

        public void visitContainer(Container container) {
            this.type = this.parseType(container.getType());
        }

        public void visitNestedContainer(NestedContainer nestedContainer) {
            this.type = this.parseType(nestedContainer.getType());
        }

        public void visitCompartmentLane(CompartmentLane lane) {
        }

        public void visitCompartment(Compartment compartment) {
        }

        public void visitRoute(Route route) {
            this.type = this.parseType(route.getType());
        }
    }
}

