/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.outline;

import com.google.common.base.Optional;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IMuleModuleManagerRestartedListener;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.messageflow.Activator;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.events.EditPartEventTypes;
import org.mule.tooling.messageflow.events.IEditPartSelectedEventListener;
import org.mule.tooling.messageflow.outline.OutlineContentProvider;
import org.mule.tooling.messageflow.outline.OutlineLabelProvider;
import org.mule.tooling.messageflow.outline.VisibleMuleTreeBuilderVisitor;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.util.IMessageProcessorNode;
import org.mule.tooling.model.messageflow.util.RootAwareEntityVisitor;
import org.mule.tooling.model.messageflow.util.TreeMuleConfiguration;
import org.mule.tooling.model.messageflow.util.TreeMuleConfigurationGenerator;
import org.mule.tooling.ui.utils.UiUtils;
import org.mule.tooling.ui.widgets.tree.StudioFilteredTree;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class MessageFlowOutlinePage
extends Page
implements IContentOutlinePage,
IPropertyListener {
    private static final String DISABLED_MESSAGE_FLOW_OUTLINE_MESSAGE = "Open the Message Flow Editor\nfor an outline of your flows";
    private static final String DISABLED_MESSAGE_FLOW_OUTLINE_IMAGE_PATH = "icons/disabled-outline.png";
    private StudioFilteredTree filteredTreeViewer;
    protected MessageFlowEditor editor;
    private TreeMuleConfiguration muleConfigTree;
    private IOpenListener treeViewerOpenLister;
    private IPageChangedListener pageChangedListener;
    private StackLayout containerStackLayout;
    private Composite disabledOutlineText;
    private Composite container;
    private MultiPageMessageFlowEditor multiPageEditor;
    private EventBusHelper eventBusHelper;

    public MessageFlowOutlinePage(MultiPageMessageFlowEditor multiPageEditor, MessageFlowEditor editor) {
        this.multiPageEditor = multiPageEditor;
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        this.editor.addPropertyListener(this);
        this.container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.container);
        this.containerStackLayout = new StackLayout();
        this.containerStackLayout.marginHeight = 2;
        this.containerStackLayout.marginWidth = 2;
        this.container.setLayout((Layout)this.containerStackLayout);
        this.disabledOutlineText = UiUtils.createDisabledComposite((Composite)this.container, (String)DISABLED_MESSAGE_FLOW_OUTLINE_MESSAGE, (Image)Activator.getImages().getImage(DISABLED_MESSAGE_FLOW_OUTLINE_IMAGE_PATH));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.disabledOutlineText);
        this.filteredTreeViewer = this.createTreeViewer(this.container);
        Optional<IWorkbenchPage> activeWorkbenchPage = MessageFlowUtils.getActiveWorkbenchPage();
        this.setCurrentView(this.multiPageEditor.getActiveEditor());
        this.muleConfigTree = this.getMuleConfigTree();
        TreeViewer treeViewer = this.filteredTreeViewer.getViewer();
        treeViewer.setContentProvider((IContentProvider)new OutlineContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new OutlineLabelProvider(this.editor.getMuleProject()));
        treeViewer.setInput((Object)this.muleConfigTree);
        treeViewer.expandToLevel(2);
        this.registerListeners();
        if (activeWorkbenchPage.isPresent()) {
            this.pageChangedListener = new IPageChangedListener(){

                public void pageChanged(PageChangedEvent event) {
                    if (!MessageFlowOutlinePage.this.container.isDisposed()) {
                        MessageFlowOutlinePage.this.setCurrentView(event.getSelectedPage());
                        if (event.getSelectedPage().equals((Object)MessageFlowOutlinePage.this.multiPageEditor.getFlowEditor())) {
                            MessageFlowOutlinePage.this.update();
                        }
                    }
                }
            };
            this.multiPageEditor.addPageChangedListener(this.pageChangedListener);
        }
    }

    private void registerListeners() {
        EventBus eventBus = MuleCorePlugin.getEventBus();
        this.eventBusHelper = new EventBusHelper();
        this.eventBusHelper.registerUIListener(eventBus, CoreEventTypes.ON_MULE_MODULE_MANAGER_RESTARTED, (IEventHandler)new IMuleModuleManagerRestartedListener(){

            public void onMuleModuleManagerRestarted(IMuleModuleManager muleModuleManager) {
                MessageFlowOutlinePage.this.update();
            }
        });
        this.eventBusHelper.registerListener(eventBus, EditPartEventTypes.ON_EDIT_PART_SELECTED, (IEventHandler)new IEditPartSelectedEventListener(){

            @Override
            public void onEditPartSelected(MuleConfiguration configuration, EntityEditPart<?> editPart) {
                IMessageProcessorNode node;
                if (MessageFlowOutlinePage.this.getMuleConfiguration().equals(configuration) && (node = MessageFlowOutlinePage.this.muleConfigTree.searchNodeForEntity((MessageFlowEntity)editPart.getEntityDecorator().getEntity())) != null && !node.equals(MessageFlowOutlinePage.this.getSelectedElement())) {
                    MessageFlowOutlinePage.this.filteredTreeViewer.getViewer().setSelection((ISelection)new StructuredSelection((Object)node));
                }
            }
        });
    }

    private void setCurrentView(Object activeEditor) {
        this.containerStackLayout.topControl = activeEditor.equals((Object)this.multiPageEditor.getFlowEditor()) ? this.filteredTreeViewer : this.disabledOutlineText;
        this.container.layout();
    }

    protected MuleConfiguration getMuleConfiguration() {
        return this.editor.getMuleConfiguration();
    }

    public void dispose() {
        this.eventBusHelper.unregister();
        this.multiPageEditor.removePageChangedListener(this.pageChangedListener);
        super.dispose();
        this.multiPageEditor = null;
    }

    protected TreeViewer getTreeViewer() {
        return this.filteredTreeViewer.getViewer();
    }

    public Control getControl() {
        return this.container;
    }

    public ISelection getSelection() {
        if (this.getTreeViewer() == null) {
            return StructuredSelection.EMPTY;
        }
        return this.getTreeViewer().getSelection();
    }

    public void setFocus() {
        this.getTreeViewer().getControl().setFocus();
    }

    public void setSelection(ISelection selection) {
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().setSelection(selection);
        }
    }

    protected IMessageProcessorNode<?> getSelectedElement() {
        if (this.getTreeViewer() == null) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getTreeViewer().getSelection();
        return (IMessageProcessorNode)selection.getFirstElement();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.getTreeViewer().removeSelectionChangedListener(listener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.getTreeViewer().addSelectionChangedListener(listener);
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 257) {
            this.update();
        }
    }

    private void update() {
        this.muleConfigTree = this.getMuleConfigTree();
        TreeViewer treeViewer = this.getTreeViewer();
        if (!treeViewer.getControl().isDisposed()) {
            treeViewer.setInput((Object)this.muleConfigTree);
            treeViewer.expandToLevel(2);
        }
    }

    public void setTreeViewerOpenLister(IOpenListener treeViewerOpenLister) {
        this.treeViewerOpenLister = treeViewerOpenLister;
    }

    private StudioFilteredTree createTreeViewer(Composite parent) {
        StudioFilteredTree filteredTree = new StudioFilteredTree(parent, 66304, new PatternFilter());
        TreeViewer treeViewer = filteredTree.getViewer();
        treeViewer.addOpenListener(this.getTreeViewerOpenListener());
        return filteredTree;
    }

    private TreeMuleConfiguration getMuleConfigTree() {
        TreeMuleConfigurationGenerator treeGenerator = new TreeMuleConfigurationGenerator();
        MuleConfiguration muleConfiguration = this.getMuleConfiguration();
        return treeGenerator.generateTreeConfiguration(muleConfiguration, (RootAwareEntityVisitor)new VisibleMuleTreeBuilderVisitor());
    }

    private IOpenListener getTreeViewerOpenListener() {
        return this.treeViewerOpenLister != null ? this.treeViewerOpenLister : new IOpenListener(){

            public void open(OpenEvent event) {
                MessageFlowOutlinePage.this.goToSelectedElement();
            }
        };
    }

    private void goToSelectedElement() {
        EntityEditPart<?> editPart;
        IMessageProcessorNode<?> selectedElement = this.getSelectedElement();
        if (selectedElement != null && (editPart = MessageFlowEditor.findEditPartInRegistry((EditPartViewer)this.editor.getViewer(), (IMessageFlowEntity)selectedElement.getValue())) != null) {
            editPart.performRequest(new Request((Object)"open"));
            editPart.showCollapsed();
            this.editor.getViewer().reveal(editPart);
            this.editor.setSelection((ISelection)new StructuredSelection(editPart));
        }
    }
}

