/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.outline;

import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.GlobalUnknown;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.Route;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.UnknownNode;
import org.mule.tooling.model.messageflow.util.IMessageProcessorNode;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitorAdapter;

public final class LabelRetrieverEntityVisitor
extends MessageFlowEntityVisitorAdapter {
    private String label = "";
    private final IMessageProcessorNode<?> node;

    public LabelRetrieverEntityVisitor(IMessageProcessorNode<?> node) {
        this.node = node;
    }

    public void visitUnknownNode(UnknownNode unknownNode) {
        this.setLabel("Unknown");
    }

    public void visitSplitterNode(SplitterNode splitterNode) {
        this.setLabel(splitterNode.getName());
    }

    public void visitPatternNode(PatternNode patternNode) {
        this.setLabel(patternNode.getName());
    }

    public void visitMuleConfiguration(MuleConfiguration muleConfiguration) {
        this.setLabel(muleConfiguration.getName());
    }

    public void visitGlobalUnknown(GlobalUnknown globalUnknown) {
        this.setLabel(globalUnknown.getUnknownName());
    }

    public void visitGlobalElement(GlobalElement globalElement) {
        this.setLabel(globalElement.getName());
    }

    public void visitEndpointNode(EndpointNode endpointNode) {
        this.setLabel(endpointNode.getName());
    }

    public void visitContainer(Container container) {
        this.setLabel(container.getName());
    }

    public void visitNestedContainer(NestedContainer nestedContainer) {
        this.setLabel(nestedContainer.getName());
    }

    public void visitRoute(Route route) {
        this.setLabel(route.getDisplayName());
    }

    public void visitCompartmentLane(CompartmentLane lane) {
        IMessageProcessorNode parent = this.node.getParent();
        if (parent != null && parent.getValue() instanceof SplitterNode) {
            this.setLabel(String.valueOf(this.numberOfPreviousSiblings(this.node)));
        }
    }

    private int numberOfPreviousSiblings(IMessageProcessorNode<?> node) {
        int i = 0;
        IMessageProcessorNode current = node;
        while (current.getPrevious() != null) {
            current = current.getPrevious();
            ++i;
        }
        return i;
    }

    public void visitCompartment(Compartment compartment) {
    }

    public String getLabel() {
        return this.label;
    }

    private void setLabel(String label) {
        this.label = label;
    }
}

