/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.outline;

import java.util.Optional;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.outline.OutlineContentProvider;
import org.mule.tooling.messageflow.outline.OutlineLabelProvider;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.util.IMessageProcessorNode;

public abstract class AbstractOutlinePopupDialog
extends PopupDialog {
    private TreeViewer treeViewer;
    private PatternFilter filter;
    private Text filterText;

    public AbstractOutlinePopupDialog(Shell parent, int shellStyle, boolean takeFocusOnOpen, boolean persistSize, boolean persistLocation, boolean showDialogMenu, boolean showPersistActions, String titleText, String infoText) {
        super(parent, shellStyle, takeFocusOnOpen, persistSize, persistLocation, showDialogMenu, showPersistActions, titleText, infoText);
    }

    public AbstractOutlinePopupDialog(Shell parent) {
        this(parent, 16, true, true, false, true, true, null, null);
    }

    protected Control createTitleControl(Composite parent) {
        this.filterText = new Text(parent, 0);
        Dialog.applyDialogFont((Control)this.filterText);
        GridData data = new GridData(768);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 2;
        this.filterText.setLayoutData((Object)data);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractOutlinePopupDialog.this.filter.setPattern(AbstractOutlinePopupDialog.this.filterText.getText());
                AbstractOutlinePopupDialog.this.treeViewer.refresh();
            }
        });
        this.filterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    AbstractOutlinePopupDialog.this.goToSelectedElement();
                }
                if (e.keyCode == 0x1000002) {
                    AbstractOutlinePopupDialog.this.treeViewer.getTree().setFocus();
                }
                if (e.keyCode == 0x1000001) {
                    AbstractOutlinePopupDialog.this.treeViewer.getTree().setFocus();
                }
                if (e.character == '\u001b') {
                    AbstractOutlinePopupDialog.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        return parent;
    }

    private void goToSelectedElement() {
        IMessageProcessorNode<?> selectedElement = this.getSelectedElement();
        if (selectedElement != null) {
            this.dispose();
            this.getAndOpenFlowEditorForElement(selectedElement).ifPresent(flowEditor -> this.selectNodeInFlowEditor(selectedElement, (MessageFlowEditor)((Object)flowEditor)));
        }
    }

    protected abstract Optional<MessageFlowEditor> getAndOpenFlowEditorForElement(IMessageProcessorNode<?> var1);

    private void selectNodeInFlowEditor(IMessageProcessorNode<?> node, MessageFlowEditor flowEditor) {
        EntityEditPart<?> editPart = MessageFlowEditor.findEditPartInRegistry((EditPartViewer)flowEditor.getViewer(), (IMessageFlowEntity)node.getValue());
        if (editPart != null) {
            editPart.performRequest(new Request((Object)"open"));
            flowEditor.getViewer().reveal(editPart);
            flowEditor.setSelection((ISelection)new StructuredSelection(editPart));
        }
    }

    protected IMessageProcessorNode<?> getSelectedElement() {
        if (this.treeViewer == null) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        Object element = selection.getFirstElement();
        if (!(element instanceof IMessageProcessorNode)) {
            return null;
        }
        return (IMessageProcessorNode)element;
    }

    private void dispose() {
        this.close();
    }

    protected Control createDialogArea(Composite parent) {
        this.treeViewer = this.createTreeViewer(parent);
        this.treeViewer.setContentProvider((IContentProvider)new OutlineContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new OutlineLabelProvider());
        this.treeViewer.setInput(this.getTreeViewerInput());
        this.treeViewer.expandToLevel(2);
        return parent;
    }

    protected abstract Object getTreeViewerInput();

    private TreeViewer createTreeViewer(Composite parent) {
        TreeViewer treeViewer = new TreeViewer(parent, 66304);
        this.filter = new PatternFilter();
        treeViewer.addFilter((ViewerFilter)this.filter);
        Tree tree = treeViewer.getTree();
        GridData gd = new GridData(1808);
        tree.setLayoutData((Object)gd);
        gd.minimumWidth = 300;
        gd.minimumHeight = 350;
        treeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                AbstractOutlinePopupDialog.this.goToSelectedElement();
            }
        });
        return treeViewer;
    }
}

