/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.module;

import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.client.MetadataCacheEvictServiceExecutor;
import org.mule.tooling.client.startup.ToolingManager;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.ToolingJobsManager;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.messageflow.module.MessageFlowNodeAction;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.metadata.cache.MetadataTypesManager;
import org.mule.tooling.metadata.utils.MetadataUtils;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.runtime.tooling.ToolingWorkspace;

public class ResetMetadataCacheAction
extends MessageFlowNodeAction {
    public ResetMetadataCacheAction(MessageFlowNode messageFlowNode, IMuleProject muleProject) {
        super(muleProject, messageFlowNode, null);
        this.muleProject = muleProject;
        this.setToolTipText("Reset the metadata cache for this connector");
        this.setText("Clear DataSense Metadata");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_CLEAR"));
    }

    public void run() {
        ((MetadataTypesManager)this.muleProject.getProjectComponent(MetadataTypesManager.class)).getTypesManager().removeMetadataTypes(this.getReferenceName());
        this.evictNodeMetadata(this.muleProject, MessageFlowUtils.getMuleConfigFromActivePage(), (IMessageFlowNode)this.node, this.getReferenceName());
    }

    protected String getReferenceName() {
        return this.node instanceof GlobalElement ? CoreUtils.getNameProperty((IMessageFlowNode)this.node) : MetadataUtils.getGlobalReference((IMessageFlowNode)this.node);
    }

    protected boolean calculateEnabled() {
        return true;
    }

    private void evictNodeMetadata(IMuleProject project, MuleConfiguration muleConfiguration, IMessageFlowNode node, String mulePath) {
        Job evictJob = Job.create((String)("Removing datasense for [" + mulePath + "]"), monitor -> {
            Supplier<IMessageFlowNode> newMessageFlowNodeSupplier = MessageFlowUtils.generateNodeToTestSupplier(node);
            Function<IMessageFlowNode, PropertyCollectionMap> updatedPropertiesProvider = x -> node.getProperties().toPropertyCollectionMap();
            try {
                ((MetadataCacheEvictServiceExecutor.MetadataCacheEvictServiceExecutorBuilder)((MetadataCacheEvictServiceExecutor.MetadataCacheEvictServiceExecutorBuilder)((MetadataCacheEvictServiceExecutor.MetadataCacheEvictServiceExecutorBuilder)((MetadataCacheEvictServiceExecutor.MetadataCacheEvictServiceExecutorBuilder)((MetadataCacheEvictServiceExecutor.MetadataCacheEvictServiceExecutorBuilder)((MetadataCacheEvictServiceExecutor.MetadataCacheEvictServiceExecutorBuilder)((MetadataCacheEvictServiceExecutor.MetadataCacheEvictServiceExecutorBuilder)((MetadataCacheEvictServiceExecutor.MetadataCacheEvictServiceExecutorBuilder)MetadataCacheEvictServiceExecutor.newBuilder().toolingWorkspace(ToolingWorkspace.getInstance())).muleInstance(ToolingManager.getInstance().getToolingInstance())).project(project)).muleConfiguration(muleConfiguration)).generalErrorMessage("Unable to refresh types")).componentLocation(mulePath).messageFlowNode(node)).newMessageFlowNodeSupplier(newMessageFlowNodeSupplier)).updatedPropertiesProvider(updatedPropertiesProvider)).build().runServiceRequest();
            }
            catch (Exception e) {
                MuleCorePlugin.logError((String)("Unexpected error while removing metadata for [" + mulePath + "]"), (Throwable)e);
            }
        });
        evictJob.setJobGroup(ToolingJobsManager.getToolingJobGroup());
        evictJob.setPriority(30);
        evictJob.schedule();
    }
}

