/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.PatternFilter;
import org.mule.tooling.client.api.PropagationInfo;
import org.mule.tooling.client.metadata.MetadataEvent;
import org.mule.tooling.messageflow.metadata.FilteredCheckboxTree;
import org.mule.tooling.messageflow.metadata.MetadataEventGraphicalChildrenProvider;
import org.mule.tooling.metadata.custom.metadata.assistant.CustomMetadataAssistantService;
import org.mule.tooling.metadata.custom.metadata.assistant.MetadataActualExpectedParametersContainer;
import org.mule.tooling.metadata.custom.metadata.assistant.MetadataActualExpectedPreference;
import org.mule.tooling.metadata.custom.metadata.assistant.MetadataActualExpectedSelectionType;
import org.mule.tooling.metadata.datasense.MetadataPair;
import org.mule.tooling.ui.widgets.search.LimitedLevelPatternFilter;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeContentProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeLabelProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.ui.widgets.tree.model.IGraphicalChildrenProvider;
import org.mule.tooling.utils.eventbus.EventBusHelper;

public class SideToSideMetadataTreeExplorer
extends Composite {
    private static final String ROOT_TYPE = "ROOT_TYPE";
    private static final String ELEMENT_NAME = "ELEMENT_NAME";
    private static final String ACTUAL_EXPECTED = "ACTUAL_EXPECTED";
    private static final String METADATA_TYPE = "METADATA_TYPE";
    private static final String STYLE_KEY = "org.eclipse.jfacestyled_label_key_0";
    private static final String TEXT_SEPARATOR = "      ";
    private static final int MAX_RECURSION_LEVEL = 16;
    private static final int DEFAULT_EXPAND_LEVEL = 3;
    private static final String OUTPUT_LABEL = "Output Metadata";
    private static final String OUTPUT = "Output";
    private static final String INPUT = "Input";
    private static final String INPUT_LABEL = "Input Metadata";
    private FilteredCheckboxTree inputMetadataTree;
    private FilteredCheckboxTree outputMetadataTree;
    private EventBusHelper eventBusHelper;
    private CustomMetadataAssistantService customMetadataAssistantService;
    private MetadataActualExpectedParametersContainer propagationPreference;
    private CTabFolder inputMetadataViewer;
    private CTabFolder outputMetadataViewer;

    public SideToSideMetadataTreeExplorer(Composite parent, int style, CustomMetadataAssistantService customMetadataAssistantService) {
        super(parent, style);
        this.setBackgroundMode(2);
        this.eventBusHelper = new EventBusHelper();
        GridLayoutFactory.swtDefaults().numColumns(4).margins(0, 0).spacing(0, 0).equalWidth(true).applyTo((Composite)this);
        GridData gridData = new GridData(4, 16384, true, false, 4, 1);
        gridData.minimumHeight = 200;
        gridData.horizontalIndent = 7;
        this.setLayoutData(gridData);
        this.createControl(this);
        this.addDisposeListener(e -> this.controlDisposed());
        this.customMetadataAssistantService = customMetadataAssistantService;
    }

    protected void createControl(Composite parent) {
        Composite editorComposite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).spacing(0, 0).equalWidth(false).applyTo(editorComposite);
        GridData editorGridData = new GridData(4, 0x1000000, true, true, 4, 2);
        editorGridData.minimumHeight = 300;
        editorComposite.setLayoutData((Object)editorGridData);
        this.inputMetadataViewer = new CTabFolder(editorComposite, 0);
        this.inputMetadataTree = new FilteredCheckboxTree((Composite)this.inputMetadataViewer, 66304, (PatternFilter)new LimitedLevelPatternFilter(16));
        this.generateViewer(this.inputMetadataViewer, this.inputMetadataTree, INPUT_LABEL);
        this.outputMetadataViewer = new CTabFolder(editorComposite, 0);
        this.outputMetadataTree = new FilteredCheckboxTree((Composite)this.outputMetadataViewer, 66304, (PatternFilter)new LimitedLevelPatternFilter(16));
        this.generateViewer(this.outputMetadataViewer, this.outputMetadataTree, OUTPUT_LABEL);
        this.setTabSelectionToZero();
    }

    public void generateViewer(CTabFolder viewer, FilteredCheckboxTree tree, String ctabText) {
        GridData gridData = new GridData(4, 16384, true, true, 1, 2);
        gridData.heightHint = 300;
        gridData.widthHint = 150;
        viewer.setLayoutData((Object)gridData);
        viewer.setBorderVisible(false);
        GraphicalTreeLabelProvider metadataTreeLabelProvider = new GraphicalTreeLabelProvider();
        tree.getViewer().setLabelProvider((IBaseLabelProvider)metadataTreeLabelProvider);
        tree.getViewer().setContentProvider((IContentProvider)new GraphicalTreeContentProvider(16));
        tree.setBackgroundMode(2);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tree.getViewer());
        CTabItem cTab = new CTabItem(viewer, 2048);
        cTab.setText(ctabText);
        cTab.setControl((Control)tree);
    }

    public void unregisterFromEvents() {
        this.eventBusHelper.unregister();
    }

    private void controlDisposed() {
        this.unregisterFromEvents();
    }

    public GraphicalTreeNode<MetadataPair<MetadataEvent, MetadataEvent>> getInput() {
        return (GraphicalTreeNode)this.inputMetadataTree.getViewer().getInput();
    }

    public GraphicalTreeNode<MetadataPair<MetadataEvent, MetadataEvent>> getOutput() {
        return (GraphicalTreeNode)this.outputMetadataTree.getViewer().getInput();
    }

    protected GraphicalTreeNode<MetadataPair<MetadataEvent, MetadataEvent>> createGraphicalTreeNode(MetadataPair<MetadataEvent, MetadataEvent> metadataPair) {
        return new GraphicalTreeNode(null, null, null, (IGraphicalChildrenProvider)new MetadataEventGraphicalChildrenProvider(metadataPair));
    }

    public void updateMetadata(PropagationInfo propagationInfo) {
        this.updateMetadata(propagationInfo, propagationInfo);
    }

    public void updateMetadata(PropagationInfo firstElementMetadata, PropagationInfo lastElementMetadata) {
        if (!(this.isDisposed() || this.inputMetadataTree.isDisposed() || this.outputMetadataTree.isDisposed())) {
            MetadataEvent actualInputMetadata = firstElementMetadata.isFlow() ? firstElementMetadata.getExpectedMetadataType() : firstElementMetadata.getIncomingMetadataType();
            MetadataEvent expectedInputMetadata = firstElementMetadata.isFlow() ? firstElementMetadata.getInputMetadataType() : firstElementMetadata.getExpectedInputMetadataType();
            MetadataEvent actualOutputMetadata = lastElementMetadata.isFlow() ? lastElementMetadata.getIncomingMetadataType() : lastElementMetadata.getResultMetadataType();
            MetadataEvent expectedOutputMetadata = lastElementMetadata.isFlow() ? lastElementMetadata.getOutputMetadataType() : lastElementMetadata.getExpectedMetadataType();
            this.propagationPreference = this.customMetadataAssistantService.getActualExpectedMetadataParametersContainer(firstElementMetadata, lastElementMetadata);
            Map<String, Map<String, MetadataActualExpectedSelectionType>> preferenceMap = this.buildPreferenceMap(this.propagationPreference);
            MetadataPair inputMetadataPair = new MetadataPair((Object)actualInputMetadata, (Object)expectedInputMetadata);
            this.inputMetadataTree.getViewer().setInput(this.createGraphicalTreeNode((MetadataPair<MetadataEvent, MetadataEvent>)inputMetadataPair));
            this.inputMetadataTree.getViewer().expandToLevel(3);
            this.generateCheckboxes(this.inputMetadataTree, preferenceMap.get(INPUT), INPUT);
            MetadataPair outputMetadataPair = new MetadataPair((Object)actualOutputMetadata, (Object)expectedOutputMetadata);
            this.outputMetadataTree.getViewer().setInput(this.createGraphicalTreeNode((MetadataPair<MetadataEvent, MetadataEvent>)outputMetadataPair));
            this.outputMetadataTree.getViewer().expandToLevel(3);
            this.generateCheckboxes(this.outputMetadataTree, preferenceMap.get(OUTPUT), OUTPUT);
        }
    }

    private void generateCheckboxes(FilteredCheckboxTree treeComponent, Map<String, MetadataActualExpectedSelectionType> preferenceMap, String metadataType) {
        Tree tree = treeComponent.getViewer().getTree();
        tree.addListener(17, new Listener(){

            public void handleEvent(Event event) {
                Arrays.asList(((TreeItem)event.item).getItems()).forEach(item -> item.setText(1, ""));
            }
        });
        Arrays.asList(tree.getChildren()).forEach(child -> child.dispose());
        for (TreeItem item : Arrays.asList(tree.getItems())) {
            this.iterateItem(item, tree, preferenceMap, metadataType);
        }
    }

    private void iterateItem(TreeItem item, Tree tree, Map<String, MetadataActualExpectedSelectionType> preferenceMap, String metadataType) {
        if (item.getParentItem() != null && item.getParentItem().getParentItem() != null && !item.getText().isEmpty()) {
            TreeEditor editor = new TreeEditor(tree);
            Composite wrapper = new Composite((Composite)tree, 262144);
            Button checkboxButton = new Button(wrapper, 262176);
            checkboxButton.setSize(15, 15);
            editor.minimumWidth = 14;
            editor.horizontalAlignment = 16384;
            item.setText(TEXT_SEPARATOR + item.getText());
            item.setData(STYLE_KEY, null);
            editor.setEditor((Control)wrapper, item);
            String parentItemElement = item.getParentItem().getText().toUpperCase();
            String rootElementType = item.getParentItem().getText();
            String propagationType = StringUtils.substringBetween((String)item.getText(), (String)"(", (String)")");
            if (preferenceMap.containsKey(parentItemElement)) {
                this.setCheckboxSelection(preferenceMap, checkboxButton, parentItemElement, propagationType);
                if (item.getParentItem().getParentItem().getText().equalsIgnoreCase("Variables")) {
                    rootElementType = item.getParentItem().getParentItem().getText();
                }
            }
            if (propagationType == null) {
                propagationType = "Actual";
            }
            checkboxButton.setData(METADATA_TYPE, (Object)metadataType);
            checkboxButton.setData(ACTUAL_EXPECTED, (Object)propagationType);
            checkboxButton.setData(ELEMENT_NAME, (Object)parentItemElement);
            checkboxButton.setData(ROOT_TYPE, (Object)rootElementType);
            checkboxButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleCheckboxCheck((Button)e.getSource())));
        }
        for (TreeItem child : Arrays.asList(item.getItems())) {
            this.iterateItem(child, tree, preferenceMap, metadataType);
        }
    }

    private void setCheckboxSelection(Map<String, MetadataActualExpectedSelectionType> preferenceMap, Button checkboxButton, String parentItemElement, String propagationType) {
        if (StringUtils.isEmpty((String)propagationType) || !StringUtils.isEmpty((String)propagationType) && preferenceMap.get(parentItemElement).getMetadataActualExpectedPreference().equalsIgnoreCase(propagationType)) {
            checkboxButton.setSelection(true);
        }
    }

    private void refreshCheckboxes(Composite composite, Map<String, Map<String, MetadataActualExpectedSelectionType>> map) {
        ArrayList childs = new ArrayList();
        Arrays.asList(composite.getChildren()).forEach(container -> childs.addAll(Arrays.asList(((Composite)container).getChildren())));
        childs.forEach(child -> {
            Button btn = (Button)child;
            btn.setSelection(false);
            String metadataType = btn.getData(METADATA_TYPE).toString();
            String actualExpected = btn.getData(ACTUAL_EXPECTED) != null ? btn.getData(ACTUAL_EXPECTED).toString() : null;
            String elementName = btn.getData(ELEMENT_NAME).toString();
            ((Map)map.get(metadataType)).keySet().forEach(key -> {
                if (key.equalsIgnoreCase(elementName) && (actualExpected == null || ((MetadataActualExpectedSelectionType)((Map)map.get(metadataType)).get(key)).getMetadataActualExpectedPreference().equalsIgnoreCase(actualExpected))) {
                    btn.setSelection(Boolean.TRUE.booleanValue());
                }
            });
        });
    }

    private void handleCheckboxCheck(Button button) {
        String metadataType = button.getData(METADATA_TYPE).toString();
        String actualExpected = button.getData(ACTUAL_EXPECTED) != null ? button.getData(ACTUAL_EXPECTED).toString() : null;
        String elementName = button.getData(ELEMENT_NAME).toString();
        String rootType = button.getData(ROOT_TYPE).toString();
        MetadataActualExpectedSelectionType propagationType = button.getSelection() ? MetadataActualExpectedSelectionType.find((String)actualExpected) : MetadataActualExpectedSelectionType.NONE;
        List preferenceInput = this.propagationPreference.findMetadataPreference(rootType, metadataType);
        preferenceInput.forEach(pref -> {
            if (pref.getElementName().equalsIgnoreCase(elementName)) {
                pref.setMetadataSelectionType(propagationType);
            }
        });
        this.refreshCheckboxes(button.getParent().getParent(), this.buildPreferenceMap(this.propagationPreference));
    }

    private Map<String, Map<String, MetadataActualExpectedSelectionType>> buildPreferenceMap(MetadataActualExpectedParametersContainer propagationPreference) {
        HashMap<String, MetadataActualExpectedSelectionType> preferenceMapInput = new HashMap<String, MetadataActualExpectedSelectionType>();
        preferenceMapInput.put(propagationPreference.getInputAttributesPreference().getElementName().toUpperCase(), propagationPreference.getInputAttributesPreference().getMetadataSelectionType());
        preferenceMapInput.put(propagationPreference.getInputPayloadPreference().getElementName().toUpperCase(), propagationPreference.getInputPayloadPreference().getMetadataSelectionType());
        for (MetadataActualExpectedPreference preference : propagationPreference.getInputVariablesPreferences()) {
            preferenceMapInput.put(preference.getElementName().toUpperCase(), preference.getMetadataSelectionType());
        }
        HashMap<String, MetadataActualExpectedSelectionType> preferenceMapOutput = new HashMap<String, MetadataActualExpectedSelectionType>();
        preferenceMapOutput.put(propagationPreference.getOutputAttributesPreference().getElementName().toUpperCase(), propagationPreference.getOutputAttributesPreference().getMetadataSelectionType());
        preferenceMapOutput.put(propagationPreference.getOutputPayloadPreference().getElementName().toUpperCase(), propagationPreference.getOutputPayloadPreference().getMetadataSelectionType());
        for (MetadataActualExpectedPreference preference : propagationPreference.getOutputVariablesPreferences()) {
            preferenceMapOutput.put(preference.getElementName().toUpperCase(), preference.getMetadataSelectionType());
        }
        HashMap<String, Map<String, MetadataActualExpectedSelectionType>> preferences = new HashMap<String, Map<String, MetadataActualExpectedSelectionType>>();
        preferences.put(INPUT, preferenceMapInput);
        preferences.put(OUTPUT, preferenceMapOutput);
        return preferences;
    }

    public void setTabSelectionToZero() {
        this.inputMetadataViewer.setSelection(0);
        this.outputMetadataViewer.setSelection(0);
    }

    public MetadataActualExpectedParametersContainer getPropagationPreference() {
        return this.propagationPreference;
    }
}

