/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.metadata;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.messageflow.metadata.ComparableMetadataTypeGraphicalChildrenProvider;
import org.mule.tooling.metadata.datasense.MetadataPair;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.ui.widgets.tree.model.IGraphicalChildrenProvider;

public class MetadataVariablesGraphicalChildrenProvider
implements IGraphicalChildrenProvider<MetadataPair<ObjectType, ObjectType>> {
    public List<GraphicalTreeNode<?>> getChildren(GraphicalTreeNode<MetadataPair<ObjectType, ObjectType>> parent) {
        ArrayList children = new ArrayList();
        MetadataPair variablesMetadataPair = (MetadataPair)parent.getModel();
        ObjectType actualVariables = (ObjectType)variablesMetadataPair.getActual();
        ObjectType expectedVariables = (ObjectType)variablesMetadataPair.getExpected();
        List variables = Stream.concat(actualVariables.getFields().stream(), expectedVariables.getFields().stream()).filter(this.distinctByKey(field -> field.getKey().getName())).collect(Collectors.toList());
        for (ObjectFieldType variable : variables) {
            String name = variable.getKey().getName().getLocalPart();
            Optional maybeActualVariable = actualVariables.getFieldByName(name);
            Optional maybeExpectedVariable = expectedVariables.getFieldByName(name);
            MetadataType actualVariable = maybeActualVariable.isPresent() ? ((ObjectFieldType)maybeActualVariable.get()).getValue() : MetadataFactory.undefined();
            MetadataType expectedVariable = maybeExpectedVariable.isPresent() ? ((ObjectFieldType)maybeExpectedVariable.get()).getValue() : MetadataFactory.undefined();
            MetadataPair variableMetadataPair = new MetadataPair((Object)actualVariable, (Object)expectedVariable);
            children.add(new GraphicalTreeNode(name, name, (Object)variableMetadataPair, (IGraphicalChildrenProvider)new ComparableMetadataTypeGraphicalChildrenProvider()));
        }
        return children;
    }

    public <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        HashSet seen = new HashSet();
        return t -> seen.add(keyExtractor.apply(t));
    }
}

