/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.tooling.client.metadata.MetadataTypeHelper;
import org.mule.tooling.messageflow.metadata.MetadataFieldObjectTypeGraphicalChildrenProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNodeComparator;
import org.mule.tooling.ui.widgets.tree.model.IGraphicalChildrenProvider;

public class MetadataTypeGraphicalChildrenProvider
implements IGraphicalChildrenProvider<MetadataType> {
    private boolean isSortNeeded;

    public MetadataTypeGraphicalChildrenProvider() {
        this(false);
    }

    public MetadataTypeGraphicalChildrenProvider(boolean isSortNeeded) {
        this.isSortNeeded = isSortNeeded;
    }

    public List<GraphicalTreeNode<?>> getChildren(GraphicalTreeNode<MetadataType> parent) {
        MetadataType model = (MetadataType)parent.getModel();
        return MetadataTypeGraphicalChildrenProvider.getChildren(parent, model, this.isSortNeeded);
    }

    public static List<GraphicalTreeNode<?>> getChildren(GraphicalTreeNode<?> parent, MetadataType model, boolean isSortNeeded) {
        ArrayList result = new ArrayList();
        if (model != null) {
            DefaultMetadataTypeVisitor visitor = new DefaultMetadataTypeVisitor(parent, result, isSortNeeded);
            model.accept((MetadataTypeVisitor)visitor);
        }
        if (isSortNeeded) {
            Collections.sort(result, new GraphicalTreeNodeComparator());
        }
        return result;
    }

    private static class DefaultMetadataTypeVisitor
    extends MetadataTypeVisitor {
        private boolean isSortNeeded;
        private GraphicalTreeNode<?> parent;
        private List<GraphicalTreeNode<?>> result;

        public DefaultMetadataTypeVisitor(GraphicalTreeNode<?> parent, List<GraphicalTreeNode<?>> result, boolean isSortNeeded) {
            this.parent = parent;
            this.result = result;
            this.isSortNeeded = isSortNeeded;
        }

        public void visitArrayType(ArrayType arrayType) {
            Optional<MetadataType> type = Optional.ofNullable(arrayType.getType());
            if (type.isPresent()) {
                this.result.addAll(MetadataTypeGraphicalChildrenProvider.getChildren(this.parent, type.get(), this.isSortNeeded));
            }
        }

        public void visitObjectField(ObjectFieldType objectFieldType) {
            if (!objectFieldType.getKey().isPattern()) {
                this.result.add(new GraphicalTreeNode(this.parent, MetadataTypeHelper.getModelLabel((MetadataType)objectFieldType), MetadataTypeHelper.getDescription((MetadataType)objectFieldType), (Object)objectFieldType, (IGraphicalChildrenProvider)new MetadataFieldObjectTypeGraphicalChildrenProvider(this.isSortNeeded)));
            }
        }

        public void visitObject(ObjectType objectType) {
            for (ObjectFieldType objectFieldType : objectType.getFields()) {
                objectFieldType.accept((MetadataTypeVisitor)this);
            }
        }

        public void visitUnion(UnionType unionType) {
            for (MetadataType type : unionType.getTypes()) {
                type.accept((MetadataTypeVisitor)this);
            }
        }

        public void visitIntersection(IntersectionType intersectionType) {
            for (MetadataType type : intersectionType.getTypes()) {
                type.accept((MetadataTypeVisitor)this);
            }
        }
    }
}

