/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.metadata;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.UIJob;
import org.mule.tooling.client.api.PropagationInfo;
import org.mule.tooling.client.metadata.MetadataEvent;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.messageflow.metadata.MetadataEventGraphicalChildrenProvider;
import org.mule.tooling.messageflow.metadata.MetadataFilteredTree;
import org.mule.tooling.messageflow.metadata.MetadataPropagationRefreshRequestedEvent;
import org.mule.tooling.metadata.datasense.MetadataPair;
import org.mule.tooling.ui.widgets.search.LimitedLevelPatternFilter;
import org.mule.tooling.ui.widgets.tree.StudioFilteredTree;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeContentProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeLabelProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.ui.widgets.tree.model.IGraphicalChildrenProvider;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEvent;

public class MetadataTreeExplorer
extends Composite {
    private static final int MAX_RECURSION_LEVEL = 16;
    private static final int DEFAULT_EXPAND_LEVEL = 3;
    private MetadataFilteredTree inputMetadataTree;
    private MetadataFilteredTree outputMetadataTree;
    private Link refreshMetadataLink;
    private EventBusHelper eventBusHelper;
    private Composite editorComposite;
    private static final IGraphicalChildrenProvider<String> LOADING_CHILDREN_PROVIDER = new LoadingChildrenProvider();
    private static final GraphicalTreeNode<String> LOADING_METADATA_NODE = new GraphicalTreeNode("Loading Metadata", "Loading Metadata", null, LOADING_CHILDREN_PROVIDER);

    public MetadataTreeExplorer(Composite parent, int style) {
        super(parent, style);
        this.setBackgroundMode(2);
        this.eventBusHelper = new EventBusHelper();
        GridLayoutFactory.swtDefaults().numColumns(1).margins(0, 0).spacing(0, 0).equalWidth(false).applyTo((Composite)this);
        this.createControl(this);
        this.addDisposeListener(e -> this.controlDisposed());
    }

    protected void createControl(Composite parent) {
        this.editorComposite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(1).margins(0, 0).spacing(0, 0).equalWidth(false).applyTo(this.editorComposite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.editorComposite);
        CTabFolder metadataViewer = new CTabFolder(this.editorComposite, 0);
        metadataViewer.setLayoutData((Object)new GridData(1808));
        metadataViewer.setBorderVisible(true);
        this.inputMetadataTree = new MetadataFilteredTree((Composite)metadataViewer, 66304, (PatternFilter)new LimitedLevelPatternFilter(16));
        GraphicalTreeLabelProvider inputMetadataTreeLabelProvider = new GraphicalTreeLabelProvider();
        this.inputMetadataTree.getViewer().setLabelProvider((IBaseLabelProvider)inputMetadataTreeLabelProvider);
        this.inputMetadataTree.getViewer().setContentProvider((IContentProvider)new GraphicalTreeContentProvider(16));
        this.inputMetadataTree.setBackgroundMode(2);
        this.inputMetadataTree.setLayoutData(new GridData(1808));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.inputMetadataTree.getViewer());
        CTabItem inputTab = new CTabItem(metadataViewer, 2048);
        inputTab.setText("Input");
        inputTab.setControl((Control)this.inputMetadataTree);
        this.outputMetadataTree = new MetadataFilteredTree((Composite)metadataViewer, 66304, (PatternFilter)new LimitedLevelPatternFilter(16));
        GraphicalTreeLabelProvider outputMetadataTreeLabelProvider = new GraphicalTreeLabelProvider();
        this.outputMetadataTree.getViewer().setLabelProvider((IBaseLabelProvider)outputMetadataTreeLabelProvider);
        this.outputMetadataTree.getViewer().setContentProvider((IContentProvider)new GraphicalTreeContentProvider(16));
        this.outputMetadataTree.setBackgroundMode(2);
        this.outputMetadataTree.setLayoutData(new GridData(1808));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.inputMetadataTree.getViewer());
        CTabItem outputTab = new CTabItem(metadataViewer, 2048);
        outputTab.setText("Output");
        outputTab.setControl((Control)this.outputMetadataTree);
        metadataViewer.setSelection(0);
    }

    public StudioFilteredTree getTree() {
        return this.inputMetadataTree;
    }

    public void unregisterFromEvents() {
        this.eventBusHelper.unregister();
    }

    private void controlDisposed() {
        this.unregisterFromEvents();
    }

    public GraphicalTreeNode<MetadataPair<MetadataEvent, MetadataEvent>> getInput() {
        return (GraphicalTreeNode)this.inputMetadataTree.getViewer().getInput();
    }

    public GraphicalTreeNode<MetadataPair<MetadataEvent, MetadataEvent>> getOutput() {
        return (GraphicalTreeNode)this.outputMetadataTree.getViewer().getInput();
    }

    protected GraphicalTreeNode<MetadataPair<MetadataEvent, MetadataEvent>> createGraphicalTreeNode(MetadataPair<MetadataEvent, MetadataEvent> metadataPair) {
        return new GraphicalTreeNode(null, null, null, (IGraphicalChildrenProvider)new MetadataEventGraphicalChildrenProvider(metadataPair));
    }

    public void enableOrDisableRefreshLink() {
        UIJob uiJob = new UIJob("Checking metadata status..."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!MetadataTreeExplorer.this.editorComposite.isDisposed()) {
                    boolean linkEnabled = MetadataTreeExplorer.this.configRefUsesMetadata();
                    if (linkEnabled) {
                        if (MetadataTreeExplorer.this.refreshMetadataLink == null) {
                            MetadataTreeExplorer.this.refreshMetadataLink = new Link(MetadataTreeExplorer.this.editorComposite, 0);
                            MetadataTreeExplorer.this.refreshMetadataLink.setText("<A>Refresh Metadata</A>");
                            MetadataTreeExplorer.this.refreshMetadataLink.setToolTipText("Refreshes the input and output structures this message processor receives. (Requires DataSense enabled in the connector configuration and a properly configured connector)");
                            MetadataTreeExplorer.this.refreshMetadataLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent e) {
                                    MuleCorePlugin.getEventBus().fireEvent((IEvent)new MetadataPropagationRefreshRequestedEvent());
                                }
                            });
                            GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, false).applyTo((Control)MetadataTreeExplorer.this.refreshMetadataLink);
                            MetadataTreeExplorer.this.refreshMetadataLink.setEnabled(true);
                            MetadataTreeExplorer.this.editorComposite.layout();
                        } else {
                            MetadataTreeExplorer.this.refreshMetadataLink.setEnabled(linkEnabled);
                        }
                    } else if (MetadataTreeExplorer.this.refreshMetadataLink != null) {
                        MetadataTreeExplorer.this.refreshMetadataLink.dispose();
                        MetadataTreeExplorer.this.refreshMetadataLink = null;
                        MetadataTreeExplorer.this.editorComposite.layout();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        uiJob.setPriority(20);
        uiJob.schedule();
    }

    private boolean configRefUsesMetadata() {
        return true;
    }

    public void showLoadingIndicator() {
        this.showLoadingIndicatorFor(this.inputMetadataTree);
        this.showLoadingIndicatorFor(this.outputMetadataTree);
    }

    private void showLoadingIndicatorFor(MetadataFilteredTree filteredTree) {
        TreeViewer viewer = filteredTree.getViewer();
        filteredTree.hideToolBar();
        viewer.setInput(LOADING_METADATA_NODE);
        viewer.refresh();
        filteredTree.update();
    }

    public void updateMetadata(PropagationInfo propagationInfo) {
        if (!(this.isDisposed() || this.inputMetadataTree.isDisposed() || this.outputMetadataTree.isDisposed())) {
            MetadataEvent actualInputMetadata = propagationInfo.isFlow() ? propagationInfo.getExpectedMetadataType() : propagationInfo.getIncomingMetadataType();
            MetadataEvent expectedInputMetadata = propagationInfo.isFlow() ? propagationInfo.getInputMetadataType() : propagationInfo.getExpectedInputMetadataType();
            MetadataEvent actualOutputMetadata = propagationInfo.isFlow() ? propagationInfo.getIncomingMetadataType() : propagationInfo.getResultMetadataType();
            MetadataEvent expectedOutputMetadata = propagationInfo.isFlow() ? propagationInfo.getOutputMetadataType() : propagationInfo.getExpectedMetadataType();
            this.inputMetadataTree.setPropagationInfo(propagationInfo);
            this.outputMetadataTree.setPropagationInfo(propagationInfo);
            MetadataPair inputMetadataPair = new MetadataPair((Object)actualInputMetadata, (Object)expectedInputMetadata);
            this.inputMetadataTree.getViewer().setInput(this.createGraphicalTreeNode((MetadataPair<MetadataEvent, MetadataEvent>)inputMetadataPair));
            this.inputMetadataTree.getViewer().expandToLevel(3);
            MetadataPair outputMetadataPair = new MetadataPair((Object)actualOutputMetadata, (Object)expectedOutputMetadata);
            this.outputMetadataTree.getViewer().setInput(this.createGraphicalTreeNode((MetadataPair<MetadataEvent, MetadataEvent>)outputMetadataPair));
            this.outputMetadataTree.getViewer().expandToLevel(3);
            this.enableOrDisableRefreshLink();
        }
    }

    private static final class LoadingChildrenProvider
    implements IGraphicalChildrenProvider<String> {
        private LoadingChildrenProvider() {
        }

        public List<GraphicalTreeNode<?>> getChildren(GraphicalTreeNode<String> parent) {
            return Arrays.asList(new GraphicalTreeNode("Loading metadata...", "Propagation is running, please wait until the propagation finishes", (Object)"Loading metadata", null));
        }
    }
}

