/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.metadata;

import java.util.Arrays;
import java.util.List;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.metadata.MetadataMessage;
import org.mule.tooling.messageflow.metadata.ComparableMetadataTypeGraphicalChildrenProvider;
import org.mule.tooling.metadata.datasense.MetadataPair;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.ui.widgets.tree.model.IGraphicalChildrenProvider;

public class MetadataMessageGraphicalChildrenProvider
implements IGraphicalChildrenProvider<MetadataPair<MetadataMessage, MetadataMessage>> {
    private static final String PAYLOAD = "Payload";
    private static final String PAYLOAD_DESCRIPTION = "The most important part of the Mule message because it contains the data your Mule application processes";
    private static final String ATTRIBUTES = "Attributes";
    private static final String ATTRIBUTES_DESCRIPTION = "Attributes are related to payload content";

    public List<GraphicalTreeNode<?>> getChildren(GraphicalTreeNode<MetadataPair<MetadataMessage, MetadataMessage>> parent) {
        MetadataPair messageMetadataPair = (MetadataPair)parent.getModel();
        MetadataMessage actualMetadataMessage = (MetadataMessage)messageMetadataPair.getActual();
        MetadataMessage expectedMetadataMessage = (MetadataMessage)messageMetadataPair.getExpected();
        MetadataType actualPayload = actualMetadataMessage.getPayload();
        MetadataType expectedPayload = expectedMetadataMessage.getPayload();
        MetadataPair payloadMetadataPair = new MetadataPair((Object)actualPayload, (Object)expectedPayload);
        GraphicalTreeNode payload = new GraphicalTreeNode(PAYLOAD, PAYLOAD_DESCRIPTION, (Object)payloadMetadataPair, (IGraphicalChildrenProvider)new ComparableMetadataTypeGraphicalChildrenProvider());
        MetadataType actualAttributes = actualMetadataMessage.getAttributes();
        MetadataType expectedAttributes = expectedMetadataMessage.getAttributes();
        MetadataPair attributesMetadataPair = new MetadataPair((Object)actualAttributes, (Object)expectedAttributes);
        GraphicalTreeNode attributes = new GraphicalTreeNode(ATTRIBUTES, ATTRIBUTES_DESCRIPTION, (Object)attributesMetadataPair, (IGraphicalChildrenProvider)new ComparableMetadataTypeGraphicalChildrenProvider());
        return Arrays.asList(payload, attributes);
    }
}

