/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.metadata;

import java.util.ArrayList;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PatternFilter;
import org.mule.tooling.client.api.ComponentDataSenseNotification;
import org.mule.tooling.client.api.IComponentPath;
import org.mule.tooling.client.api.PropagationInfo;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.events.ChangeEditPartRequestedEvent;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.ui.widgets.WidgetsImages;
import org.mule.tooling.ui.widgets.errors.DefaultErrorListProvider;
import org.mule.tooling.ui.widgets.errors.ErrorItem;
import org.mule.tooling.ui.widgets.errors.ErrorListDialog;
import org.mule.tooling.ui.widgets.errors.ErrorType;
import org.mule.tooling.ui.widgets.errors.IErrorListProvider;
import org.mule.tooling.ui.widgets.menu.IContextMenuProvider;
import org.mule.tooling.ui.widgets.tree.StudioFilteredTree;
import org.mule.tooling.ui.widgets.util.WidgetUtils;
import org.mule.tooling.utils.eventbus.IEvent;

public class MetadataFilteredTree
extends StudioFilteredTree {
    private ToolBarManager toolBarManager;
    private PropagationInfo propagationInfo;
    private ErrorListDialog errorDialog;
    private DataSenseErrorAction dataSenseErrorAction;
    private static final String FIRST_COLUMN_NAME = "Message";

    public MetadataFilteredTree(Composite parent, int treeStyle, PatternFilter filter) {
        super(parent, treeStyle, filter);
    }

    public void hideToolBar() {
        this.toolBarManager.getControl().setVisible(false);
    }

    public void setPropagationInfo(PropagationInfo propagationInfo) {
        this.propagationInfo = propagationInfo;
        boolean hasErrorsOrWarningsInCurrentComponent = this.hasErrorsOrWarningsInCurrentComponent();
        if (hasErrorsOrWarningsInCurrentComponent) {
            this.dataSenseErrorAction.setImageDescriptor(this.getImageDescriptor());
        }
        this.toolBarManager.getControl().setVisible(hasErrorsOrWarningsInCurrentComponent);
    }

    private ImageDescriptor getImageDescriptor() {
        if (this.propagationInfo.getNotifcations().stream().anyMatch(ComponentDataSenseNotification::isError)) {
            return WidgetsImages.getImageDescriptor((String)"icons/errors/error.png");
        }
        return WidgetsImages.getImageDescriptor((String)"icons/errors/warning.png");
    }

    private boolean hasErrorsOrWarningsInCurrentComponent() {
        IComponentPath componentPath = this.propagationInfo.getComponentPath();
        return this.propagationInfo.hasErrorsOrWarnings() && this.propagationInfo.getNotifcations().stream().filter(x -> x.isError() || x.isWarning()).anyMatch(x -> x.getComponentPath().map(cp -> cp.equals(componentPath)).orElse(false));
    }

    protected Composite createFilterControls(Composite parent) {
        Composite bar = new Composite(parent, 0);
        bar.setLayout((Layout)new WidgetUtils().createNoBorderGridLayout(3, false));
        this.createToolBar(bar);
        Composite createFilterControls = super.createFilterControls(bar);
        createFilterControls.setLayoutData((Object)new GridData(768));
        return bar;
    }

    private void createToolBar(Composite parent) {
        ToolBar toolBar = new ToolBar(parent, 0);
        this.toolBarManager = new ToolBarManager(toolBar);
        this.dataSenseErrorAction = new DataSenseErrorAction();
        this.toolBarManager.add((IAction)this.dataSenseErrorAction);
        this.toolBarManager.update(true);
        this.dataSenseErrorAction.setEnabled(true);
        this.toolBarManager.getControl().setVisible(false);
    }

    public boolean isToolBarVisible() {
        return this.toolBarManager.getControl().isVisible();
    }

    private final class DataSenseContextMenuProvider
    implements IContextMenuProvider<ErrorItem> {
        private DataSenseContextMenuProvider() {
        }

        public void addActions(IMenuManager manager, Optional<ErrorItem> maybeSelectedElement) {
            if (maybeSelectedElement.isPresent()) {
                ErrorItem errorItem = maybeSelectedElement.get();
                GoToAction goToAction = new GoToAction(errorItem.getLocation());
                goToAction.setEnabled(StringUtils.isNotBlank((CharSequence)errorItem.getLocation()));
                manager.add((IAction)goToAction);
            }
        }
    }

    private final class DataSenseErrorAction
    extends Action {
        private DataSenseErrorAction() {
            super("DataSense Errors/Warnings", 0);
            this.setImageDescriptor(WidgetsImages.getImageDescriptor((String)"icons/errors/error.png"));
        }

        public void run() {
            ArrayList<ErrorItem> issues = new ArrayList<ErrorItem>();
            for (ComponentDataSenseNotification propagationNotification : MetadataFilteredTree.this.propagationInfo.getNotifcations()) {
                if (!propagationNotification.isError() && !propagationNotification.isWarning()) continue;
                Optional maybeComponentPath = propagationNotification.getComponentPath();
                ErrorItem.ErrorItemBuilder builder = new ErrorItem.ErrorItemBuilder().withErrorType(propagationNotification.isError() ? ErrorType.ERROR : ErrorType.WARNING).withTitle(propagationNotification.getMessage()).withDescription(propagationNotification.getReason());
                if (maybeComponentPath.isPresent()) {
                    builder.withLocation(((IComponentPath)maybeComponentPath.get()).toPath());
                }
                issues.add(builder.build());
            }
            MetadataFilteredTree.this.errorDialog = new ErrorListDialog(Display.getCurrent().getActiveShell(), (IErrorListProvider)new DefaultErrorListProvider(issues), (IContextMenuProvider)new DataSenseContextMenuProvider());
            MetadataFilteredTree.this.errorDialog.setShowFirstColumnOnly(true);
            MetadataFilteredTree.this.errorDialog.setFirstColumnName(MetadataFilteredTree.FIRST_COLUMN_NAME);
            MetadataFilteredTree.this.errorDialog.open();
        }
    }

    private final class GoToAction
    extends Action {
        private String componentPath;

        public GoToAction(String componentPath) {
            super("Go to", 0);
            this.componentPath = componentPath;
            this.setImageDescriptor(WidgetsImages.getImageDescriptor((String)"icons/goto.gif"));
        }

        public void run() {
            IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (activeWorkbenchWindow == null) {
                return;
            }
            IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
            IEditorPart activeEditor = activePage.getActiveEditor();
            if (activeEditor instanceof MultiPageMessageFlowEditor) {
                MultiPageMessageFlowEditor editorPart = (MultiPageMessageFlowEditor)activeEditor;
                MessageFlowEditor flowEditor = editorPart.getFlowEditor();
                MessageFlowEntity entityForMulePath = MessageFlowUtils.findEntityForMulePathInOpenEditors(this.componentPath, null);
                EntityEditPart<?> editPart = MessageFlowEditor.findEditPartInRegistry((EditPartViewer)flowEditor.getViewer(), (IMessageFlowEntity)entityForMulePath);
                MuleCorePlugin.getEventBus().fireEvent((IEvent)new ChangeEditPartRequestedEvent(editPart));
                MetadataFilteredTree.this.errorDialog.close();
            }
        }
    }
}

