/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.metadata;

import java.util.ArrayList;
import java.util.List;
import org.mule.metadata.api.model.ObjectType;
import org.mule.tooling.client.metadata.MetadataEvent;
import org.mule.tooling.client.metadata.MetadataMessage;
import org.mule.tooling.messageflow.metadata.MetadataMessageGraphicalChildrenProvider;
import org.mule.tooling.messageflow.metadata.MetadataVariablesGraphicalChildrenProvider;
import org.mule.tooling.metadata.datasense.MetadataPair;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.ui.widgets.tree.model.IGraphicalChildrenProvider;

public class MetadataEventGraphicalChildrenProvider
implements IGraphicalChildrenProvider<MetadataPair<MetadataEvent, MetadataEvent>> {
    private static final String MULE_MESSAGE = "Mule Message";
    private static final String MULE_VARIABLES = "Variables";
    private static final String MULE_MESSAGE_DESCRIPTION = "The message contains the payload data from the Mule Event";
    private static final String MULE_VARIABLES_DESCRIPTION = "Are inmutable, they are copied to the next Mule Event";
    private MetadataPair<MetadataEvent, MetadataEvent> root;

    public MetadataEventGraphicalChildrenProvider(MetadataPair<MetadataEvent, MetadataEvent> root) {
        this.root = root;
    }

    public List<GraphicalTreeNode<?>> getChildren(GraphicalTreeNode<MetadataPair<MetadataEvent, MetadataEvent>> parent) {
        ArrayList nodes = new ArrayList();
        MetadataEvent actualMetadataEvent = (MetadataEvent)this.root.getActual();
        MetadataEvent expectedMetadataEvent = (MetadataEvent)this.root.getExpected();
        MetadataMessage actualMetadataMessage = actualMetadataEvent.getMessage();
        MetadataMessage expectedMetadataMessage = expectedMetadataEvent.getMessage();
        ObjectType actualVariables = actualMetadataEvent.getVariables();
        ObjectType expectedVariables = expectedMetadataEvent.getVariables();
        MetadataPair messageMetadataPair = new MetadataPair((Object)actualMetadataMessage, (Object)expectedMetadataMessage);
        GraphicalTreeNode message = new GraphicalTreeNode(MULE_MESSAGE, MULE_MESSAGE_DESCRIPTION, (Object)messageMetadataPair, (IGraphicalChildrenProvider)new MetadataMessageGraphicalChildrenProvider());
        nodes.add(message);
        MetadataPair variablesMetadataPair = new MetadataPair((Object)actualVariables, (Object)expectedVariables);
        GraphicalTreeNode variables = new GraphicalTreeNode(MULE_VARIABLES, MULE_VARIABLES_DESCRIPTION, (Object)variablesMetadataPair, (IGraphicalChildrenProvider)new MetadataVariablesGraphicalChildrenProvider());
        nodes.add(variables);
        return nodes;
    }
}

