/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class FilteredCheckboxTree
extends FilteredTree {
    public FilteredCheckboxTree(Composite parent, int treeStyle, PatternFilter filter) {
        super(parent, treeStyle, filter, false, false);
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        return new FilterableCheckboxTreeViewer(parent, 770);
    }

    protected void createControl(Composite parent, int treeStyle) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        if (parent.getLayout() instanceof GridLayout) {
            this.setLayoutData(new GridData(4, 4, true, true));
        }
        this.treeComposite = new Composite((Composite)this, 0);
        GridLayout treeCompositeLayout = new GridLayout();
        treeCompositeLayout.marginHeight = 0;
        treeCompositeLayout.marginWidth = 0;
        this.treeComposite.setLayout((Layout)treeCompositeLayout);
        GridData data = new GridData(4, 4, true, true);
        data.verticalIndent = 0;
        data.verticalSpan = 2;
        this.treeComposite.setLayoutData((Object)data);
        this.createTreeControl(this.treeComposite, treeStyle);
    }

    public class FilterableCheckboxTreeViewer
    extends TreeViewer {
        static final String NONE = "none";
        static final String CHECKED = "checked";
        static final String GREYED = "greyed";
        static final String CHECKED_GREYED = "checked_greyed";
        Map<Object, FilteredCheckboxTreeItem> itemCache;
        List<Object> refreshingListeners;

        protected void createTreeItem(Widget parent, Object element, int index) {
            Item item = this.newItem(parent, 0, index);
            this.updateItem((Widget)item, element);
            this.updatePlus(item, element);
        }

        protected void unmapAllElements() {
            this.itemCache = new HashMap<Object, FilteredCheckboxTreeItem>();
            super.unmapAllElements();
        }

        public FilterableCheckboxTreeViewer(Composite parent, int style) {
            super(parent, style);
            this.itemCache = new HashMap<Object, FilteredCheckboxTreeItem>();
            this.refreshingListeners = new ArrayList<Object>();
        }

        protected void preservingSelection(Runnable updateCode) {
            super.preservingSelection(updateCode);
            ArrayList<TreeItem> allTreeItems = this.getAllTreeItems(FilteredCheckboxTree.this.treeViewer.getTree().getItems());
            for (TreeItem item : allTreeItems) {
                this.doApplyCheckedState((Item)item, item.getData());
            }
        }

        protected void internalRefresh(Object element, boolean updateLabels) {
            String text = FilteredCheckboxTree.this.getFilterString();
            boolean initial = FilteredCheckboxTree.this.initialText != null && FilteredCheckboxTree.this.initialText.equals(text);
            boolean filtered = text != null && text.length() > 0 && !initial;
            for (PreRefreshNotifier preRefreshNotifier : this.refreshingListeners) {
                preRefreshNotifier.preRefresh(this, filtered);
            }
            this.saveCheckedState();
            super.internalRefresh(element, updateLabels);
            FilteredCheckboxTree.this.treeViewer.expandAll();
        }

        private void doApplyCheckedState(Item item, Object element) {
            super.doUpdateItem(item, element);
            TreeItem treeItem = (TreeItem)item;
            if (this.itemCache.containsKey(element)) {
                String state = this.itemCache.get((Object)element).state;
                if (state.equals(CHECKED_GREYED)) {
                    treeItem.setGrayed(true);
                    treeItem.setChecked(true);
                } else if (state.equals(CHECKED)) {
                    treeItem.setChecked(true);
                    treeItem.setGrayed(false);
                } else if (state.equals(GREYED)) {
                    treeItem.setGrayed(true);
                    treeItem.setChecked(false);
                } else {
                    treeItem.setGrayed(false);
                    treeItem.setChecked(false);
                }
            }
        }

        private ArrayList<TreeItem> getAllTreeItems(TreeItem[] roots) {
            ArrayList<TreeItem> list = new ArrayList<TreeItem>();
            int i = 0;
            while (i < roots.length) {
                TreeItem item = roots[i];
                list.add(item);
                list.addAll(this.getAllTreeItems(item.getItems()));
                ++i;
            }
            return list;
        }

        private void saveCheckedState() {
            TreeItem[] items = FilteredCheckboxTree.this.treeViewer.getTree().getItems();
            int i = 0;
            while (i < items.length) {
                TreeItem item = items[i];
                if (!this.itemCache.containsKey(item.getData())) {
                    new FilteredCheckboxTreeItem(item.getData(), this.getItemState(item), this.itemCache, null);
                }
                FilteredCheckboxTreeItem filteredCheckboxTreeItem = this.itemCache.get(item.getData());
                filteredCheckboxTreeItem.state = this.getItemState(item);
                this.saveCheckedState(filteredCheckboxTreeItem, item);
                ++i;
            }
        }

        private void saveCheckedState(FilteredCheckboxTreeItem parent, TreeItem parentItem) {
            TreeItem[] items = parentItem.getItems();
            int i = 0;
            while (i < items.length) {
                TreeItem item = items[i];
                if (!this.itemCache.containsKey(item.getData())) {
                    new FilteredCheckboxTreeItem(item.getData(), this.getItemState(item), this.itemCache, parent);
                }
                FilteredCheckboxTreeItem filteredCheckboxTreeItem = this.itemCache.get(item.getData());
                filteredCheckboxTreeItem.state = this.getItemState(item);
                this.saveCheckedState(filteredCheckboxTreeItem, item);
                ++i;
            }
        }

        private String getItemState(TreeItem item) {
            if (item.getChecked() && item.getGrayed()) {
                return CHECKED_GREYED;
            }
            if (item.getChecked()) {
                return CHECKED;
            }
            if (item.getGrayed()) {
                return GREYED;
            }
            return NONE;
        }

        class FilteredCheckboxTreeItem {
            Object data;
            String state;
            List<FilteredCheckboxTreeItem> children = new ArrayList<FilteredCheckboxTreeItem>();

            public FilteredCheckboxTreeItem(Object data, String state, Map itemCache, FilteredCheckboxTreeItem parent) {
                this.data = data;
                this.state = state;
                itemCache.put(data, this);
                if (parent != null) {
                    parent.children.add(this);
                }
            }
        }
    }

    static interface PreRefreshNotifier {
        public void preRefresh(FilterableCheckboxTreeViewer var1, boolean var2);
    }
}

