/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.layout;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.mule.tooling.messageflow.figure.IResponseFigure;
import org.mule.tooling.messageflow.figure.NestedContainerFigure;
import org.mule.tooling.messageflow.layout.FlowDimensions;
import org.mule.tooling.messageflow.layout.FlowDimensionsAware;
import org.mule.tooling.messageflow.layout.FlowDimensionsCalculator;

public class FlowProcessLayout
extends AbstractLayout
implements FlowDimensionsAware {
    protected static final int INTER_NODE_SPACING = 35;
    private FlowDimensions flowDimensions;

    public void layout(IFigure nestedContainer) {
        List<? extends IFigure> flowChildren = FlowProcessLayout.collectFlowChildren(nestedContainer);
        FlowDimensionsCalculator calculator = FlowDimensionsCalculator.getInstance();
        FlowDimensions dimensions = calculator.calculate(flowChildren);
        this.setFlowDimensions(dimensions);
        int xOffset = 0;
        List<? extends IFigure> processChildren = FlowProcessLayout.getProcessChildren(nestedContainer);
        for (IFigure iFigure : processChildren) {
            Dimension childPrefSize = iFigure.getPreferredSize();
            int distanceToMiddleY = FlowDimensionsCalculator.calculateDistanceToMiddleY(iFigure);
            int yOffset = this.calculateYOffset(iFigure, dimensions, distanceToMiddleY);
            Rectangle bounds = new Rectangle(xOffset, yOffset, childPrefSize.width, childPrefSize.height);
            this.setBoundsOfChild(nestedContainer, iFigure, bounds);
            xOffset += childPrefSize.width;
            xOffset += 35;
        }
    }

    private int calculateYOffset(IFigure child, FlowDimensions dimensions, int distanceToMiddleY) {
        if (child instanceof IResponseFigure) {
            return dimensions.getResponseMiddle() - distanceToMiddleY;
        }
        return dimensions.getRequestMiddle() - distanceToMiddleY;
    }

    protected Dimension calculatePreferredSize(IFigure nestedContainer, int wHint, int hHint) {
        List<? extends IFigure> flowChildren = FlowProcessLayout.collectFlowChildren(nestedContainer);
        FlowDimensions dimensions = FlowDimensionsCalculator.getInstance().calculate(flowChildren);
        this.setFlowDimensions(dimensions);
        int responseHeight = dimensions.getResponseHeight();
        int totalWidth = this.calculateWidth(nestedContainer);
        int requestHeight = dimensions.getRequestHeight();
        int prefHeight = responseHeight > 0 ? requestHeight + 25 + responseHeight : requestHeight;
        Dimension preferred = new Dimension(totalWidth, prefHeight);
        return preferred;
    }

    protected int calculateWidth(IFigure container) {
        int currWidth = 0;
        List children = container.getChildren();
        for (IFigure child : children) {
            Dimension childPref = child.getPreferredSize();
            currWidth += childPref.width;
            currWidth += 35;
        }
        if (currWidth > 0) {
            currWidth -= 35;
        }
        return Math.max(currWidth += container.getInsets().getWidth(), this.getBorderPreferredSize((IFigure)container).width);
    }

    public static List<? extends IFigure> collectFlowChildren(IFigure nestedContainer) {
        IFigure input = FlowProcessLayout.getInputChild(nestedContainer);
        List<? extends IFigure> processChildren = FlowProcessLayout.getProcessChildren(nestedContainer);
        ArrayList flowChildren = Lists.newArrayList();
        if (input != null) {
            flowChildren.add(input);
        }
        flowChildren.addAll(processChildren);
        return flowChildren;
    }

    private static List<? extends IFigure> getProcessChildren(IFigure nestedContainer) {
        return nestedContainer.getChildren();
    }

    private static IFigure getInputChild(IFigure nestedContainer) {
        IFigure containerRow = nestedContainer.getParent().getParent();
        NestedContainerFigure inputContainer = (NestedContainerFigure)((Object)containerRow.getChildren().get(0));
        Figure contentFigure = inputContainer.getContentFigure();
        if (contentFigure.getChildren().isEmpty() || contentFigure.getChildren().get(0) instanceof Label) {
            return null;
        }
        IFigure input = (IFigure)contentFigure.getChildren().get(0);
        return input;
    }

    protected void setBoundsOfChild(IFigure parent, IFigure child, Rectangle bounds) {
        parent.getClientArea(Rectangle.SINGLETON);
        bounds.translate(Rectangle.SINGLETON.x, Rectangle.SINGLETON.y);
        child.setBounds(bounds);
    }

    @Override
    public FlowDimensions getFlowDimensions() {
        return this.flowDimensions;
    }

    protected void setFlowDimensions(FlowDimensions flowDimensions) {
        this.flowDimensions = flowDimensions;
    }
}

