/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.layout;

import com.google.common.base.Optional;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.mule.tooling.core.model.ResponseNodeUtils;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editpart.ContainerEditPart;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.editpart.NestedContainerEditPart;
import org.mule.tooling.messageflow.layout.NestedContainerChildrenCreator;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.decorator.ConnectorType;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;

public class FlowProcessChildrenCreator
implements NestedContainerChildrenCreator {
    private static final String RESPONSE = "response";
    private static final String REQUEST = "request";
    private static final String ALL = "all";

    @Override
    public List<EntityDecorator<?>> createChildren(NestedContainerEditPart editPart) {
        EntityDecorator entityDecorator = editPart.getEntityDecorator();
        entityDecorator.getInbound().clear();
        entityDecorator.getOutbound().clear();
        NestedContainer nestedContainerEntity = (NestedContainer)editPart.getEntity();
        List nestedContainerChildren = nestedContainerEntity.getCompartmentLaneEntries();
        NestedContainerEditPart inputNestedContainer = this.getInputNestedContainer(editPart);
        Optional<EntityDecorator<?>> inputEntity = this.getInputEntity(inputNestedContainer);
        ListMultimap<String, EntityDecorator<?>> multimap = this.getOrCreateWrappedEntities(editPart, nestedContainerChildren, inputEntity);
        List requestDecorators = multimap.get((Object)REQUEST);
        Optional<EntityEditPart<?>> inputEditPartOpt = this.getFirstChild(inputNestedContainer);
        this.clearArrowsFromInput(inputEditPartOpt);
        this.drawInitialRequestArrow(inputEditPartOpt, requestDecorators);
        this.drawRequestConnections(requestDecorators);
        boolean shouldDrawResponse = this.shouldDrawResponse(inputEntity, multimap);
        if (shouldDrawResponse) {
            this.drawResponseFlowConnections(inputEntity, multimap.get((Object)RESPONSE));
            this.drawResponseTerminator(inputEntity, multimap);
        }
        if (inputEditPartOpt.isPresent()) {
            ((EntityEditPart)inputEditPartOpt.get()).refreshSourceConnections();
            ((EntityEditPart)inputEditPartOpt.get()).refreshTargetConnections();
        }
        List modelEntities = shouldDrawResponse ? multimap.get((Object)ALL) : multimap.get((Object)REQUEST);
        return modelEntities;
    }

    private void clearArrowsFromInput(Optional<EntityEditPart<?>> inputEditPartOpt) {
        if (inputEditPartOpt.isPresent()) {
            EntityEditPart inputEditPart = (EntityEditPart)inputEditPartOpt.get();
            EntityDecorator inputDecorator = inputEditPart.getEntityDecorator();
            inputDecorator.getInbound().clear();
            inputDecorator.getOutbound().clear();
        }
    }

    private boolean shouldDrawResponse(Optional<EntityDecorator<?>> inputEntity, ListMultimap<String, EntityDecorator<?>> multimap) {
        return !multimap.get((Object)RESPONSE).isEmpty();
    }

    private Optional<EntityEditPart<?>> getFirstChild(EntityEditPart<?> editPart) {
        if (CollectionUtils.isNotEmpty((Collection)editPart.getChildren())) {
            EntityEditPart inputEditPart = (EntityEditPart)editPart.getChildren().get(0);
            return Optional.of((Object)inputEditPart);
        }
        return Optional.absent();
    }

    private Optional<EntityDecorator<?>> getInputEntity(NestedContainerEditPart inputNested) {
        if (CollectionUtils.isNotEmpty((Collection)inputNested.getChildren())) {
            EntityEditPart inputEditPart = (EntityEditPart)inputNested.getChildren().get(0);
            EntityDecorator inputDecorator = inputEditPart.getEntityDecorator();
            return Optional.of(inputDecorator);
        }
        return Optional.absent();
    }

    private NestedContainerEditPart getInputNestedContainer(NestedContainerEditPart editPart) {
        ContainerEditPart container = editPart.getParentContainer();
        NestedContainerEditPart inputNested = container.getNestedContainer(0);
        return inputNested;
    }

    private void drawResponseTerminator(Optional<EntityDecorator<?>> inputEntity, ListMultimap<String, EntityDecorator<?>> multimap) {
        Optional<EntityDecorator<?>> lastValidResponseSource = this.getLastValidResponseSource(multimap.get((Object)REQUEST));
        Optional<EntityDecorator<?>> lastRequest = this.getLastDecorator(multimap.get((Object)REQUEST));
        Optional<EntityDecorator<?>> lastResponse = this.getLastDecorator(multimap.get((Object)RESPONSE));
        if (lastValidResponseSource.isPresent() && !lastValidResponseSource.equals(lastResponse)) {
            int lastResponseIndex;
            int lastValidResponseSourceIndex = multimap.get((Object)ALL).indexOf(lastValidResponseSource.get());
            int lastRequestIndex = multimap.get((Object)ALL).indexOf(lastRequest.get());
            int n = lastResponseIndex = lastResponse.isPresent() ? multimap.get((Object)ALL).indexOf(lastResponse.get()) : -1;
            if (lastValidResponseSourceIndex < lastResponseIndex) {
                if (!lastRequest.equals(lastValidResponseSource) && lastRequestIndex < lastResponseIndex) {
                    this.createConnectorAndRefresh(lastValidResponseSource, lastResponse, ConnectorType.RESPONSE_TERMINATOR_3);
                } else {
                    this.createConnectorAndRefresh(lastValidResponseSource, lastResponse, ConnectorType.RESPONSE_TERMINATOR_2);
                }
            } else if (!lastValidResponseSource.equals(lastResponse)) {
                this.createConnectorAndRefresh(lastValidResponseSource, lastResponse, ConnectorType.RESPONSE_TERMINATOR);
            }
        }
    }

    private void createConnectorAndRefresh(Optional<EntityDecorator<?>> lastValidResponseSource, Optional<EntityDecorator<?>> lastResponse, ConnectorType connectorType) {
        MessageFlowFactory.createConnector((EntityDecorator)((EntityDecorator)lastValidResponseSource.get()), (EntityDecorator)((EntityDecorator)lastResponse.get()), (ConnectorType)connectorType);
    }

    private void drawInitialRequestArrow(Optional<EntityEditPart<?>> firstChild, List<EntityDecorator<?>> requestDecorators) {
        if (CollectionUtils.isNotEmpty(requestDecorators) && firstChild.isPresent()) {
            EntityEditPart inputEditPart = (EntityEditPart)firstChild.get();
            EntityDecorator<?> firstElement = requestDecorators.get(0);
            MessageFlowFactory.createConnector(inputEditPart.getEntityDecorator(), firstElement, (ConnectorType)ConnectorType.REQUEST_FLOW);
            inputEditPart.refreshSourceConnections();
            inputEditPart.refreshTargetConnections();
        }
    }

    private Optional<EntityDecorator<?>> getLastDecorator(List<EntityDecorator<?>> decorators) {
        if (decorators.size() > 0) {
            return Optional.of(decorators.get(decorators.size() - 1));
        }
        return Optional.absent();
    }

    private Optional<EntityDecorator<?>> getLastValidResponseSource(List<EntityDecorator<?>> decorators) {
        int i = decorators.size() - 1;
        while (i >= 0) {
            EntityDecorator<?> decorator = decorators.get(i);
            if (ResponseNodeUtils.isValidResponseSource(decorator)) {
                return Optional.of(decorator);
            }
            --i;
        }
        return Optional.absent();
    }

    private void drawRequestConnections(List<EntityDecorator<?>> requestDecorators) {
        EntityDecorator<?> last = null;
        for (EntityDecorator<?> entityDecorator : requestDecorators) {
            this.drawConnection(last, entityDecorator, ConnectorType.REQUEST_FLOW);
            last = entityDecorator;
        }
    }

    private void drawResponseFlowConnections(Optional<EntityDecorator<?>> inputEntity, List<EntityDecorator<?>> responseDecorators) {
        EntityDecorator<?> last = null;
        for (EntityDecorator<?> entityDecorator : responseDecorators) {
            this.drawConnection(entityDecorator, last, ConnectorType.RESPONSE_FLOW);
            last = entityDecorator;
        }
    }

    private ListMultimap<String, EntityDecorator<?>> getOrCreateWrappedEntities(NestedContainerEditPart editPart, List<IMessageFlowEntity> entities, Optional<EntityDecorator<?>> inputEntity) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        if (inputEntity.isPresent() && ResponseNodeUtils.isRequestResponse((IMessageFlowEntity)((EntityDecorator)inputEntity.get()).getEntity())) {
            multimap.put((Object)RESPONSE, (Object)((EntityDecorator)inputEntity.get()));
        }
        for (IMessageFlowEntity entity : entities) {
            EntityDecorator<?> wrappedEntity = this.getOrCreateWrappedEntity(editPart, entity);
            multimap.put((Object)ALL, wrappedEntity);
            multimap.put((Object)REQUEST, wrappedEntity);
        }
        return multimap;
    }

    private EntityDecorator<?> getOrCreateWrappedEntity(NestedContainerEditPart editPart, IMessageFlowEntity childEntity) {
        EntityEditPart<?> entityEditPart = MessageFlowEditor.findEditPartInRegistry(editPart.getViewer(), childEntity);
        EntityDecorator wrappedEntity = null;
        if (entityEditPart != null) {
            wrappedEntity = entityEditPart.getEntityDecorator();
            wrappedEntity.getInbound().clear();
            wrappedEntity.getOutbound().clear();
        } else {
            wrappedEntity = MessageFlowFactory.getWrappedEntity((IMessageFlowEntity)childEntity);
        }
        return wrappedEntity;
    }

    private void drawConnection(EntityDecorator<?> last, EntityDecorator<?> wrappedEntity, ConnectorType type) {
        if (last != null && wrappedEntity != null) {
            MessageFlowFactory.createConnector(last, wrappedEntity, (ConnectorType)type);
        }
    }
}

