/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.layout;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.mule.tooling.messageflow.figure.NestedContainerFigure;
import org.mule.tooling.messageflow.layout.FlowDimensions;
import org.mule.tooling.messageflow.layout.FlowDimensionsCalculator;

public class FlowInputLayout
extends AbstractLayout {
    protected static final int INTER_NODE_SPACING = 35;

    public void layout(IFigure nestedContainer) {
        Optional<IFigure> childOpt = this.getInputChild(nestedContainer);
        List<IFigure> flowChildren = this.collectFlowChildren(nestedContainer);
        FlowDimensionsCalculator calculator = FlowDimensionsCalculator.getInstance();
        FlowDimensions dimensions = calculator.calculate(flowChildren);
        if (childOpt.isPresent()) {
            IFigure child = (IFigure)childOpt.get();
            int distanceToMiddleY = FlowDimensionsCalculator.calculateDistanceToMiddleY(child);
            Dimension inputPrefSize = child.getPreferredSize();
            int yOffset = dimensions.getRequestMiddle() - distanceToMiddleY;
            int textMiddle = calculator.calculateMaxTextMiddle(flowChildren);
            if (child instanceof Label) {
                yOffset += textMiddle;
            }
            Rectangle bounds = new Rectangle(0, yOffset, inputPrefSize.width, inputPrefSize.height);
            this.setBoundsOfChild(nestedContainer, child, bounds);
        }
    }

    private List<IFigure> collectFlowChildren(IFigure nestedContainer) {
        Optional<IFigure> input = this.getInputChild(nestedContainer);
        IFigure containerRow = nestedContainer.getParent().getParent();
        NestedContainerFigure nestedContainerFigure = (NestedContainerFigure)((Object)containerRow.getChildren().get(1));
        List processChildren = nestedContainerFigure.getContentFigure().getChildren();
        ArrayList flowChildren = Lists.newArrayList();
        if (input.isPresent()) {
            flowChildren.add((IFigure)input.get());
        }
        flowChildren.addAll(processChildren);
        return flowChildren;
    }

    private Optional<IFigure> getInputChild(IFigure nestedContainer) {
        List children = nestedContainer.getChildren();
        if (children.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of((Object)((IFigure)children.get(0)));
    }

    protected Dimension calculatePreferredSize(IFigure nestedContainer, int wHint, int hHint) {
        List<IFigure> flowChildren = this.collectFlowChildren(nestedContainer);
        FlowDimensions dimensions = FlowDimensionsCalculator.getInstance().calculate(flowChildren);
        int responseHeight = dimensions.getResponseHeight();
        int totalWidth = this.calculateWidth(nestedContainer);
        int requestHeight = dimensions.getRequestHeight();
        int totalHeight = responseHeight > 0 ? requestHeight + 25 + responseHeight : requestHeight;
        Dimension preferred = new Dimension(totalWidth, totalHeight);
        return preferred;
    }

    private int calculateWidth(IFigure container) {
        int currWidth = 0;
        List children = container.getChildren();
        for (IFigure child : children) {
            Dimension childPref = child.getPreferredSize();
            currWidth += childPref.width;
            currWidth += 35;
        }
        if (currWidth > 35) {
            currWidth -= 35;
        }
        return currWidth += container.getInsets().getWidth();
    }

    protected void setBoundsOfChild(IFigure parent, IFigure child, Rectangle bounds) {
        parent.getClientArea(Rectangle.SINGLETON);
        bounds.translate(Rectangle.SINGLETON.x, Rectangle.SINGLETON.y);
        child.setBounds(bounds);
    }
}

