/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.layout;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.SWTException;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.messageflow.figure.CommentFigure;
import org.mule.tooling.messageflow.figure.EndpointFigure;
import org.mule.tooling.messageflow.figure.IResponseFigure;
import org.mule.tooling.messageflow.figure.NodeFigure;
import org.mule.tooling.messageflow.figure.ParagraphTextFlowLabel;
import org.mule.tooling.messageflow.figure.PatternFigure;
import org.mule.tooling.messageflow.figure.RequestResponseFigure;
import org.mule.tooling.messageflow.figure.UnknownFigure;
import org.mule.tooling.messageflow.layout.FlowDimensions;

public class FlowDimensionsCalculator {
    public static final int REQ_RESP_SPACING = 25;
    private static final int DEFAULT_DISTANCE_TO_ICON_MIDDLE_Y = 26;
    private static final FlowDimensionsCalculator instance = new FlowDimensionsCalculator();

    public static FlowDimensionsCalculator getInstance() {
        return instance;
    }

    public FlowDimensions calculate(List<? extends IFigure> children) {
        FlowDimensions dimensions = new FlowDimensions();
        int requestMiddle = this.calculateMaxDistanceToMiddleY(children);
        int requestHeight = this.calculateMaxRequestHeight(children, requestMiddle);
        int responseHeight = this.calculateMaxResponseHeight(children);
        int responseMiddle = responseHeight > 0 ? requestHeight + 25 + responseHeight / 2 : 0;
        this.setRequestResponseDistance(children, responseMiddle - requestMiddle);
        dimensions.setRequestHeight(requestHeight);
        dimensions.setResponseHeight(responseHeight);
        dimensions.setRequestMiddle(requestMiddle);
        dimensions.setResponseMiddle(responseMiddle);
        return dimensions;
    }

    public int calculateMaxTextMiddle(List<? extends IFigure> children) {
        int maxHeight = 0;
        int middleTextMaxHeight = 0;
        IFigure figureMaxHeight = children.get(0);
        for (IFigure iFigure : children) {
            if (maxHeight >= FlowDimensionsCalculator.calculateHeight(iFigure)) continue;
            maxHeight = FlowDimensionsCalculator.calculateHeight(iFigure);
            figureMaxHeight = iFigure;
        }
        if (figureMaxHeight.getChildren().size() > 1 && figureMaxHeight.getChildren().get(1) instanceof ParagraphTextFlowLabel) {
            ParagraphTextFlowLabel paragraphTextFlowLabel = (ParagraphTextFlowLabel)figureMaxHeight.getChildren().get(1);
            middleTextMaxHeight = paragraphTextFlowLabel.getBounds().height / 2;
        }
        return middleTextMaxHeight;
    }

    public static int calculateHeight(IFigure figure) {
        int height = 0;
        int figureTopInset = 0;
        try {
            if (figure instanceof PatternFigure || figure instanceof UnknownFigure || figure instanceof CommentFigure || figure instanceof EndpointFigure) {
                int figureHeight = figure.getPreferredSize().height;
                figureTopInset = figure.getInsets().top;
                height = figureHeight / 2 + figureTopInset;
            } else {
                if (figure instanceof RequestResponseFigure) {
                    RequestResponseFigure reqres = (RequestResponseFigure)figure;
                    return FlowDimensionsCalculator.calculateHeight((IFigure)reqres.getRequestFigure());
                }
                height = figure.getPreferredSize().height / 2;
            }
            return height;
        }
        catch (SWTException e) {
            e.printStackTrace();
            return height;
        }
    }

    private int calculateMaxDistanceToMiddleY(List<? extends IFigure> children) {
        int maxDistanceToMiddleY = 0;
        for (IFigure iFigure : children) {
            if (iFigure instanceof IResponseFigure) continue;
            maxDistanceToMiddleY = Math.max(maxDistanceToMiddleY, FlowDimensionsCalculator.calculateDistanceToMiddleY(iFigure));
        }
        return maxDistanceToMiddleY;
    }

    private void setRequestResponseDistance(List<? extends IFigure> children, int distance) {
        for (RequestResponseFigure reqRes : CoreUtils.filterByType(children, RequestResponseFigure.class)) {
            reqRes.setRequestResponseDistance(distance);
        }
    }

    private int calculateRequestHeight(IFigure figure, int requestMiddle) {
        int reqHeight;
        if (figure instanceof IResponseFigure) {
            reqHeight = 0;
        } else if (figure instanceof RequestResponseFigure) {
            NodeFigure req = ((RequestResponseFigure)figure).getRequestFigure();
            Dimension reqSize = req.getPreferredSize();
            reqHeight = reqSize.height + figure.getInsets().top + figure.getInsets().bottom;
        } else {
            Dimension childPref = figure.getPreferredSize();
            reqHeight = childPref.height;
        }
        return reqHeight + requestMiddle - FlowDimensionsCalculator.calculateDistanceToMiddleY(figure);
    }

    private int calculateMaxRequestHeight(List<? extends IFigure> children, int requestMiddle) {
        int maxHeight = 0;
        for (IFigure iFigure : children) {
            int height = this.calculateRequestHeight(iFigure, requestMiddle);
            maxHeight = Math.max(maxHeight, height);
        }
        return maxHeight;
    }

    private int calculateMaxResponseHeight(List<? extends IFigure> children) {
        int maxHeight = 0;
        for (IFigure iFigure : children) {
            maxHeight = Math.max(maxHeight, this.calculateResponseHeight(iFigure));
        }
        return maxHeight;
    }

    private int calculateResponseHeight(IFigure child) {
        int height;
        Dimension childPref = child.getPreferredSize();
        if (child instanceof IResponseFigure) {
            height = childPref.height;
        } else if (child instanceof RequestResponseFigure) {
            IFigure resp = ((RequestResponseFigure)child).getResponseFigure();
            Dimension respSize = resp.getPreferredSize();
            height = respSize.height;
        } else {
            height = 0;
        }
        return height;
    }

    public static int calculateDistanceToMiddleY(IFigure figure) {
        int distanceToMiddleY = 26;
        try {
            if (figure instanceof PatternFigure || figure instanceof UnknownFigure || figure instanceof CommentFigure || figure instanceof EndpointFigure) {
                ImageFigure imageFigure = (ImageFigure)figure.getChildren().get(0);
                int iconHeight = imageFigure.getPreferredSize().height;
                int figureTopInset = figure.getInsets().top;
                distanceToMiddleY = iconHeight / 2 + figureTopInset;
            } else {
                if (figure instanceof RequestResponseFigure) {
                    RequestResponseFigure reqres = (RequestResponseFigure)figure;
                    return FlowDimensionsCalculator.calculateDistanceToMiddleY((IFigure)reqres.getRequestFigure());
                }
                distanceToMiddleY = figure.getPreferredSize().height / 2;
            }
            return distanceToMiddleY;
        }
        catch (SWTException e) {
            e.printStackTrace();
            return 26;
        }
    }
}

