/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.layout;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.mule.tooling.messageflow.layout.ContainerLayoutFactory;

public class ContainerLayoutFactoryManager {
    private static ContainerLayoutFactoryManager instance;
    private Map<String, ContainerLayoutFactory> idToLayoutFactoryMap = Maps.newHashMap();

    public static ContainerLayoutFactoryManager instance() {
        if (instance == null) {
            instance = new ContainerLayoutFactoryManager();
        }
        return instance;
    }

    private ContainerLayoutFactoryManager() {
        this.initialize();
    }

    private void initialize() {
        try {
            IConfigurationElement[] configurationElements;
            IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.mule.tooling.messageflow.containerLayoutFactory");
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                String layoutFactoryId = configurationElement.getAttribute("layoutFactoryId");
                ContainerLayoutFactory layoutManager = this.instantiateLayoutManager(configurationElement);
                this.idToLayoutFactoryMap.put(layoutFactoryId, layoutManager);
                ++n2;
            }
        }
        catch (CoreException e) {
            throw new RuntimeException("Failed loading container layouts extension point", e);
        }
    }

    public Optional<ContainerLayoutFactory> getLayoutFactory(String layoutFactoryId) {
        return Optional.fromNullable((Object)this.idToLayoutFactoryMap.get(layoutFactoryId));
    }

    protected ContainerLayoutFactory instantiateLayoutManager(IConfigurationElement configurationElement) throws CoreException {
        return (ContainerLayoutFactory)ContainerLayoutFactory.class.cast(configurationElement.createExecutableExtension("layoutFactoryClass"));
    }
}

