/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.layout;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.mule.tooling.messageflow.layout.NestedContainerChildrenCreator;

public class ContainerChildrenCreatorManager {
    private static ContainerChildrenCreatorManager instance;
    private Map<String, NestedContainerChildrenCreator> idToChildrenCreatorManagerMap = Maps.newHashMap();

    public static ContainerChildrenCreatorManager instance() {
        if (instance == null) {
            instance = new ContainerChildrenCreatorManager();
        }
        return instance;
    }

    private ContainerChildrenCreatorManager() {
        this.initialize();
    }

    private void initialize() {
        try {
            IConfigurationElement[] configurationElements;
            IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.mule.tooling.messageflow.containerChildrenCreator");
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                String childrenCreatorId = configurationElement.getAttribute("childrenCreatorId");
                NestedContainerChildrenCreator childrenCreator = this.instantiateChildrenCreator(configurationElement);
                this.idToChildrenCreatorManagerMap.put(childrenCreatorId, childrenCreator);
                ++n2;
            }
        }
        catch (CoreException e) {
            throw new RuntimeException("Failed loading extension point", e);
        }
    }

    public Optional<NestedContainerChildrenCreator> getChildrenCreator(String childrenCreatorId) {
        return Optional.fromNullable((Object)this.idToChildrenCreatorManagerMap.get(childrenCreatorId));
    }

    protected NestedContainerChildrenCreator instantiateChildrenCreator(IConfigurationElement configurationElement) throws CoreException {
        return (NestedContainerChildrenCreator)NestedContainerChildrenCreator.class.cast(configurationElement.createExecutableExtension("childrenCreatorClass"));
    }
}

