/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.internal;

import java.text.MessageFormat;
import java.util.Optional;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.generator.errors.messageflow.MessageFlowEntityError;
import org.mule.tooling.core.generator.errors.messageflow.MuleErrorFactory;
import org.mule.tooling.core.sax.SAXUtils;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.icons.ImagesManager;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.GlobalUnknown;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.model.messageflow.path.MulePathsCache;
import org.mule.tooling.model.module.GlobalDefinition;
import org.mule.tooling.utils.Pair;

public class StyledGlobalElementLabelProvider
extends StyledCellLabelProvider {
    private static final String CONFIGURATION_LABEL = "Configuration";
    private static final String ENDPOINT_LABEL = "Endpoint";
    private static final String CATEGORY_GLOBAL_ENDPOINTS = "org.mule.tooling.globalCategory.globalEndpoints";
    private MessageFlowEditor messageFlowEditor;

    public StyledGlobalElementLabelProvider(MessageFlowEditor messageFlowEditor) {
        this.messageFlowEditor = messageFlowEditor;
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        int columnIndex = cell.getColumnIndex();
        cell.setImage(this.getColumnImage(element, columnIndex));
        Pair<String, StyleRange[]> columnTextAndStyles = this.getColumnTextAndStyles(element, columnIndex);
        cell.setText((String)columnTextAndStyles.getLeft());
        cell.setStyleRanges((StyleRange[])columnTextAndStyles.getRight());
        super.update(cell);
    }

    private Image getColumnImage(Object element, int columnIndex) {
        MessageFlowEntity entity = (MessageFlowEntity)element;
        if (columnIndex == 0) {
            if (entity instanceof GlobalElement) {
                GlobalElement global = (GlobalElement)entity;
                if (this.hasError(global)) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                }
                return global.getDefinition().getIconImage();
            }
            return ImagesManager.getInstance().getPaletteUnknown();
        }
        return null;
    }

    private boolean hasError(GlobalElement global) {
        MulePathsCache pathsCache = this.messageFlowEditor.getMuleConfiguration().getPathsCache();
        IMarker[] problems = this.getMuleMarkersFromCurrentInput();
        MulePath globalPath = MulePath.fromPath((String)CoreUtils.getNameProperty((IMessageFlowNode)global));
        IMarker[] iMarkerArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            Optional maybeError = MuleErrorFactory.createMessageFlowErrorIfMarkerMatches((IMarker)marker);
            if (maybeError.isPresent()) {
                MessageFlowEntityError error = (MessageFlowEntityError)maybeError.get();
                MulePath path = MulePath.fromPath((String)error.getPath());
                if (pathsCache.getEntity(globalPath, this.messageFlowEditor.getMuleProject()) != null && globalPath.equals((Object)path)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private Pair<String, StyleRange[]> getColumnTextAndStyles(Object element, int columnIndex) {
        MessageFlowEntity entity = (MessageFlowEntity)element;
        switch (columnIndex) {
            case 0: {
                if (entity instanceof GlobalElement) {
                    GlobalElement global = (GlobalElement)entity;
                    GlobalDefinition definition = (GlobalDefinition)global.getDefinition();
                    String definitionName = definition.getName();
                    String typeDescription = definition.getCategoryId().equals(CATEGORY_GLOBAL_ENDPOINTS) ? ENDPOINT_LABEL : CONFIGURATION_LABEL;
                    String label = MessageFormat.format("{0} ({1})", definitionName, typeDescription);
                    StyleRange styleRange = new StyleRange(definitionName.length(), label.length() - definitionName.length(), Display.getCurrent().getSystemColor(15), null);
                    return Pair.of((Object)label, (Object)new StyleRange[]{styleRange});
                }
                return Pair.of((Object)"Unknown", (Object)new StyleRange[0]);
            }
            case -1: {
                if (entity instanceof GlobalElement) {
                    GlobalElement global = (GlobalElement)entity;
                    return Pair.of((Object)global.getName(), (Object)new StyleRange[0]);
                }
                if (entity instanceof GlobalUnknown) {
                    GlobalUnknown unknown = (GlobalUnknown)entity;
                    try {
                        Document subdoc = SAXUtils.parseXML((String)unknown.getContent());
                        return Pair.of((Object)subdoc.getRootElement().getName(), (Object)new StyleRange[0]);
                    }
                    catch (DocumentException documentException) {
                        return null;
                    }
                }
            }
            case 1: {
                if (entity instanceof GlobalElement) {
                    GlobalElement global = (GlobalElement)entity;
                    PropertyCollectionMap map = new PropertyCollectionMap(global.getProperties());
                    String idNameProperty = map.getProperty("name", null);
                    if (idNameProperty == null && global.getName() != null) {
                        idNameProperty = global.getName();
                    }
                    return Pair.of((Object)(idNameProperty != null ? idNameProperty : "<no name>"), (Object)new StyleRange[0]);
                }
                if (entity instanceof GlobalUnknown) {
                    GlobalUnknown unknown = (GlobalUnknown)entity;
                    return Pair.of((Object)unknown.getContent(), (Object)new StyleRange[0]);
                }
            }
            case 2: {
                if (entity instanceof GlobalElement) {
                    GlobalElement global = (GlobalElement)entity;
                    return Pair.of((Object)global.getDescription(), (Object)new StyleRange[0]);
                }
                if (!(entity instanceof GlobalUnknown)) break;
                GlobalUnknown unknown = (GlobalUnknown)entity;
                return Pair.of((Object)unknown.getContent(), (Object)new StyleRange[0]);
            }
        }
        return null;
    }

    private IMarker[] getMuleMarkersFromCurrentInput() {
        try {
            IFile inputXmlConfigFile = this.messageFlowEditor.getInputXmlConfigFile();
            int depth = 0;
            return inputXmlConfigFile.findMarkers("org.mule.tooling.core.muleError", true, depth);
        }
        catch (CoreException ex) {
            MuleCorePlugin.logError((String)"Unexpected error getting error markers of type org.mule.tooling.core.muleError", (Throwable)ex);
            return new IMarker[0];
        }
    }
}

