/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.mule.tooling.messageflow.util.GlobalElementUtils;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.GlobalUnknown;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;

public class GlobalElementEditorHelper {
    public Optional<String> getNameReplacement(GlobalElement globalElement, List<IMessageFlowEntity> globalElements) {
        ArrayList<GlobalElement> candidates = new ArrayList<GlobalElement>();
        for (IMessageFlowEntity entity : globalElements) {
            GlobalElement global;
            if (entity == globalElement || !(entity instanceof GlobalElement) || (global = (GlobalElement)entity).getDefinition() != globalElement.getDefinition()) continue;
            candidates.add(global);
        }
        if (candidates.size() == 1) {
            GlobalElement element = (GlobalElement)candidates.get(0);
            String name = element.getProperties() != null ? this.extractName(element.getProperties().getProperties()) : element.getName();
            return Optional.of(name);
        }
        return Optional.empty();
    }

    public String extractName(List<? extends IReadOnlyProperty> properties) {
        IReadOnlyProperty property = GlobalElementUtils.findProperty(properties, "name");
        return property != null ? property.getValue() : null;
    }

    public List<IMessageFlowEntity> getFilteredGlobal(List<IMessageFlowEntity> globalEntries) {
        ArrayList<IMessageFlowEntity> newGlobalEntries = new ArrayList<IMessageFlowEntity>();
        for (IMessageFlowEntity ge : globalEntries) {
            GlobalUnknown gu;
            IMessageFlowEntity value = ge;
            if (value instanceof GlobalUnknown && (gu = (GlobalUnknown)value).getDescription()) continue;
            newGlobalEntries.add(ge);
        }
        return newGlobalEntries;
    }
}

