/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.handler;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.Activator;
import org.mule.tooling.messageflow.dialog.DialogStack;
import org.mule.tooling.messageflow.dialog.ISimpleHost;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.handler.IGoToImplementationHandler;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.utils.Pair;

public class ShowFlowHandler
implements IGoToImplementationHandler {
    @Override
    public void execute(MessageFlowNode messageFlowNode) {
        IReadOnlyProperty nameProperty;
        MessageFlowNode node = messageFlowNode;
        ISimpleHost[] allHosts = DialogStack.getAllHosts();
        if (allHosts.length > 0) {
            ISimpleHost simpleHost = allHosts[0];
            node = MessageFlowUtils.generateNodeToTest((IMessageFlowNode)messageFlowNode, simpleHost);
        }
        if ((nameProperty = (IReadOnlyProperty)node.getProperties().getProperty("name")) != null) {
            ShowFlowHandler.goToFlowWithName(nameProperty.getValue());
        }
    }

    public static void goToFlowWithName(String flowName) {
        IMuleProject muleProject = MuleCorePlugin.getDesignContext().getMuleProject();
        Pair referencedFlowPair = muleProject.getConfigurationsCache().searchMuleFlowByName(flowName);
        if (referencedFlowPair != null && referencedFlowPair.getLeft() != null) {
            try {
                IFile file = muleProject.getConfigurationsCache().getConfigurationFile((MuleConfiguration)referencedFlowPair.getLeft());
                if (file != null && file.exists()) {
                    ShowFlowHandler.openEditor(file);
                }
            }
            catch (PartInitException e) {
                throw new RuntimeException("Error opening flow editor", e);
            }
            ShowFlowHandler.selectFlow(flowName);
        }
    }

    public static void openConfigWithConfigName(IMuleProject muleProject, String toFind) {
        try {
            for (IFile xmlConfigFile : muleProject.getConfigurationsCache().getConfigurationResources()) {
                String nameWithoutSuffix = xmlConfigFile.getName().replaceAll(".xml", "");
                if (!nameWithoutSuffix.equalsIgnoreCase(toFind)) continue;
                ShowFlowHandler.openEditor(xmlConfigFile);
                return;
            }
            throw new RuntimeException("Couldn't find a config file that matches the name " + toFind);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    private static void openEditor(IFile fileToOpen) throws PartInitException {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IDE.openEditor((IWorkbenchPage)page, (IFile)fileToOpen);
        }
        catch (PartInitException e) {
            Activator.getDefault().getLog().log(e.getStatus());
            throw e;
        }
    }

    public static EntityEditPart<?> selectFlow(String flowName) {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        IEditorPart activeEditor = activePage.getActiveEditor();
        if (activeEditor instanceof MultiPageMessageFlowEditor) {
            MultiPageMessageFlowEditor editorPart = (MultiPageMessageFlowEditor)activeEditor;
            if (editorPart.getCurentPageIndex() != editorPart.getFlowEditorIndex()) {
                editorPart.openFlowEditorPage();
            }
            MessageFlowEditor flowEditor = editorPart.getFlowEditor();
            return ShowFlowHandler.selectFlowByName(flowEditor, flowName);
        }
        return null;
    }

    public static EntityEditPart<?> selectFlowByName(MessageFlowEditor flowEditor, String flowName) {
        List flows = flowEditor.getMuleConfiguration().getFlows();
        for (Container flow : flows) {
            EntityEditPart<?> match;
            if (flow.getName() == null || !flow.getName().equals(flowName) || (match = MessageFlowEditor.findEditPartInRegistry((EditPartViewer)flowEditor.getViewer(), (IMessageFlowEntity)flow)) == null) continue;
            flowEditor.asyncSelectAndScroll(match);
            return match;
        }
        return null;
    }
}

